/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditionType;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.registry.ConfigApiRegistry;
import net.pneumono.pneumonocore.util.CodecUtil;
import org.jetbrains.annotations.Nullable;

public record ConfigResourceCondition(class_2960 configuration, Operator operator, String value) implements ResourceCondition
{
    public static final MapCodec<ConfigResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("configuration").forGetter(ConfigResourceCondition::configuration), (App)Operator.CODEC.fieldOf("operation").forGetter(ConfigResourceCondition::operator), (App)Codec.STRING.fieldOf("value").forGetter(ConfigResourceCondition::value)).apply((Applicative)instance, ConfigResourceCondition::new));

    public ConfigResourceCondition(AbstractConfiguration<?> configuration, Operator operator, String value) {
        this(configuration.info().getId(), operator, value);
    }

    public ResourceConditionType<?> getType() {
        return ConfigApiRegistry.RESOURCE_CONDITION_CONFIGURATIONS;
    }

    public boolean test(@Nullable class_7225.class_7874 registryInfo) {
        AbstractConfiguration<?> config = ConfigApi.getConfig(this.configuration);
        if (config == null) {
            return false;
        }
        if (this.operator == Operator.EQUAL) {
            return this.value.equals(config.getValue().toString());
        }
        Object obj = config.getValue();
        if (obj instanceof Number) {
            double comparedValue;
            Number numericConfigValue = (Number)obj;
            try {
                comparedValue = Double.parseDouble(this.value);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            double configValue = numericConfigValue.doubleValue();
            return switch (this.operator.ordinal()) {
                case 1 -> {
                    if (configValue < comparedValue) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (configValue > comparedValue) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (configValue <= comparedValue) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (configValue >= comparedValue) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public static enum Operator {
        EQUAL,
        LESS,
        GREATER,
        LESS_OR_EQUAL,
        GREATER_OR_EQUAL;

        public static final Codec<Operator> CODEC;

        static {
            CODEC = CodecUtil.createEnumCodec((Enum[])Operator.values());
        }
    }
}

