/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.region;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.model.region.RegionHolder;
import journeymap.client.model.region.RegionKey;
import journeymap.common.Journeymap;

public class RegionCacheManager {
    public final long textureCacheAgeSecs = 30L;

    public LoadingCache<RegionKey, RegionHolder> initRegionHoldersCache(CacheBuilder<Object, Object> builder) {
        return builder.expireAfterAccess(30L, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<RegionKey, RegionHolder>(this){

            @ParametersAreNonnullByDefault
            public void onRemoval(RemovalNotification<RegionKey, RegionHolder> notification) {
                RegionHolder holder = (RegionHolder)notification.getValue();
                if (holder != null) {
                    int count = holder.writeImage(false);
                    if (count > 0 && Journeymap.getLogger().isDebugEnabled()) {
                        Journeymap.getLogger().debug("Wrote to disk before removal from cache: " + String.valueOf(holder));
                    }
                    holder.clear();
                }
            }
        }).build((CacheLoader)new CacheLoader<RegionKey, RegionHolder>(this){

            @ParametersAreNonnullByDefault
            public RegionHolder load(RegionKey key) {
                return new RegionHolder(key);
            }
        });
    }
}

