/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import journeymap.common.Journeymap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2791;
import net.minecraft.class_2804;
import net.minecraft.class_2808;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2852;
import net.minecraft.class_2902;
import net.minecraft.class_638;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Logger logger = Journeymap.getLogger();

    public static ProcessedChunk read(class_638 level, class_1923 chunkPos, class_2487 chunkTag) {
        block10: {
            try {
                if (class_2808.field_12807 != class_2852.method_12377((class_2487)chunkTag)) break block10;
                class_2804 lights = null;
                boolean lightOn = chunkTag.method_10577("isLightOn");
                class_2499 sections = chunkTag.method_10554("sections", 10);
                int sectionsCount = level.method_32890();
                class_2826[] chunkSections = new class_2826[sectionsCount];
                class_2378 registry = level.method_30349().method_30530(class_7924.field_41236);
                Codec codec = class_2852.method_39036((class_2378)registry);
                for (int j = 0; j < sections.size(); ++j) {
                    class_2487 section = sections.method_10602(j);
                    byte sectionTopY = section.method_10571("Y");
                    int sectionIndex = level.method_31603((int)sectionTopY);
                    try {
                        if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                            class_2826 chunkSection;
                            class_2841 blockStateContainer = section.method_10573("block_states", 10) ? (class_2841)class_2852.field_34576.parse((DynamicOps)class_2509.field_11560, (Object)section.method_10562("block_states")).promotePartial(stringx -> class_2852.method_39035((class_1923)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(class_2852.class_9314::new) : new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                            Object biomeContainer = section.method_10573("biomes", 10) ? (class_7522)codec.parse((DynamicOps)class_2509.field_11560, (Object)section.method_10562("biomes")).promotePartial(stringx -> class_2852.method_39035((class_1923)chunkPos, (int)sectionTopY, (String)stringx)).getOrThrow(class_2852.class_9314::new) : new class_2841(registry.method_40295(), (Object)registry.method_40290(class_1972.field_9451), class_2841.class_6563.field_34570);
                            chunkSections[sectionIndex] = chunkSection = new class_2826(blockStateContainer, (class_7522)biomeContainer);
                        }
                    }
                    catch (Exception e) {
                        throw new AutoMapChunkReaderException("Error parsing biome and block sections during automap >>", e);
                    }
                    if (!lightOn || !section.method_10573("BlockLight", 7)) continue;
                    byte[] lightsArray = section.method_10547("BlockLight");
                    lights = new class_2804(lightsArray);
                }
                class_2818 chunkAccess = null;
                class_2487 heightmaps = null;
                EnumSet<class_2902.class_2903> heightmapEnums = null;
                try {
                    chunkAccess = new class_2818((class_1937)level, chunkPos, null, null, null, 0L, chunkSections, null, null);
                    chunkAccess.method_12020(lightOn);
                    heightmaps = chunkTag.method_10562("Heightmaps");
                    heightmapEnums = EnumSet.noneOf(class_2902.class_2903.class);
                }
                catch (Exception e) {
                    throw new AutoMapChunkReaderException("Error creating LevelChunk during automap", e);
                }
                for (class_2902.class_2903 heightmapTypes : chunkAccess.method_12009().method_12160()) {
                    String key = heightmapTypes.method_12605();
                    if (heightmaps.method_10573(key, 12)) {
                        chunkAccess.method_12037(heightmapTypes, heightmaps.method_10565(key));
                        continue;
                    }
                    heightmapEnums.add(heightmapTypes);
                }
                class_2902.method_16684((class_2791)chunkAccess, heightmapEnums);
                return new ProcessedChunk(chunkAccess, lights);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error parsing chunk during automap >>", (Throwable)e);
            }
        }
        return null;
    }

    static class AutoMapChunkReaderException
    extends RuntimeException {
        public AutoMapChunkReaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public record ProcessedChunk(class_2818 chunk, class_2804 light) {
    }
}

