/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.event.EntityRadarUpdateEvent;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.ui.UIManager;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class EntityRadarUpdateEventHandler {
    public static EntityRadarUpdateEventHandler INSTANCE;

    private EntityRadarUpdateEventHandler() {
        ClientEventRegistry.ENTITY_RADAR_UPDATE_EVENT.subscribe("journeymap", this::onRadarEntityUpdateEvent);
    }

    public static EntityRadarUpdateEventHandler init() {
        if (INSTANCE == null) {
            INSTANCE = new EntityRadarUpdateEventHandler();
        }
        return INSTANCE;
    }

    private void onRadarEntityUpdateEvent(EntityRadarUpdateEvent event) {
        class_1297 livingEntity;
        if (JourneymapClient.getInstance().enabled() && !event.isCancelled() && event.getActiveUiState() != null && EntityRadarUpdateEvent.EntityType.MOB.equals((Object)event.getType()) && (livingEntity = (class_1297)event.getWrappedEntity().getEntityRef().get()) != null) {
            boolean showNames = EntityRadarUpdateEventHandler.getProperties((UIState)event.getActiveUiState()).showEntityNames.get();
            class_2561 name = EntityRadarUpdateEventHandler.getEntityName((EntityDTO)event.getWrappedEntity(), event.getActiveUiState(), showNames);
            if (!event.getWrappedEntity().isSneaking() && name != null) {
                event.getWrappedEntity().setCustomName(name);
                EntityRadarUpdateEventHandler.addEntityToolTips((EntityDTO)event.getWrappedEntity(), event.getActiveUiState(), name, showNames);
            }
        }
    }

    public static class_2561 getEntityName(EntityDTO entity, UIState activeUiState, boolean showNames) {
        InGameMapProperties properties = EntityRadarUpdateEventHandler.getProperties(activeUiState);
        class_5250 name = null;
        String baseName = null;
        class_1297 livingEntity = (class_1297)entity.entityRef.get();
        if (livingEntity != null) {
            if (showNames && properties.showHostileNames.get().booleanValue() && entity.getHostile().booleanValue()) {
                baseName = livingEntity.method_5477().getString();
            } else if (showNames && properties.showPassiveNames.get().booleanValue() && entity.isPassiveAnimal()) {
                baseName = livingEntity.method_5477().getString();
            } else if (showNames && properties.showPetNames.get().booleanValue() && entity.owner != null) {
                baseName = livingEntity.method_5477().getString();
            } else if (showNames && properties.showNpcNames.get().booleanValue() && entity.isNpc()) {
                baseName = livingEntity.method_5477().getString();
            } else if (showNames && properties.showVillagerNames.get().booleanValue() && entity.getProfession() != null) {
                baseName = livingEntity.method_5477().getString();
            } else if (showNames && properties.showAmbientNames.get().booleanValue() && entity.isAmbientCreature()) {
                baseName = livingEntity.method_5477().getString();
            } else if (properties.showNoIconNames.get().booleanValue() && entity.getEntityIconLocation() == null) {
                baseName = livingEntity.method_5477().getString();
            }
            if (baseName != null) {
                name = class_2561.method_43470((String)baseName);
                name.method_27694(style -> style.method_36139(entity.getLabelColor()).method_10982(Boolean.valueOf(true)));
            }
        }
        return name;
    }

    public static void addEntityToolTips(EntityDTO entity, UIState activeUiState, class_2561 name, boolean showNames) {
        InGameMapProperties properties = EntityRadarUpdateEventHandler.getProperties(activeUiState);
        if (!entity.isSneaking() && name != null) {
            class_5250 profession = null;
            class_1297 livingEntity = (class_1297)entity.getEntityRef().get();
            if (showNames && properties.showVillagerNames.get().booleanValue() && entity.getProfession() != null) {
                profession = class_2561.method_43470((String)(Constants.getString("jm.common.profession.label") + entity.getProfession()));
                int color = 0xFFFFFF;
                profession.method_27694(style -> style.method_36139(color));
            }
            String id = livingEntity.method_5653();
            class_5250 resource = null;
            if (id != null) {
                resource = class_2561.method_43470((String)id);
                int color = 0xFFFFFF;
                resource.method_27694(style -> style.method_36139(color));
            }
            EntityRadarUpdateEventHandler.addToolTips(entity, new class_2561[]{name, profession, resource});
        }
    }

    private static InGameMapProperties getProperties(UIState activeUiState) {
        if (Context.UI.Minimap.equals((Object)activeUiState.ui)) {
            return UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        }
        return JourneymapClient.getInstance().getFullMapProperties();
    }

    private static void addToolTips(EntityDTO entity, class_2561 ... toolTips) {
        ArrayList<class_2561> tips = new ArrayList<class_2561>();
        for (class_2561 tt : toolTips) {
            if (tt == null) continue;
            tips.add(tt);
        }
        if (!tips.isEmpty()) {
            entity.setEntityToolTips(tips);
        }
    }
}

