/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;

public class ChunkMonitorHandler {
    private class_1936 world;
    private static ChunkMonitorHandler instance;

    private ChunkMonitorHandler() {
    }

    public static ChunkMonitorHandler getInstance() {
        if (instance == null) {
            instance = new ChunkMonitorHandler();
        }
        return instance;
    }

    public void reset() {
        this.world = null;
    }

    public void resetRenderTimes(long pos) {
        ChunkMD chunkMD;
        if (JourneymapClient.getInstance().enabled() && (chunkMD = DataCache.INSTANCE.getChunkMD(pos)) != null && class_310.method_1551().field_1724 != null && chunkMD.getChunk().method_12200() == class_310.method_1551().field_1724.method_5770()) {
            chunkMD.resetRenderTimes();
        }
    }

    public void onChunkLoad(class_1936 world, class_2791 chunkAccess) {
        if (JourneymapClient.getInstance().enabled()) {
            class_2818 chunk;
            if (world == null || !world.method_8608() || !this.isLevelCurrent()) {
                return;
            }
            if (this.world == null) {
                this.world = world;
            }
            if ((chunk = (class_2818)chunkAccess) != null && class_310.method_1551().field_1724 != null && chunk.method_12200() == class_310.method_1551().field_1724.method_5770()) {
                DataCache.INSTANCE.addChunkMD(new ChunkMD(chunk));
            }
        }
    }

    public void onWorldUnload(class_1936 world) {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                if (world.equals((Object)this.world)) {
                    this.reset();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error handling WorldEvent.Unload", (Throwable)e);
            }
        }
    }

    public void onBlockUpdate(class_1936 world, class_2338 pos) {
        if (JourneymapClient.getInstance().enabled() && world != null && this.isLevelCurrent()) {
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            this.markBlockRangeForRenderUpdate(chunkX * 16, chunkZ * 16, chunkX * 16 + 15, chunkZ * 16 + 15);
        }
    }

    public void onChunkUpdate(class_1936 world, class_1923 pos) {
        if (JourneymapClient.getInstance().enabled() && world != null && this.isLevelCurrent()) {
            this.resetRenderTimes(pos.method_8324());
        }
    }

    private void markBlockRangeForRenderUpdate(int x1, int z1, int x2, int z2) {
        int cx1 = x1 >> 4;
        int cz1 = z1 >> 4;
        int cx2 = x2 >> 4;
        int cz2 = z2 >> 4;
        if (cx1 == cx2 && cz1 == cz2) {
            this.resetRenderTimes(class_1923.method_8331((int)cx1, (int)cz1));
        } else {
            for (int chunkXPos = cx1; chunkXPos < cx2; ++chunkXPos) {
                for (int chunkZPos = cz1; chunkZPos < cz2; ++chunkZPos) {
                    this.resetRenderTimes(class_1923.method_8331((int)chunkXPos, (int)chunkZPos));
                }
            }
        }
    }

    private boolean isLevelCurrent() {
        class_310 mc = class_310.method_1551();
        return mc.field_1687 != null && mc.field_1724 != null && mc.field_1687 == mc.field_1724.method_5770();
    }
}

