/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_465;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.KegEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.PouringEmiRecipe;

public class BnCEMIRecipeFiller {
    @Nullable
    public static Map<KegEmiRecipeHandler.InputType, List<class_1799>> getFermentingStacks(KegEmiRecipeHandler handler, FermentingEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount) {
        try {
            KegMenu menu = (KegMenu)context.getScreen().method_17577();
            if (handler != null) {
                HashMap desired = Maps.newHashMap();
                List<class_1735> slots = handler.getInputSources(menu);
                List<class_1735> craftingSlots = handler.getCraftingSlots(menu);
                List<EmiIngredient> itemIngredients = recipe.getItemInputs();
                EmiIngredient fluidIngredient = recipe.getFluidInput();
                EmiIngredient fluidItemIngredient = recipe.getFluidItemInput();
                EmiIngredient emptyingIngredient = KegEmiRecipeHandler.getEmptyingIngredient(recipe, context);
                if (!BnCEMIRecipeFiller.handleItemInputs(handler, recipe, (class_465<KegMenu>)context.getScreen(), amount, desired, itemIngredients, slots, craftingSlots)) {
                    return null;
                }
                if (fluidItemIngredient != null && !BnCEMIRecipeFiller.handleFillingInputs(handler, recipe, context, amount, desired, fluidIngredient, fluidItemIngredient, slots)) {
                    return null;
                }
                if (emptyingIngredient != null && !((KegMenu)context.getScreen().method_17577()).kegTank.isEmpty() && !BnCEMIRecipeFiller.handleEmptyingInputs(handler, recipe, context, amount, desired, emptyingIngredient, slots)) {
                    return null;
                }
                return desired;
            }
        }
        catch (Exception ex) {
            BrewinAndChewin.LOG.error("Failed to get fermenting recipe stacks. ", (Throwable)ex);
        }
        return null;
    }

    @Nullable
    public static List<class_1799> getPouringStacks(KegEmiRecipeHandler handler, PouringEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount) {
        try {
            KegMenu menu = (KegMenu)context.getScreen().method_17577();
            if (handler != null) {
                HashMap desired = Maps.newHashMap();
                List<class_1735> slots = handler.getInputSources(menu);
                EmiIngredient emptyingIngredient = recipe.getItemInputs().getFirst();
                if (emptyingIngredient != null && !((KegMenu)context.getScreen().method_17577()).kegTank.isEmpty() && !BnCEMIRecipeFiller.handleEmptyingInputs(handler, recipe, context, amount, desired, emptyingIngredient, slots)) {
                    return null;
                }
                return (List)desired.get((Object)KegEmiRecipeHandler.InputType.EMPTY);
            }
        }
        catch (Exception ex) {
            BrewinAndChewin.LOG.error("Failed to get fermenting recipe stacks. ", (Throwable)ex);
        }
        return null;
    }

    private static boolean handleItemInputs(KegEmiRecipeHandler handler, EmiRecipe recipe, class_465<KegMenu> screen, int amount, Map<KegEmiRecipeHandler.InputType, List<class_1799>> desired, List<EmiIngredient> ingredients, List<class_1735> slots, List<class_1735> craftingSlots) {
        Object2IntOpenHashMap weightDivider = new Object2IntOpenHashMap();
        ArrayList discovered = Lists.newArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            Object stack;
            ArrayList d = Lists.newArrayList();
            EmiIngredient ingredient = ingredients.get(i);
            List emiStacks = ingredient.getEmiStacks();
            if (ingredient.isEmpty()) {
                discovered.add(null);
                continue;
            }
            Iterator iterator = emiStacks.iterator();
            while (iterator.hasNext()) {
                stack = (EmiStack)iterator.next();
                block2: for (class_1735 s : slots) {
                    class_1799 ss = s.method_7677();
                    if (!EmiStack.of((class_1799)s.method_7677()).isEqual((EmiStack)stack)) continue;
                    Iterator iterator2 = d.iterator();
                    while (iterator2.hasNext()) {
                        DiscoveredItem di = (DiscoveredItem)iterator2.next();
                        if (!class_1799.method_31577((class_1799)ss, (class_1799)di.stack)) continue;
                        di.amount += ss.method_7947();
                        continue block2;
                    }
                    d.add(new DiscoveredItem((EmiStack)stack, ss, ss.method_7947(), (int)ingredient.getAmount(), ss.method_7914()));
                }
            }
            DiscoveredItem biggest = null;
            stack = d.iterator();
            while (stack.hasNext()) {
                DiscoveredItem di = (DiscoveredItem)stack.next();
                if (biggest == null) {
                    biggest = di;
                    continue;
                }
                int a = di.amount / (weightDivider.getOrDefault((Object)di.ingredient, 0) + di.consumed);
                int ba = biggest.amount / (weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
                if (ba >= a) continue;
                biggest = di;
            }
            if (biggest == null || i >= craftingSlots.size()) {
                return false;
            }
            class_1735 slot = craftingSlots.get(i);
            if (slot == null) {
                return false;
            }
            weightDivider.put((Object)biggest.ingredient, weightDivider.getOrDefault((Object)biggest.ingredient, 0) + biggest.consumed);
            biggest.max = Math.min(biggest.max, slot.method_7675());
            discovered.add(biggest);
        }
        if (discovered.isEmpty()) {
            return false;
        }
        ArrayList unique = Lists.newArrayList();
        block5: for (DiscoveredItem di : discovered) {
            if (di == null) continue;
            for (DiscoveredItem ui : unique) {
                if (!class_1799.method_31577((class_1799)di.stack, (class_1799)ui.stack)) continue;
                ui.consumed += di.consumed;
                continue block5;
            }
            unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max));
        }
        int maxAmount = Integer.MAX_VALUE;
        for (DiscoveredItem ui : unique) {
            if (ui.catalyst()) continue;
            maxAmount = Math.min(maxAmount, ui.amount / ui.consumed);
            maxAmount = Math.min(maxAmount, ui.max);
        }
        if ((maxAmount = Math.min(maxAmount, amount + BnCEMIRecipeFiller.batchesAlreadyPresent(recipe, handler, screen))) == 0) {
            return false;
        }
        for (DiscoveredItem di : discovered) {
            if (di != null) {
                class_1799 is = di.stack.method_7972();
                int a = di.catalyst() ? di.consumed : di.consumed * maxAmount;
                is.method_7939(a);
                desired.computeIfAbsent(KegEmiRecipeHandler.InputType.ITEM, inputType -> new ArrayList()).add(is);
                continue;
            }
            desired.computeIfAbsent(KegEmiRecipeHandler.InputType.ITEM, inputType -> new ArrayList()).add(class_1799.field_8037);
        }
        return true;
    }

    private static boolean handleFillingInputs(KegEmiRecipeHandler handler, FermentingEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, Map<KegEmiRecipeHandler.InputType, List<class_1799>> desired, EmiIngredient fluidIngredient, EmiIngredient itemIngredient, List<class_1735> slots) {
        if (recipe.getFluidInput() == null || fluidIngredient.getEmiStacks().stream().anyMatch(emiStack -> ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().matches(new AbstractedFluidStack((class_3611)emiStack.getKey(), (int)emiStack.getAmount(), (class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)emiStack.getComponentChanges())))) && ((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() == Math.min(fluidIngredient.getAmount() * (long)context.getAmount(), ((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity())) {
            return true;
        }
        EmiIngredient emiFluidIngredient = recipe.getFluidInput();
        EmiStack emiFluidStack = (EmiStack)recipe.getFluidInput().getEmiStacks().getFirst();
        AbstractedFluidStack fluidStack = new AbstractedFluidStack((class_3611)emiFluidStack.getKey(), (int)emiFluidStack.getAmount(), (class_9323)class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)emiFluidStack.getComponentChanges()), FluidUnit.getLoaderUnit());
        ArrayList discoveredQuickRef = Lists.newArrayList();
        ArrayList d = Lists.newArrayList();
        List emiStacks = itemIngredient.getEmiStacks();
        for (EmiStack stack : emiStacks) {
            block1: for (class_1735 s : slots) {
                class_1799 ss = s.method_7677();
                if (!EmiStack.of((class_1799)s.method_7677()).isEqual(stack)) continue;
                for (DiscoveredItem di : d) {
                    if (!class_1799.method_31577((class_1799)ss, (class_1799)di.stack) && di.amount < di.consumed) continue;
                    di.amount += ss.method_7947();
                    continue block1;
                }
                Optional<PouringEmiRecipe> potentialPouring = EmiApi.getRecipeManager().getRecipes(BnCRecipeCategories.POURING).stream().filter(r -> {
                    if (!(r instanceof PouringEmiRecipe)) {
                        return false;
                    }
                    PouringEmiRecipe pouring = (PouringEmiRecipe)r;
                    if (recipe.getFluidInput() == null) {
                        return false;
                    }
                    return emiFluidIngredient.getEmiStacks().stream().anyMatch(es -> ((EmiStack)pouring.getFluidInput().getEmiStacks().getFirst()).isEqual(es)) && ((EmiStack)r.getOutputs().getFirst()).isEqual(stack);
                }).map(recipe1 -> (PouringEmiRecipe)recipe1).findFirst();
                if (!potentialPouring.isPresent()) continue;
                AbstractedFluidStack tankStack = ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid();
                EmiStack tankEmiStack = EmiStack.of((class_3611)tankStack.fluid(), (class_9326)tankStack.componentPatch(), (long)tankStack.amount());
                int consumed = (int)((((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() - (potentialPouring.get().getFluidInput().getEmiStacks().stream().anyMatch(emiStack -> emiStack.isEqual(tankEmiStack)) ? ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().amount() : 0L)) / potentialPouring.get().getFluidInput().getAmount());
                if (consumed < 1) continue;
                d.add(new DiscoveredItem(stack, ss, ss.method_7947(), consumed, (int)stack.getAmount()));
                discoveredQuickRef.add(stack);
            }
        }
        for (EmiStack inventoryStack : context.getInventory().inventory.values()) {
            if (discoveredQuickRef.contains(inventoryStack)) continue;
            class_1799 itemStack = inventoryStack.getItemStack();
            AbstractedFluidTank tank = BrewinAndChewin.getHelper().getFluidContainerFromItem(itemStack);
            if (tank == null) continue;
            int target = (int)tank.getAbstractedFluid().amount();
            if (!tank.getAbstractedFluid().isEmpty() || !tank.isFluidValid(0, fluidStack) || target <= 0) continue;
            AbstractedFluidStack tankStack = ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid();
            int consumed = (int)((((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() - (tankStack.matches(tank.getAbstractedFluid()) ? ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().amount() : 0L)) / (long)target);
            if (consumed < 1) continue;
            d.add(new DiscoveredItem(inventoryStack, itemStack, itemStack.method_7947(), consumed, (int)(((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() / (long)target)));
        }
        return BnCEMIRecipeFiller.handleFluidInternally(handler, recipe, context, amount, KegEmiRecipeHandler.InputType.FILL, desired, d);
    }

    private static boolean handleEmptyingInputs(KegEmiRecipeHandler handler, KegEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, Map<KegEmiRecipeHandler.InputType, List<class_1799>> desired, EmiIngredient ingredient, List<class_1735> slots) {
        if (((KegMenu)context.getScreen().method_17577()).kegTank.isEmpty()) {
            return true;
        }
        AbstractedFluidStack fluidStack = ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid();
        EmiStack emiFluidStack = EmiStack.of((class_3611)fluidStack.fluid(), (class_9326)fluidStack.componentPatch(), (long)fluidStack.amount());
        ArrayList discoveredQuickRef = Lists.newArrayList();
        ArrayList d = Lists.newArrayList();
        List emiStacks = ingredient.getEmiStacks();
        for (EmiStack stack : emiStacks) {
            block1: for (class_1735 s : slots) {
                Optional<PouringEmiRecipe> potentialPouring;
                Optional<PouringEmiRecipe> optional;
                class_1799 ss = s.method_7677();
                if (!EmiStack.of((class_1799)s.method_7677()).isEqual(stack)) continue;
                for (DiscoveredItem di : d) {
                    if (!class_1799.method_31577((class_1799)ss, (class_1799)di.stack) && di.amount < di.consumed) continue;
                    di.amount += ss.method_7947();
                    continue block1;
                }
                if (recipe instanceof PouringEmiRecipe) {
                    PouringEmiRecipe pouring = (PouringEmiRecipe)recipe;
                    optional = Optional.of(pouring);
                } else {
                    optional = EmiApi.getRecipeManager().getRecipes(BnCRecipeCategories.POURING).stream().filter(r -> {
                        if (!(r instanceof PouringEmiRecipe)) {
                            return false;
                        }
                        PouringEmiRecipe pouring = (PouringEmiRecipe)r;
                        return ((EmiStack)pouring.getFluidInput().getEmiStacks().getFirst()).isEqual(emiFluidStack) && ((EmiStack)((EmiIngredient)r.getInputs().getFirst()).getEmiStacks().getFirst()).isEqual(stack);
                    }).map(recipe1 -> (PouringEmiRecipe)recipe1).findFirst();
                }
                if (!(potentialPouring = optional).isPresent()) continue;
                int consumed = (int)(Math.min(((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().amount() * (long)context.getAmount(), ((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity()) / potentialPouring.get().getFluidInput().getAmount());
                if (recipe instanceof PouringEmiRecipe && consumed > context.getAmount()) {
                    consumed = context.getAmount();
                }
                if (consumed < 1) continue;
                d.add(new DiscoveredItem(stack, ss, ss.method_7947(), consumed, (int)stack.getAmount()));
                discoveredQuickRef.add(stack);
            }
        }
        for (EmiStack inventoryStack : context.getInventory().inventory.values()) {
            int consumed;
            if (discoveredQuickRef.contains(inventoryStack)) continue;
            class_1799 itemStack = inventoryStack.getItemStack();
            AbstractedFluidTank tank = BrewinAndChewin.getHelper().getFluidContainerFromItem(itemStack);
            if (tank == null) continue;
            long target = tank.getAbstractedFluid().amount();
            if (!tank.getAbstractedFluid().isEmpty() || !tank.isFluidValid(0, fluidStack) || target <= 0L || (consumed = (int)(recipe instanceof PouringEmiRecipe ? ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().amount() : (((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() - ((KegMenu)context.getScreen().method_17577()).kegTank.getAbstractedFluid().amount()) / target)) < 1) continue;
            d.add(new DiscoveredItem(inventoryStack, itemStack, itemStack.method_7947(), consumed * amount, (int)(((KegMenu)context.getScreen().method_17577()).kegTank.getFluidCapacity() / target)));
        }
        return BnCEMIRecipeFiller.handleFluidInternally(handler, recipe, context, amount, KegEmiRecipeHandler.InputType.EMPTY, desired, d);
    }

    private static boolean handleFluidInternally(KegEmiRecipeHandler handler, KegEmiRecipe recipe, EmiCraftContext<KegMenu> context, int amount, KegEmiRecipeHandler.InputType inputType, Map<KegEmiRecipeHandler.InputType, List<class_1799>> desired, List<DiscoveredItem> d) {
        int n;
        ArrayList discovered = Lists.newArrayList();
        DiscoveredItem biggest = null;
        for (DiscoveredItem discoveredItem : d) {
            if (biggest == null) {
                biggest = discoveredItem;
                continue;
            }
            long ba = biggest.amount / biggest.consumed;
            long a = discoveredItem.amount / discoveredItem.consumed;
            if (ba >= a) continue;
            biggest = discoveredItem;
        }
        if (biggest == null) {
            return false;
        }
        discovered.add(biggest);
        ArrayList unique = Lists.newArrayList();
        block1: for (DiscoveredItem di : discovered) {
            if (di == null) continue;
            for (DiscoveredItem ui : unique) {
                if (!class_1799.method_31577((class_1799)di.stack, (class_1799)ui.stack)) continue;
                ui.consumed += di.consumed;
                continue block1;
            }
            unique.add(new DiscoveredItem(di.ingredient, di.stack, di.amount, di.consumed, di.max));
        }
        int n2 = Integer.MAX_VALUE;
        for (DiscoveredItem ui : unique) {
            if (ui.catalyst()) continue;
            int n = Math.min(n, ui.amount / ui.consumed);
            n = Math.min(n, ui.max);
        }
        int n3 = Math.min(n, amount + BnCEMIRecipeFiller.batchesAlreadyPresent(recipe, handler, (class_465<KegMenu>)context.getScreen()));
        if (n3 == 0) {
            return false;
        }
        for (DiscoveredItem di : discovered) {
            if (di != null) {
                class_1799 is = di.stack.method_7972();
                int a = di.catalyst() ? di.consumed : di.consumed * n3;
                is.method_7939(a);
                desired.computeIfAbsent(inputType, ip -> new ArrayList()).add(is);
                continue;
            }
            desired.computeIfAbsent(inputType, ip -> new ArrayList()).add(class_1799.field_8037);
        }
        return true;
    }

    private static int batchesAlreadyPresent(EmiRecipe recipe, KegEmiRecipeHandler handler, class_465<KegMenu> screen) {
        if (recipe instanceof FermentingEmiRecipe) {
            return 0;
        }
        ArrayList stacks = Lists.newArrayList();
        class_1735 output = handler.getOutputSlot((KegMenu)screen.method_17577());
        if (!(output == null || output.method_7677().method_7960() || recipe.getOutputs().isEmpty() || class_1799.method_7973((class_1799)output.method_7677(), (class_1799)((EmiStack)recipe.getOutputs().getFirst()).getItemStack()))) {
            return 0;
        }
        for (class_1735 slot : handler.getCraftingSlots((KegMenu)screen.method_17577())) {
            if (slot != null) {
                stacks.add(slot.method_7677());
                continue;
            }
            stacks.add(class_1799.field_8037);
        }
        long amount = Long.MAX_VALUE;
        block1: for (int i = 0; i < recipe.getInputs().size(); ++i) {
            EmiIngredient input = (EmiIngredient)recipe.getInputs().get(i);
            if (input.isEmpty()) {
                if (((class_1799)stacks.get(i)).method_7960()) continue;
                return 0;
            }
            if (i >= stacks.size()) {
                return 0;
            }
            EmiStack es = EmiStack.of((class_1799)((class_1799)stacks.get(i)));
            for (EmiStack v : input.getEmiStacks()) {
                if (v.isEmpty() || !v.isEqual(es) || es.getAmount() < v.getAmount()) continue;
                amount = Math.min(amount, es.getAmount() / v.getAmount());
                continue block1;
            }
            return 0;
        }
        if (amount < Long.MAX_VALUE && amount > 0L) {
            return (int)amount;
        }
        return 0;
    }

    private static class DiscoveredItem {
        private static final Comparison COMPARISON = Comparison.DEFAULT_COMPARISON;
        public EmiStack ingredient;
        public class_1799 stack;
        public int consumed;
        public int amount;
        public int max;

        public DiscoveredItem(EmiStack ingredient, class_1799 stack, int amount, int consumed, int max) {
            this.ingredient = ingredient;
            this.stack = stack.method_7972();
            this.amount = amount;
            this.consumed = consumed;
            this.max = max;
        }

        public boolean catalyst() {
            return this.ingredient.getRemainder().isEqual(this.ingredient, COMPARISON);
        }
    }
}

