/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_5819;

public class MathsHelper {
    public static final Random RANDOM = new SecureRandom();
    public static final class_5819 RANDOM_SOURCE = class_5819.method_43047();
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    public static boolean inRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double distance(class_243 first, class_243 second) {
        double distanceX = first.field_1352 - second.field_1352;
        double distanceY = first.field_1351 - second.field_1351;
        double distanceZ = first.field_1350 - second.field_1350;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextInt(Random rng, int min, int max) {
        return rng.nextInt(max - min + 1) + min;
    }

    public static int nextInt(class_5819 rng, int min, int max) {
        return rng.method_39332(min, max);
    }

    public static boolean percentChance(double chance) {
        return Math.random() < chance;
    }

    public static float average(int ... values) {
        return (float)Arrays.stream(values).sum() / (float)values.length;
    }

    public static float percentage(int value, int total) {
        return (float)value / (float)total;
    }

    public static double pixelSize(int pixels) {
        return (double)pixels / 16.0;
    }

    public static class_238 boundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new class_238(MathsHelper.pixelSize(minX), MathsHelper.pixelSize(minY), MathsHelper.pixelSize(minZ), MathsHelper.pixelSize(maxX), MathsHelper.pixelSize(maxY), MathsHelper.pixelSize(maxZ));
    }

    public static Map<class_2350, class_265> createHorizontalShapes(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        EnumMap<class_2350, class_265> shapes = new EnumMap<class_2350, class_265>(class_2350.class);
        class_2350.class_2353.field_11062.forEach(dir -> shapes.put((class_2350)dir, MathsHelper.rotateShape(dir, minX, minY, minZ, maxX, maxY, maxZ)));
        return shapes;
    }

    public static class_265 rotateShape(class_2350 facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (facing) {
            case class_2350.field_11043 -> class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case class_2350.field_11034 -> class_2248.method_9541((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            case class_2350.field_11035 -> class_2248.method_9541((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case class_2350.field_11039 -> class_2248.method_9541((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            default -> throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
        };
    }

    public static class_2338 randomOffsetHorizontal(class_2338 startPos, class_5819 rng, int range) {
        return MathsHelper.randomOffset(startPos, rng, range, 0, range);
    }

    public static class_2338 randomOffset(class_2338 startPos, class_5819 rng, int rangeX, int rangeY, int rangeZ) {
        if (rangeX < 0 || rangeY < 0 || rangeZ < 0) {
            throw new IllegalArgumentException("Cannot offset position by '" + rangeX + ", " + rangeY + ", " + rangeZ + "'. Range must be positive!");
        }
        int offsetX = rangeX != 0 ? rng.method_39332(-rangeX, rangeX) : 0;
        int offsetY = rangeY != 0 ? rng.method_39332(-rangeY, rangeY) : 0;
        int offsetZ = rangeZ != 0 ? rng.method_39332(-rangeZ, rangeZ) : 0;
        return startPos.method_10069(offsetX, offsetY, offsetZ);
    }

    public static int[] encodeBytesToInt(byte[] bytes) {
        int byteCount = bytes.length;
        int msgSize = (byteCount + 3) / 4;
        int encodedLength = 1 + msgSize;
        int[] result = new int[encodedLength];
        result[0] = byteCount;
        for (int i = 0; i < msgSize; ++i) {
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                int byteIndex = i * 4 + j;
                if (byteIndex >= byteCount) continue;
                value |= (bytes[byteIndex] & 0xFF) << 24 - j * 8;
            }
            result[i + 1] = value;
        }
        return result;
    }

    public static byte[] decodeBytesFromInt(int[] data) {
        if (data.length == 0) {
            return new byte[0];
        }
        int byteCount = data[0];
        byte[] result = new byte[byteCount];
        for (int i = 0; i < data.length - 1; ++i) {
            int value = data[i + 1];
            for (int j = 0; j < 4; ++j) {
                int byteIndex = i * 4 + j;
                if (byteIndex >= byteCount) continue;
                result[byteIndex] = (byte)(value >> 24 - j * 8 & 0xFF);
            }
        }
        return result;
    }
}

