/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_6880;
import net.player005.recipe_modification.api.IngredientSelector;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.recipe_modification.api.RecipeModifier;
import net.player005.recipe_modification.serialization.IngredientSelectorSerializer;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;

public abstract class RecipeModifierSerializer {
    private static final Map<String, Function<JsonObject, RecipeModifier>> deserializers = new HashMap<String, Function<JsonObject, RecipeModifier>>();

    public static RecipeModifier fromJson(JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        String modifierId = object.get("type").getAsString();
        if (!deserializers.containsKey(modifierId)) {
            throw new RecipeModifierParsingException("Unknown recipe modifier type: " + modifierId);
        }
        return deserializers.get(modifierId).apply(object);
    }

    public static void registerDeserializer(String id, Function<JsonObject, RecipeModifier> deserializer) {
        deserializers.put(id, deserializer);
    }

    static {
        RecipeModifierSerializer.registerDeserializer("add_ingredient", object -> {
            class_1856 ingredient = (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("ingredient")).getOrThrow();
            return RecipeModifier.addIngredient(ingredient);
        });
        RecipeModifierSerializer.registerDeserializer("remove_ingredients", object -> {
            IngredientSelector ingredientSelector = IngredientSelectorSerializer.fromJson(object.get("ingredients"));
            return RecipeModifier.removeIngredients(ingredientSelector);
        });
        RecipeModifierSerializer.registerDeserializer("replace_ingredients", object -> {
            IngredientSelector ingredientSelector = IngredientSelectorSerializer.fromJson(object.get("ingredients"));
            class_1856 newIngredient = (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("new_ingredient")).getOrThrow();
            return RecipeModifier.replaceIngredient(ingredientSelector, newIngredient);
        });
        RecipeModifierSerializer.registerDeserializer("add_alternative", object -> {
            IngredientSelector ingredientSelector = IngredientSelectorSerializer.fromJson(object.get("ingredients"));
            class_1856 alternative = (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("alternative")).getOrThrow();
            return RecipeModifier.addAlternative(ingredientSelector, alternative);
        });
        RecipeModifierSerializer.registerDeserializer("replace_result_item", object -> {
            class_1799 newResult = (class_1799)class_1799.field_24671.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("new_result")).getOrThrow();
            return RecipeModifier.replaceResultItem(newResult);
        });
        RecipeModifierSerializer.registerDeserializer("modify_result_item", object -> {
            class_117 function = (class_117)((class_6880)class_131.field_45832.parse((DynamicOps)JsonOps.INSTANCE, object).getOrThrow()).comp_349();
            return RecipeModifier.modifyResultItem(itemStack -> function.apply(itemStack, null));
        });
        RecipeModifierSerializer.registerDeserializer("remove_recipe", object -> (recipe, helper) -> RecipeModification.removeRecipe(RecipeModification.findRecipeID(recipe)));
    }
}

