/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_6862;
import net.player005.recipe_modification.api.RecipeHelper;

@FunctionalInterface
public interface IngredientSelector {
    public static final IngredientSelector ALL_INGREDIENTS = (recipe, helper) -> (class_1856[])recipe.method_8117().toArray(class_1856[]::new);

    public class_1856[] selectIngredients(class_1860<?> var1, RecipeHelper var2);

    public static IngredientSelector byOrdinals(int ... numbers) {
        return (recipe, helper) -> (class_1856[])Arrays.stream(numbers).mapToObj(arg_0 -> ((class_2371)recipe.method_8117()).get(arg_0)).toArray(class_1856[]::new);
    }

    public static IngredientSelector byOrdinals(List<Integer> numbers) {
        return (recipe, helper) -> (class_1856[])numbers.stream().map(arg_0 -> ((class_2371)recipe.method_8117()).get(arg_0)).toArray(class_1856[]::new);
    }

    public static IngredientSelector byItem(class_1792 item) {
        return (recipe, helper) -> {
            ArrayList<class_1856> toReturn = new ArrayList<class_1856>();
            for (class_1856 ingredient : recipe.method_8117()) {
                for (class_1799 ingredientItem : ingredient.method_8105()) {
                    if (!ingredientItem.method_31574(item)) continue;
                    toReturn.add(ingredient);
                }
            }
            return (class_1856[])toReturn.toArray(class_1856[]::new);
        };
    }

    public static IngredientSelector matchingItem(class_1792 item) {
        return (recipe, helper) -> {
            ArrayList<class_1856> toReturn = new ArrayList<class_1856>();
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!helper.isExactMatch(ingredient, item)) continue;
                toReturn.add(ingredient);
            }
            return (class_1856[])toReturn.toArray(class_1856[]::new);
        };
    }

    public static IngredientSelector matchingTag(class_6862<class_1792> tag) {
        return (recipe, helper) -> {
            ArrayList<class_1856> toReturn = new ArrayList<class_1856>();
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!helper.matchesTag(ingredient, tag)) continue;
                toReturn.add(ingredient);
            }
            return (class_1856[])toReturn.toArray(class_1856[]::new);
        };
    }

    public static IngredientSelector and(IngredientSelector ... selectors) {
        return (recipe, helper) -> {
            ArrayList<class_1856> toReturn = new ArrayList<class_1856>();
            for (IngredientSelector selector : selectors) {
                toReturn.addAll(Arrays.asList(selector.selectIngredients(recipe, helper)));
            }
            return (class_1856[])toReturn.toArray(class_1856[]::new);
        };
    }
}

