/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.compat;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.config.schema.ConfiguredBoolean;
import net.blay09.mods.balm.api.config.schema.ConfiguredEnum;
import net.blay09.mods.balm.api.config.schema.ConfiguredFloat;
import net.blay09.mods.balm.api.config.schema.ConfiguredInt;
import net.blay09.mods.balm.api.config.schema.ConfiguredList;
import net.blay09.mods.balm.api.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.api.config.schema.ConfiguredSet;
import net.blay09.mods.balm.api.config.schema.ConfiguredString;
import net.blay09.mods.balm.api.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.blay09.mods.balm.common.config.ConfigLocalization;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ClothConfigUtils {
    public static ConfigScreenFactory<?> getConfigScreen(String modId) {
        return screen -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((class_2561)class_2561.method_43471((String)ConfigLocalization.forTitle(modId)));
            Collection<BalmConfigSchema> schemas = Balm.getConfig().getSchemasByNamespace(modId);
            builder.setSavingRunnable(() -> {
                for (BalmConfigSchema schema : schemas) {
                    Balm.getConfig().saveLocalConfig(schema, Balm.getConfig().getLocalConfig(schema));
                }
            });
            for (BalmConfigSchema schema : schemas) {
                MutableLoadedConfig config = Balm.getConfig().getLocalConfig(schema);
                Collection<ConfigCategory> categories = schema.categories();
                me.shedaniel.clothconfig2.api.ConfigCategory rootCategory = null;
                for (ConfiguredProperty<?> rootProperty : schema.rootProperties()) {
                    if (rootCategory == null) {
                        rootCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)ConfigLocalization.forRootCategory(schema)));
                    }
                    ClothConfigUtils.addPropertyToBuilder(config, rootProperty, rootCategory, builder);
                }
                for (ConfigCategory category : categories) {
                    me.shedaniel.clothconfig2.api.ConfigCategory categoryInstance = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)ConfigLocalization.forCategory(category)));
                    for (ConfiguredProperty<?> property : category.properties()) {
                        ClothConfigUtils.addPropertyToBuilder(config, property, categoryInstance, builder);
                    }
                }
            }
            return builder.build();
        };
    }

    private static void addPropertyToBuilder(MutableLoadedConfig config, ConfiguredProperty<?> property, me.shedaniel.clothconfig2.api.ConfigCategory categoryInstance, ConfigBuilder builder) {
        class_5250 displayName = class_2561.method_43471((String)ConfigLocalization.forProperty(property));
        class_5250 tooltip = class_2561.method_43471((String)ConfigLocalization.forPropertyTooltip(property));
        ConfiguredProperty<?> configuredProperty = property;
        Objects.requireNonNull(configuredProperty);
        ConfiguredProperty<?> configuredProperty2 = configuredProperty;
        int n = 0;
        block19: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfiguredString.class, ConfiguredInt.class, ConfiguredFloat.class, ConfiguredBoolean.class, ConfiguredEnum.class, ConfiguredList.class, ConfiguredList.class, ConfiguredList.class, ConfiguredList.class, ConfiguredList.class, ConfiguredList.class, ConfiguredSet.class, ConfiguredSet.class, ConfiguredSet.class, ConfiguredSet.class, ConfiguredSet.class, ConfiguredSet.class}, configuredProperty2, n)) {
                case 0: {
                    ConfiguredString stringProperty = (ConfiguredString)configuredProperty2;
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrField((class_2561)displayName, stringProperty.get(config)).setDefaultValue((String)stringProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> stringProperty.set(config, (String)value)).build());
                    break block19;
                }
                case 1: {
                    ConfiguredInt intProperty = (ConfiguredInt)configuredProperty2;
                    categoryInstance.addEntry((AbstractConfigListEntry)((IntFieldBuilder)builder.entryBuilder().startIntField((class_2561)displayName, intProperty.get(config)).setDefaultValue((Object)((Integer)intProperty.defaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> intProperty.set(config, (int)value)).build());
                    break block19;
                }
                case 2: {
                    ConfiguredFloat floatProperty = (ConfiguredFloat)configuredProperty2;
                    categoryInstance.addEntry((AbstractConfigListEntry)((FloatFieldBuilder)builder.entryBuilder().startFloatField((class_2561)displayName, floatProperty.get(config)).setDefaultValue((Object)((Float)floatProperty.defaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> floatProperty.set(config, value.floatValue())).build());
                    break block19;
                }
                case 3: {
                    ConfiguredBoolean booleanProperty = (ConfiguredBoolean)configuredProperty2;
                    categoryInstance.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)builder.entryBuilder().startBooleanToggle((class_2561)displayName, booleanProperty.get(config)).setDefaultValue((Object)((Boolean)booleanProperty.defaultValue()))).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> booleanProperty.set(config, (boolean)value)).build());
                    break block19;
                }
                case 4: {
                    ConfiguredEnum enumProperty = (ConfiguredEnum)configuredProperty2;
                    ClothConfigUtils.addEnumPropertyToBuilder(config, enumProperty, categoryInstance, builder, (class_2561)displayName, (class_2561)tooltip);
                    break block19;
                }
                case 5: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != String.class) {
                        n = 6;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, listProperty.get(config)).setDefaultValue((List)listProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value)).build());
                    break block19;
                }
                case 6: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != Integer.class) {
                        n = 7;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startIntList((class_2561)displayName, listProperty.get(config)).setDefaultValue((List)listProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value)).build());
                    break block19;
                }
                case 7: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != Long.class) {
                        n = 8;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startLongList((class_2561)displayName, listProperty.get(config)).setDefaultValue((List)listProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value)).build());
                    break block19;
                }
                case 8: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != Float.class) {
                        n = 9;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startFloatList((class_2561)displayName, listProperty.get(config)).setDefaultValue((List)listProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value)).build());
                    break block19;
                }
                case 9: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != Double.class) {
                        n = 10;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startDoubleList((class_2561)displayName, listProperty.get(config)).setDefaultValue((List)listProperty.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value)).build());
                    break block19;
                }
                case 10: {
                    ConfiguredList listProperty = (ConfiguredList)configuredProperty2;
                    if (listProperty.nestedType() != class_2960.class) {
                        n = 11;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, listProperty.get(config).stream().map(Objects::toString).toList()).setDefaultValue(((List)listProperty.defaultValue()).stream().map(Objects::toString).toList()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> listProperty.set(config, value.stream().map(class_2960::method_12829).collect(Collectors.toList()))).build());
                    break block19;
                }
                case 11: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != String.class) {
                        n = 12;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, new ArrayList(setProperty.get(config))).setDefaultValue(new ArrayList((Set)setProperty.defaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, new HashSet(value))).build());
                    break block19;
                }
                case 12: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != Integer.class) {
                        n = 13;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startIntList((class_2561)displayName, new ArrayList(setProperty.get(config))).setDefaultValue(new ArrayList((Set)setProperty.defaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, new HashSet(value))).build());
                    break block19;
                }
                case 13: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != Long.class) {
                        n = 14;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startLongList((class_2561)displayName, new ArrayList(setProperty.get(config))).setDefaultValue(new ArrayList((Set)setProperty.defaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, new HashSet(value))).build());
                    break block19;
                }
                case 14: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != Float.class) {
                        n = 15;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startFloatList((class_2561)displayName, new ArrayList(setProperty.get(config))).setDefaultValue(new ArrayList((Set)setProperty.defaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, new HashSet(value))).build());
                    break block19;
                }
                case 15: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != Double.class) {
                        n = 16;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startDoubleList((class_2561)displayName, new ArrayList(setProperty.get(config))).setDefaultValue(new ArrayList((Set)setProperty.defaultValue())).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, new HashSet(value))).build());
                    break block19;
                }
                case 16: {
                    ConfiguredSet setProperty = (ConfiguredSet)configuredProperty2;
                    if (setProperty.nestedType() != class_2960.class) {
                        n = 17;
                        continue block19;
                    }
                    categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startStrList((class_2561)displayName, setProperty.get(config).stream().map(Objects::toString).toList()).setDefaultValue(((Set)setProperty.defaultValue()).stream().map(Objects::toString).toList()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> setProperty.set(config, value.stream().map(class_2960::method_12829).collect(Collectors.toSet()))).build());
                    break block19;
                }
            }
            break;
        }
    }

    private static <T extends Enum<T>> void addEnumPropertyToBuilder(MutableLoadedConfig config, ConfiguredEnum<T> property, me.shedaniel.clothconfig2.api.ConfigCategory categoryInstance, ConfigBuilder builder, class_2561 displayName, class_2561 tooltip) {
        categoryInstance.addEntry((AbstractConfigListEntry)builder.entryBuilder().startEnumSelector(displayName, property.type(), property.get(config)).setDefaultValue((Enum)property.defaultValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(value -> property.set(config, value)).build());
    }

    @Deprecated
    public static <T extends BalmConfigData> ConfigScreenFactory<?> getConfigScreen(Class<T> clazz) {
        return ClothConfigUtils.getConfigScreen(ConfigReflection.getIdentifier(clazz).method_12836());
    }
}

