/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.CustomBlock;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public abstract class MdxComponentBlock
extends CustomBlock {
    protected String rawContent;

    public void setupContent(String rawContent) {
        this.rawContent = rawContent;
        this.parseContent();
    }

    public String getRawContent() {
        return this.rawContent;
    }

    abstract void parseContent();

    public static class PrefabObtainingBlock
    extends MdxComponentBlock {
        @Override
        void parseContent() {
        }
    }

    public static class AssetBlock
    extends MdxComponentBlock {
        private final boolean isModAsset;
        public String location;
        public String width = "50%";

        public AssetBlock(boolean isModAsset) {
            this.isModAsset = isModAsset;
        }

        public boolean isModAsset() {
            return this.isModAsset;
        }

        @Override
        void parseContent() {
            String tagName = this.isModAsset ? "ModAsset" : "Asset";
            Element el = Jsoup.parseBodyFragment((String)this.rawContent).selectFirst(tagName);
            if (el != null) {
                this.location = el.attr("location");
                if (el.hasAttr("width")) {
                    this.width = el.attr("width").replaceAll("[{}]", "");
                }
            }
        }

        public String toString() {
            return "AssetBlock{isModAsset=" + this.isModAsset + ", location='" + this.location + "', width='" + this.width + "', rawContent='" + this.rawContent + "'}";
        }
    }

    public static class CalloutBlock
    extends MdxComponentBlock {
        public String variant = "info";

        @Override
        void parseContent() {
            Element el = Jsoup.parseBodyFragment((String)this.rawContent).selectFirst("Callout");
            if (el != null && el.hasAttr("variant")) {
                this.variant = el.attr("variant");
            }
        }

        public String toString() {
            return "CalloutBlock{variant='" + this.variant + "', rawContent='" + this.rawContent + "'}";
        }
    }

    public static class CraftingRecipeBlock
    extends MdxComponentBlock {
        public List<String> slots = new ArrayList<String>();
        public String result;
        public int count = 1;

        @Override
        void parseContent() {
            String safeHtml;
            Element el;
            Pattern slotPattern = Pattern.compile("slots=\\{\\[(.*?)]}");
            Matcher slotMatcher = slotPattern.matcher(this.rawContent.replace("\n", " "));
            if (slotMatcher.find()) {
                String[] items;
                String arrayContent = slotMatcher.group(1);
                for (String item : items = arrayContent.split(",")) {
                    this.slots.add(item.trim().replace("'", "").replace("\"", ""));
                }
            }
            if ((el = Jsoup.parseBodyFragment((String)(safeHtml = this.rawContent.replaceAll("slots=\\{\\[.*?]}", ""))).selectFirst("CraftingRecipe")) != null) {
                this.result = el.attr("result");
                String countStr = el.attr("count").replaceAll("[{}]", "");
                try {
                    this.count = Integer.parseInt(countStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "CraftingRecipeBlock{slots=" + String.valueOf(this.slots) + ", result='" + this.result + "', count=" + this.count + ", rawContent='" + this.rawContent + "'}";
        }
    }
}

