/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.Extension;
import org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import org.commonmark.ext.front.matter.YamlFrontMatterVisitor;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.parser.block.BlockParserFactory;
import org.jetbrains.annotations.Nullable;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.ui.OracleScreen;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.ContentProperties;
import rearth.oracle.util.MdxBlockFactory;
import rearth.oracle.util.MdxComponentBlock;

public class MarkdownParser {
    private static final String[] removedLines = new String[]{"<center>", "</center>", "<div>", "</div>", "<span>", "</span>"};
    public static final class_2960 ITEM_SLOT = class_2960.method_60655((String)"oracle_index", (String)"textures/item_cell.png");
    public static Surface ORACLE_PANEL = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_HOVER = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_hover"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_PRESSED = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_pressed"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    public static Surface ORACLE_PANEL_DARK = (context, component) -> NinePatchTexture.draw((class_2960)class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_dark"), (OwoUIDrawContext)context, (PositionedRectangle)component);
    private static final List<Extension> EXTENSIONS = List.of(YamlFrontMatterExtension.create());
    private static final Set<Class<? extends Block>> ENABLED_BLOCKS = Set.of(Heading.class, HtmlBlock.class, ThematicBreak.class, FencedCodeBlock.class, BlockQuote.class, ListBlock.class);
    private static final Parser PARSER = Parser.builder().enabledBlockTypes(ENABLED_BLOCKS).extensions(EXTENSIONS).customBlockParserFactory((BlockParserFactory)new MdxBlockFactory()).build();

    public static List<Component> parseMarkdownToOwoComponents(String markdown, String wikiId, class_2960 currentPath, Predicate<String> linkHandler) {
        String gameId;
        class_2960 id;
        for (String toRemove : removedLines) {
            markdown = markdown.replace(toRemove, "");
        }
        Node document = PARSER.parse(markdown);
        YamlFrontMatterVisitor yamlVisitor = new YamlFrontMatterVisitor();
        document.accept((Visitor)yamlVisitor);
        Map<String, String> frontMatter = MarkdownParser.parseFrontmatter(markdown);
        OwoMarkdownVisitor visitor = new OwoMarkdownVisitor(linkHandler, wikiId, currentPath);
        document.accept((Visitor)visitor);
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)MarkdownParser.getTitlePanel(linkHandler, frontMatter, currentPath));
        if (frontMatter.containsKey("id") && (class_7923.field_41178.method_10250(id = class_2960.method_60654((String)(gameId = frontMatter.get("id")))) || class_7923.field_41175.method_10250(id))) {
            components.add(MarkdownParser.createPropertiesUI(ContentProperties.getProperties(gameId)));
        }
        components.addAll(visitor.getResultComponents());
        return components;
    }

    public static String getLinkText(String link, String activeWikiId, class_2960 sourceEntryPath) {
        class_2960 linkTarget = MarkdownParser.getLinkTarget(link, activeWikiId, sourceEntryPath);
        if (linkTarget == null) {
            return "<invalid link>";
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Optional resourceCandidate = resourceManager.method_14486(linkTarget);
        if (resourceCandidate.isEmpty()) {
            return "<invalid link>";
        }
        try {
            String fileContent = new String(((class_3298)resourceCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
            Map<String, String> frontMatter = MarkdownParser.parseFrontmatter(fileContent);
            return MarkdownParser.getTitle(frontMatter, linkTarget);
        }
        catch (IOException e) {
            Oracle.LOGGER.warn("Unable to load file content to get link title: {}, {}", (Object)linkTarget, (Object)e);
            return "<invalid link>";
        }
    }

    @Nullable
    public static class_2960 getLinkTarget(String link, String activeWikiId, class_2960 sourceEntryPath) {
        class_2960 targetFile = null;
        if (link.startsWith("@") || link.contains(":")) {
            String id;
            String string = id = link.startsWith("@") ? link.substring(1) : link;
            if (OracleClient.CONTENT_ID_MAP.containsKey(id)) {
                targetFile = OracleClient.CONTENT_ID_MAP.get(id);
            }
        } else if (link.startsWith("$")) {
            String newPathString = "books/" + activeWikiId + "/" + link.substring(1);
            if (!newPathString.endsWith(".mdx")) {
                newPathString = newPathString + ".mdx";
            }
            targetFile = class_2960.method_60655((String)"oracle_index", (String)newPathString);
        } else {
            Object newPathString = OracleScreen.parsePathLink(link, sourceEntryPath);
            if (!((String)newPathString).endsWith(".mdx")) {
                newPathString = (String)newPathString + ".mdx";
            }
            targetFile = class_2960.method_60655((String)"oracle_index", (String)newPathString);
        }
        return targetFile;
    }

    public static String getTitle(Map<String, String> frontMatter, class_2960 pagePath) {
        if (frontMatter.containsKey("title")) {
            return frontMatter.get("title");
        }
        if (frontMatter.containsKey("id")) {
            String item = frontMatter.get("id");
            if (class_2960.method_29186((String)item).isSuccess() && class_7923.field_41178.method_10250(class_2960.method_60654((String)item))) {
                return class_1074.method_4662((String)((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)item))).method_7876(), (Object[])new Object[0]);
            }
            return item;
        }
        return OracleScreen.PAGE_FALLBACK_NAMES.getOrDefault(pagePath, "No title found");
    }

    private static FlowLayout getTitlePanel(Predicate<String> linkHandler, Map<String, String> frontMatter, class_2960 pageId) {
        FlowLayout combinedPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        combinedPanel.margins(Insets.of((int)2, (int)10, (int)0, (int)0));
        FlowLayout titlePanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
        titlePanel.padding(Insets.of((int)10, (int)10, (int)10, (int)10));
        titlePanel.surface(ORACLE_PANEL);
        combinedPanel.child((Component)titlePanel.positioning(Positioning.absolute((int)54, (int)7)));
        String title = MarkdownParser.getTitle(frontMatter, pageId);
        String iconId = frontMatter.getOrDefault("icon", "");
        if (iconId.isBlank()) {
            iconId = frontMatter.getOrDefault("id", "");
        }
        if (class_2960.method_29186((String)iconId).isSuccess()) {
            if (class_7923.field_41178.method_10250(class_2960.method_60654((String)iconId))) {
                class_1799 itemDisplay = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)iconId)));
                ItemComponent itemComponent = Components.item((class_1799)itemDisplay);
                itemComponent.sizing(Sizing.fixed((int)48));
                FlowLayout itemPanel = Containers.horizontalFlow((Sizing)Sizing.content((int)0), (Sizing)Sizing.content((int)0));
                itemPanel.padding(Insets.of((int)6, (int)6, (int)6, (int)6));
                itemPanel.surface(ORACLE_PANEL);
                itemPanel.child((Component)itemComponent);
                combinedPanel.child((Component)itemPanel);
            } else {
                titlePanel.positioning(Positioning.layout());
            }
        } else {
            titlePanel.positioning(Positioning.layout());
        }
        ScalableLabelComponent titleLabel = new ScalableLabelComponent((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1063), linkHandler);
        titleLabel.scale = 2.0f;
        titlePanel.child((Component)titleLabel);
        FlowLayout spacedPanel = Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        spacedPanel.child((Component)combinedPanel);
        spacedPanel.margins(Insets.of((int)15, (int)5, (int)2, (int)2));
        return spacedPanel;
    }

    public static Component createRecipeUI(List<String> inputs, String resultId, int resultCount) {
        if (inputs.size() != 9) {
            return Components.label((class_2561)class_2561.method_43470((String)"Invalid crafting recipe data: expected 9 inputs").method_27692(class_124.field_1061));
        }
        FlowLayout panel = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        panel.surface(ORACLE_PANEL);
        panel.horizontalAlignment(HorizontalAlignment.CENTER);
        panel.verticalAlignment(VerticalAlignment.CENTER);
        GridLayout inputGrid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)3, (int)3);
        inputGrid.padding(Insets.of((int)3));
        inputGrid.margins(Insets.of((int)3));
        inputGrid.positioning(Positioning.relative((int)0, (int)0));
        GridLayout backgroundGrid = Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)3, (int)3);
        backgroundGrid.padding(Insets.of((int)3));
        backgroundGrid.margins(Insets.of((int)3));
        for (int i = 0; i < inputs.size(); ++i) {
            String input = inputs.get(i);
            class_2960 id = class_2960.method_60654((String)input);
            if (!input.equals("minecraft:air") && !input.isEmpty() && class_7923.field_41178.method_10250(id)) {
                class_1799 itemstack = new class_1799((class_1935)class_7923.field_41178.method_10223(id));
                ItemComponent itemComponent = Components.item((class_1799)itemstack);
                itemComponent.setTooltipFromStack(true);
                int row = i / 3;
                int column = i % 3;
                inputGrid.child((Component)itemComponent, row, column);
            }
            backgroundGrid.child(MarkdownParser.getItemFrame(), i / 3, i % 3);
        }
        TextureComponent arrow = Components.texture((class_2960)class_2960.method_60655((String)"oracle_index", (String)"textures/arrow_empty.png"), (int)0, (int)0, (int)29, (int)16, (int)29, (int)16);
        arrow.margins(Insets.of((int)5));
        class_2960 resultIdObj = class_2960.method_60654((String)resultId);
        class_1799 resultStack = class_7923.field_41178.method_10250(resultIdObj) ? new class_1799((class_1935)class_7923.field_41178.method_10223(resultIdObj), resultCount) : class_1799.field_8037;
        ItemComponent result = Components.item((class_1799)resultStack);
        result.setTooltipFromStack(true);
        result.margins(Insets.of((int)5));
        Component resultFrame = MarkdownParser.getItemFrame().positioning(Positioning.relative((int)100, (int)50));
        resultFrame.margins(Insets.of((int)5));
        panel.child((Component)backgroundGrid);
        panel.child((Component)inputGrid);
        panel.child((Component)arrow);
        panel.child((Component)result);
        panel.child(resultFrame);
        return panel;
    }

    public static Component createCalloutUI(String variant, List<Component> children) {
        FlowLayout contentFlow = Containers.verticalFlow((Sizing)Sizing.fill((int)70), (Sizing)Sizing.content());
        contentFlow.horizontalAlignment(HorizontalAlignment.CENTER);
        for (Component child : children) {
            child.horizontalSizing(Sizing.fill());
            if (child instanceof LabelComponent) {
                LabelComponent label = (LabelComponent)child;
                label.horizontalTextAlignment(HorizontalAlignment.CENTER);
                label.color(Color.ofRgb((int)0x555555));
            }
            contentFlow.child(child);
        }
        FlowLayout contentContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        contentContainer.padding(Insets.of((int)6, (int)6, (int)8, (int)8));
        contentContainer.margins(Insets.of((int)15, (int)8, (int)10, (int)0));
        contentContainer.surface(ORACLE_PANEL);
        contentContainer.child((Component)contentFlow);
        String titleText = StringUtils.capitalize((String)variant);
        LabelComponent titleLabel = Components.label((class_2561)class_2561.method_43470((String)titleText));
        FlowLayout titleContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        titleContainer.padding(Insets.of((int)6, (int)5, (int)8, (int)6));
        titleContainer.positioning(Positioning.absolute((int)0, (int)0));
        titleContainer.surface(ORACLE_PANEL_PRESSED);
        titleContainer.child((Component)titleLabel);
        FlowLayout combinedContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        combinedContainer.child((Component)contentContainer);
        combinedContainer.child((Component)titleContainer);
        combinedContainer.margins(Insets.bottom((int)4));
        return combinedContainer;
    }

    public static Component createImageUI(String location, String widthSource, String wikiId, boolean isModAsset) {
        class_2960 searchPath;
        class_2960 itemIdCandidate;
        float width = MarkdownParser.convertImageWidth(widthSource);
        if (width <= 0.0f) {
            width = 0.5f;
        }
        if (location.startsWith("@")) {
            location = location.substring(1);
        }
        if (class_7923.field_41178.method_10250(itemIdCandidate = class_2960.method_60654((String)location))) {
            if (width == 0.5f) {
                width = 0.1f;
            }
            ItemComponent itemComponent = Components.item((class_1799)new class_1799((class_1935)class_7923.field_41178.method_10223(itemIdCandidate)));
            itemComponent.setTooltipFromStack(true);
            itemComponent.verticalSizing(Sizing.fixed((int)((int)(width * 100.0f))));
            return itemComponent;
        }
        if (isModAsset) {
            String[] parts = location.split(":", 2);
            String imageModId = parts.length > 0 ? parts[0] : wikiId;
            String imagePath = parts.length > 1 ? parts[1] : location;
            searchPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + wikiId + "/.assets/" + imageModId + "/" + imagePath + ".png"));
        } else {
            searchPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + wikiId + "/.assets/" + wikiId + "/" + location + ".png"));
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Optional resource = resourceManager.method_14486(searchPath);
        if (resource.isEmpty()) {
            return Components.label((class_2561)class_2561.method_43470((String)("Image not found: " + String.valueOf(searchPath))).method_27692(class_124.field_1061));
        }
        try {
            class_1011 image = class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482());
            TextureComponent result = Components.texture((class_2960)searchPath, (int)0, (int)0, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4307(), (int)image.method_4323());
            result.verticalSizing(Sizing.fixed((int)((int)(width * 100.0f))));
            return result;
        }
        catch (IOException e) {
            return Components.label((class_2561)class_2561.method_43470((String)("Error reading image: " + location)).method_27692(class_124.field_1061));
        }
    }

    private static Component createPropertiesUI(Map<String, class_2561> properties) {
        FlowLayout outer = Containers.verticalFlow((Sizing)Sizing.fill((int)80), (Sizing)Sizing.content());
        outer.surface(ORACLE_PANEL_DARK);
        outer.padding(Insets.of((int)10));
        outer.margins(Insets.bottom((int)15));
        outer.horizontalAlignment(HorizontalAlignment.CENTER);
        outer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Details").method_27695(new class_124[]{class_124.field_1067, class_124.field_1080})).margins(Insets.bottom((int)8)));
        GridLayout grid = Containers.grid((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (int)properties.size(), (int)2);
        int row = 0;
        for (Map.Entry<String, class_2561> entry : properties.entrySet()) {
            LabelComponent key = Components.label((class_2561)class_2561.method_43470((String)entry.getKey()).method_27692(class_124.field_1065));
            LabelComponent value = Components.label((class_2561)entry.getValue());
            value.horizontalSizing(Sizing.fill((int)45));
            grid.child((Component)key.horizontalTextAlignment(HorizontalAlignment.LEFT), row, 0);
            grid.child((Component)value.horizontalTextAlignment(HorizontalAlignment.RIGHT), row, 1);
            ++row;
        }
        outer.child((Component)grid);
        return outer;
    }

    public static Map<String, String> parseFrontmatter(String markdown) {
        Node document = PARSER.parse(markdown);
        YamlFrontMatterVisitor yamlVisitor = new YamlFrontMatterVisitor();
        document.accept((Visitor)yamlVisitor);
        Map frontmatter = yamlVisitor.getData();
        HashMap<String, String> simpleFrontMatter = new HashMap<String, String>();
        for (Map.Entry pair : frontmatter.entrySet()) {
            simpleFrontMatter.put((String)pair.getKey(), ((String)((List)pair.getValue()).getFirst()).trim());
        }
        return simpleFrontMatter;
    }

    public static Component getItemFrame() {
        return Components.texture((class_2960)ITEM_SLOT, (int)0, (int)0, (int)16, (int)16, (int)16, (int)16).sizing(Sizing.fixed((int)16));
    }

    public static float convertImageWidth(String input) {
        if (input == null || input.isEmpty()) {
            return 0.0f;
        }
        String trimmedInput = input.trim();
        if (trimmedInput.endsWith("%")) {
            try {
                String percentageString = trimmedInput.substring(0, trimmedInput.length() - 1);
                int percentage = Integer.parseInt(percentageString);
                return (float)percentage / 100.0f;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing percentage value: " + input);
                return 0.0f;
            }
        }
        if (trimmedInput.startsWith("{") && trimmedInput.endsWith("}")) {
            try {
                String numberString = trimmedInput.substring(1, trimmedInput.length() - 1);
                int number = Integer.parseInt(numberString);
                return (float)number / 1000.0f;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing braced number value: " + input);
                return 0.0f;
            }
        }
        if (StringUtils.isNumeric((CharSequence)trimmedInput)) {
            try {
                int number = Integer.parseInt(trimmedInput);
                return (float)number / 1000.0f;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing braced number value: " + input);
                return 0.0f;
            }
        }
        System.err.println("Invalid input format: " + input);
        return 0.0f;
    }

    private static class OwoMarkdownVisitor
    extends AbstractVisitor {
        private final Predicate<String> linkHandler;
        private final String wikiId;
        private final class_2960 contentPath;
        private List<Component> components = new ArrayList<Component>();
        private class_5250 buffer = class_2561.method_43473();
        private class_2583 currentStyle = class_2583.field_24360;
        private int currentIndentation = 0;

        private OwoMarkdownVisitor(Predicate<String> linkHandler, String wikiId, class_2960 contentPath) {
            this.linkHandler = linkHandler;
            this.wikiId = wikiId;
            this.contentPath = contentPath;
        }

        public List<Component> getResultComponents() {
            return this.components;
        }

        private void flushBuffer() {
            if (this.buffer != null && !this.buffer.getString().isEmpty()) {
                ScalableLabelComponent label = new ScalableLabelComponent((class_2561)this.buffer, this.linkHandler);
                label.lineHeight(10);
                label.margins(Insets.of((int)0, (int)5, (int)(this.currentIndentation * 6), (int)0));
                this.components.add((Component)label);
                this.buffer = class_2561.method_43473();
                this.currentIndentation = 0;
            }
        }

        public void visit(Paragraph paragraph) {
            this.visitChildren((Node)paragraph);
            this.flushBuffer();
        }

        public void visit(Heading heading) {
            this.buffer = class_2561.method_43473();
            class_2583 oldStyle = this.currentStyle;
            this.currentStyle = this.currentStyle.method_10977(class_124.field_1080);
            this.visitChildren((Node)heading);
            this.currentStyle = oldStyle;
            ScalableLabelComponent label = new ScalableLabelComponent((class_2561)this.buffer, this.linkHandler);
            label.scale = Math.max(1.0f, 2.0f - (float)heading.getLevel() * 0.2f);
            label.margins(Insets.top((int)10).withBottom(5));
            this.components.add((Component)label);
            this.buffer = class_2561.method_43473();
        }

        public void visit(FencedCodeBlock codeBlock) {
            this.flushBuffer();
            FlowLayout panel = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
            panel.surface(ORACLE_PANEL_DARK);
            panel.padding(Insets.of((int)6));
            panel.margins(Insets.bottom((int)5));
            class_5250 text = class_2561.method_43470((String)codeBlock.getLiteral()).method_27692(class_124.field_1080);
            panel.child((Component)Components.label((class_2561)text));
            this.components.add((Component)panel);
        }

        public void visit(BulletList bulletList) {
            this.visitChildren((Node)bulletList);
        }

        public void visit(OrderedList orderedList) {
            this.visitChildren((Node)orderedList);
        }

        public void visit(ListItem listItem) {
            Block parent = listItem.getParent();
            int depth = 0;
            Block ancestor = parent;
            while (ancestor instanceof ListBlock || ancestor instanceof ListItem) {
                if (ancestor instanceof ListBlock) {
                    ++depth;
                }
                ancestor = ancestor.getParent();
            }
            this.currentIndentation = depth - 1;
            if (parent instanceof BulletList) {
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1063));
            } else if (parent instanceof OrderedList) {
                OrderedList orderedList = (OrderedList)parent;
                int index = 1;
                for (Node sibling = listItem.getPrevious(); sibling != null; sibling = sibling.getPrevious()) {
                    if (!(sibling instanceof ListItem)) continue;
                    ++index;
                }
                int displayNumber = orderedList.getStartNumber() + index - 1;
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)(displayNumber + ". ")).method_27692(class_124.field_1063));
            }
            this.visitChildren((Node)listItem);
            this.flushBuffer();
            this.currentIndentation = 0;
        }

        public void visit(CustomBlock customBlock) {
            if (customBlock instanceof MdxComponentBlock.CraftingRecipeBlock) {
                MdxComponentBlock.CraftingRecipeBlock recipe = (MdxComponentBlock.CraftingRecipeBlock)customBlock;
                this.components.add(MarkdownParser.createRecipeUI(recipe.slots, recipe.result, recipe.count));
            } else if (customBlock instanceof MdxComponentBlock.AssetBlock) {
                MdxComponentBlock.AssetBlock image = (MdxComponentBlock.AssetBlock)customBlock;
                this.components.add(MarkdownParser.createImageUI(image.location, image.width, this.wikiId, image.isModAsset()));
            } else if (customBlock instanceof MdxComponentBlock.CalloutBlock) {
                MdxComponentBlock.CalloutBlock callout = (MdxComponentBlock.CalloutBlock)customBlock;
                List<Component> oldComponents = this.components;
                ArrayList<Component> innerComponents = new ArrayList<Component>();
                this.components = innerComponents;
                this.visitChildren((Node)callout);
                this.flushBuffer();
                this.components = oldComponents;
                this.components.add(MarkdownParser.createCalloutUI(callout.variant, innerComponents));
            }
        }

        public void visit(Image image) {
            this.flushBuffer();
            this.components.add(MarkdownParser.createImageUI(image.getDestination(), "60%", this.wikiId, true));
        }

        public void visit(Text text) {
            if (this.buffer != null) {
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)text.getLiteral()).method_10862(this.currentStyle));
            }
        }

        public void visit(StrongEmphasis strongEmphasis) {
            class_2583 old = this.currentStyle;
            this.currentStyle = this.currentStyle.method_10982(Boolean.valueOf(true));
            this.visitChildren((Node)strongEmphasis);
            this.currentStyle = old;
        }

        public void visit(Emphasis emphasis) {
            class_2583 old = this.currentStyle;
            this.currentStyle = this.currentStyle.method_10978(Boolean.valueOf(true));
            this.visitChildren((Node)emphasis);
            this.currentStyle = old;
        }

        public void visit(Link link) {
            class_2583 old = this.currentStyle;
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11749, link.getDestination());
            this.currentStyle = this.currentStyle.method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)).method_10958(clickEvent);
            if (link.getFirstChild() == null && (link.getTitle() == null || link.getTitle().isBlank())) {
                String linkTitle = MarkdownParser.getLinkText(link.getDestination(), this.wikiId, this.contentPath);
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)linkTitle).method_10862(this.currentStyle));
            }
            this.visitChildren((Node)link);
            this.currentStyle = old;
        }

        public void visit(Code inlineCode) {
            if (this.buffer != null) {
                class_5250 codeText = class_2561.method_43470((String)inlineCode.getLiteral()).method_27692(class_124.field_1061);
                this.buffer.method_10852((class_2561)codeText);
            }
        }

        public void visit(SoftLineBreak softLineBreak) {
            if (this.buffer != null) {
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)" "));
            }
        }

        public void visit(HardLineBreak hardLineBreak) {
            if (this.buffer != null) {
                this.buffer.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
        }
    }
}

