/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.ui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oracle.Oracle;
import rearth.oracle.OracleClient;
import rearth.oracle.progress.OracleProgressAPI;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.ui.components.ColoredCollapsibleContainer;
import rearth.oracle.ui.components.ScalableLabelComponent;
import rearth.oracle.util.MarkdownParser;

public class OracleScreen
extends BaseOwoScreen<FlowLayout> {
    public static final HashMap<class_2960, String> PAGE_FALLBACK_NAMES = new HashMap();
    private FlowLayout navigationBar;
    private FlowLayout contentContainer;
    private FlowLayout rootComponent;
    private FlowLayout leftPanel;
    private ScrollContainer<FlowLayout> outerContentContainer;
    private final class_437 parent;
    private final Stack<class_2960> navigationHistory = new Stack();
    private boolean needsLayout = false;
    private boolean inHistory = false;
    public static String activeWikiMode = "docs";
    public static class_2960 activeEntry;
    public static String activeWiki;
    private static final int wideContentWidth = 50;
    private ButtonComponent backAction;

    public OracleScreen() {
        this.parent = null;
    }

    public OracleScreen(class_437 parent) {
        this.parent = parent;
    }

    public void method_25419() {
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.blur((float)4.0f, (float)48.0f));
        rootComponent.child(Components.box((Sizing)Sizing.fill(), (Sizing)Sizing.fill()).color(new Color(0.1f, 0.1f, 0.15f, 0.9f)).fill(true).zIndex(-1).positioning(Positioning.absolute((int)0, (int)0)));
        rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
        rootComponent.verticalAlignment(VerticalAlignment.CENTER);
        this.rootComponent = rootComponent;
        this.leftPanel = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fill());
        this.leftPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        this.navigationBar = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content((int)3));
        this.navigationBar.surface(MarkdownParser.ORACLE_PANEL_DARK);
        this.navigationBar.padding(Insets.of((int)9, (int)5, (int)5, (int)5));
        rootComponent.child((Component)this.leftPanel);
        this.contentContainer = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content((int)3));
        this.contentContainer.horizontalSizing(Sizing.fill());
        this.contentContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.contentContainer.margins(Insets.of((int)2, (int)2, (int)4, (int)4));
        this.contentContainer.padding(Insets.of((int)20, (int)25, (int)0, (int)0));
        this.contentContainer.allowOverflow(true);
        this.outerContentContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)50), (Sizing)Sizing.fill(), (Component)this.contentContainer);
        this.outerContentContainer.allowOverflow(true);
        rootComponent.child(this.outerContentContainer);
        this.buildModNavigation(this.leftPanel);
        ScrollContainer outerNavigationBarContainer = Containers.verticalScroll((Sizing)Sizing.content((int)3), (Sizing)Sizing.fill((int)80), (Component)this.navigationBar);
        this.leftPanel.child((Component)outerNavigationBarContainer);
        this.createActionHub(rootComponent);
    }

    protected void method_25426() {
        super.method_25426();
        this.updateLayout();
    }

    private void updateLayout() {
        boolean wideEnough;
        int leftOffset = Math.max(15, this.field_22789 / 20);
        int leftPanelSize = this.leftPanel.width();
        int leftPanelEnd = this.leftPanel.x() + this.leftPanel.width();
        float innerPanelWideLeft = (float)this.field_22789 * 0.5f - (float)(this.field_22789 * 50) / 100.0f / 2.0f;
        boolean bl = wideEnough = this.field_22789 >= 650;
        if ((float)leftPanelEnd > innerPanelWideLeft + 30.0f) {
            wideEnough = false;
        }
        if (wideEnough) {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
            this.leftPanel.positioning(Positioning.relative((int)0, (int)0));
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)leftOffset, (int)(leftOffset / 2)));
            this.outerContentContainer.positioning(Positioning.relative((int)60, (int)50));
            this.outerContentContainer.horizontalSizing(Sizing.fill((int)50));
        } else {
            this.rootComponent.horizontalAlignment(HorizontalAlignment.LEFT);
            this.leftPanel.positioning(Positioning.layout());
            this.outerContentContainer.positioning(Positioning.layout());
            this.leftPanel.margins(Insets.of((int)0, (int)0, (int)10, (int)5));
            this.outerContentContainer.horizontalSizing(Sizing.fixed((int)(this.field_22789 - leftPanelSize - 20)));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.needsLayout) {
            this.needsLayout = false;
            this.updateLayout();
        }
        if (class_437.method_25441()) {
            Oracle.LOGGER.info("Opening Oracle Search...");
            Objects.requireNonNull(this.field_22787).method_1507((class_437)new SearchScreen((class_437)this));
        }
    }

    private void createActionHub(FlowLayout rootComponent) {
        FlowLayout actionHub = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        actionHub.positioning(Positioning.relative((int)99, (int)99));
        actionHub.margins(Insets.of((int)3));
        this.backAction = this.createHubAction((class_2561)class_2561.method_43471((String)"tooltip.oracle_index.back"), class_2960.method_60656((String)"textures/gui/sprites/widget/page_backward.png"), 23, 13, button -> this.back(), 24, 20);
        this.backAction.field_22764 = !this.navigationHistory.isEmpty();
        this.backAction.margins(Insets.of((int)2, (int)0, (int)0, (int)-1));
        ButtonComponent searchAction = this.createHubAction((class_2561)class_2561.method_43469((String)"tooltip.oracle_index.open_search", (Object[])new Object[]{OracleClient.ORACLE_WIKI.method_16007(), OracleClient.ORACLE_SEARCH.method_16007()}), class_2960.method_60656((String)"textures/gui/sprites/icon/search.png"), 16, 16, button -> class_310.method_1551().method_1507((class_437)new SearchScreen((class_437)this)), 24, 24);
        ButtonComponent closeAction = this.createHubAction((class_2561)class_2561.method_43471((String)"tooltip.oracle_index.close_screen"), class_2960.method_60656((String)"textures/gui/sprites/container/beacon/cancel.png"), 13, 13, button -> this.method_25419(), 20, 20);
        closeAction.margins(Insets.of((int)2, (int)0, (int)-1, (int)0));
        actionHub.child((Component)this.backAction);
        actionHub.child((Component)searchAction);
        actionHub.child((Component)closeAction);
        rootComponent.child(actionHub.zIndex(5));
    }

    private ButtonComponent createHubAction(class_2561 tooltip, class_2960 iconTexture, int texW, int texH, Consumer<ButtonComponent> onPress, int width, int height) {
        ButtonComponent main = Components.button((class_2561)class_2561.method_43473(), onPress);
        main.sizing(Sizing.fixed((int)width), Sizing.fixed((int)height));
        main.tooltip(tooltip);
        main.renderer((matrices, button, delta) -> {
            RenderSystem.enableDepthTest();
            class_2960 texture = button.field_22763 ? (button.method_49606() ? class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_hover") : class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel")) : class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_disabled");
            NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.method_25368(), (int)button.method_25364());
            int x = button.x() + (button.width() - texW) / 2 + 1;
            int y = button.y() + (button.height() - texH) / 2 - 1;
            if (button.method_49606()) {
                ++y;
            }
            matrices.method_25290(iconTexture, x, y, 0.0f, 0.0f, texW, texH, texW, texH);
        });
        return main;
    }

    private void back() {
        if (this.navigationHistory.isEmpty()) {
            return;
        }
        class_2960 target = this.navigationHistory.pop();
        try {
            this.inHistory = true;
            this.loadContentContainer(target, activeWiki);
            this.inHistory = false;
        }
        catch (IOException e) {
            Oracle.LOGGER.error("unable to open page from history: {}", (Object)e.getMessage());
        }
        this.backAction.field_22764 = !this.navigationHistory.isEmpty();
    }

    private void loadContentContainer(class_2960 filePath, String wikiId) throws IOException {
        class_3300 resourceManager;
        Optional resourceCandidate;
        class_2960 lastEntry = activeEntry;
        this.contentContainer.clearChildren();
        activeEntry = filePath;
        Optional<class_2960> translatedPath = OracleClient.getTranslatedPath(filePath, wikiId);
        if (translatedPath.isPresent()) {
            filePath = translatedPath.get();
        }
        if ((resourceCandidate = (resourceManager = class_310.method_1551().method_1478()).method_14486(filePath)).isEmpty()) {
            Oracle.LOGGER.warn("No content file found for {}", (Object)filePath);
            return;
        }
        if (!(lastEntry == null || lastEntry == activeEntry || this.inHistory || !this.navigationHistory.isEmpty() && this.navigationHistory.peek().equals((Object)lastEntry))) {
            this.navigationHistory.push(lastEntry);
        }
        if (this.backAction != null) {
            this.backAction.field_22764 = !this.navigationHistory.isEmpty();
        }
        String fileContent = new String(((class_3298)resourceCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
        class_2960 finalFilePath = filePath;
        List<Component> parsedTexts = MarkdownParser.parseMarkdownToOwoComponents(fileContent, wikiId, filePath, link -> this.onLinkClicked(wikiId, (String)link, finalFilePath));
        for (Component paragraph : parsedTexts) {
            if (paragraph == null) {
                Oracle.LOGGER.error("Got invalid paragraph in: {}", (Object)fileContent);
                continue;
            }
            if (paragraph instanceof LabelComponent) {
                LabelComponent labelComponent = (LabelComponent)paragraph;
                if (labelComponent.text() == null) {
                    Oracle.LOGGER.error("Got invalid paragraph label in: {}", (Object)fileContent);
                    continue;
                }
                paragraph.horizontalSizing(Sizing.fill());
            } else if (paragraph instanceof TextureComponent) {
                TextureComponent textureComponent = (TextureComponent)paragraph;
                ratio = (float)((PositionedRectangle)textureComponent.visibleArea().get()).width() / (float)((PositionedRectangle)textureComponent.visibleArea().get()).height();
                targetSize = (float)((Sizing)textureComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.field_22789 * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                textureComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            } else if (paragraph instanceof ItemComponent) {
                ItemComponent itemComponent = (ItemComponent)paragraph;
                ratio = 1.0f;
                targetSize = (float)((Sizing)itemComponent.verticalSizing().get()).value / 100.0f;
                maxWidth = (float)this.field_22789 * 0.6f;
                usedWidth = maxWidth * targetSize * 0.8f;
                height = usedWidth / ratio;
                itemComponent.sizing(Sizing.fixed((int)((int)usedWidth)), Sizing.fixed((int)((int)height)));
            }
            if (((Insets)paragraph.margins().get()).equals((Object)Insets.of((int)0))) {
                paragraph.margins(Insets.of((int)4, (int)1, (int)0, (int)0));
            }
            this.contentContainer.child(paragraph);
        }
    }

    private boolean onLinkClicked(String wikiId, String link, class_2960 sourceEntryPath) {
        try {
            if (link.startsWith("https")) {
                return this.tryOpenWebLink(link);
            }
            class_2960 ingameTarget = MarkdownParser.getLinkTarget(link, wikiId, sourceEntryPath);
            if (ingameTarget != null) {
                this.loadContentContainer(ingameTarget, wikiId);
                return true;
            }
            if (link.startsWith("@") || link.contains(":")) {
                String id;
                String string = id = link.startsWith("@") ? link.substring(1) : link;
                if (id.startsWith("minecraft") || !id.contains(":")) {
                    String webLink = "https://minecraft.wiki/w/" + id.replace("minecraft:", "");
                    try {
                        return this.tryOpenWebLink(webLink);
                    }
                    catch (URISyntaxException e) {
                        return false;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            Oracle.LOGGER.error("Oracle Index: Could not find/open link {}", (Object)link);
            Oracle.LOGGER.error(e.getMessage());
            return false;
        }
    }

    private boolean tryOpenWebLink(String link) throws URISyntaxException {
        URI uri = new URI(link);
        class_407 confirmScreen = new class_407(accepted -> {
            if (accepted) {
                class_156.method_668().method_673(uri);
            }
            class_310.method_1551().method_1507((class_437)this);
        }, link, true);
        class_310.method_1551().method_1507((class_437)confirmScreen);
        return true;
    }

    private void buildModNavigation(FlowLayout buttonContainer) {
        List wikiIds = OracleClient.LOADED_WIKIS.stream().sorted().toList();
        DropdownComponent modSelectorDropdown = Components.dropdown((Sizing)Sizing.content((int)3));
        modSelectorDropdown.zIndex(5);
        if (activeWiki == null) {
            activeWiki = (String)wikiIds.getFirst();
        }
        if (activeEntry != null) {
            try {
                this.loadContentContainer(activeEntry, activeWiki);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int topMargins = 40;
        if (this.field_22790 < 350) {
            topMargins = 5;
        }
        ScalableLabelComponent wikiTitleLabel = new ScalableLabelComponent((class_2561)class_2561.method_43471((String)("oracle_index.title." + activeWiki)).method_27692(class_124.field_1063).method_27693(" >").method_27692(class_124.field_1063), text -> false);
        wikiTitleLabel.scale = 1.5f;
        FlowLayout wikiTitleWrapper = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        wikiTitleWrapper.surface(MarkdownParser.ORACLE_PANEL);
        wikiTitleWrapper.padding(Insets.of((int)8));
        wikiTitleWrapper.margins(Insets.of((int)topMargins, (int)-7, (int)0, (int)0));
        wikiTitleWrapper.child((Component)wikiTitleLabel);
        buttonContainer.child(wikiTitleWrapper.zIndex(5));
        wikiTitleWrapper.mouseEnter().subscribe(() -> wikiTitleWrapper.surface(MarkdownParser.ORACLE_PANEL_HOVER));
        wikiTitleWrapper.mouseLeave().subscribe(() -> wikiTitleWrapper.surface(MarkdownParser.ORACLE_PANEL));
        wikiTitleWrapper.mouseDown().subscribe((a, b, c) -> {
            if (modSelectorDropdown.hasParent()) {
                modSelectorDropdown.remove();
                return true;
            }
            this.rootComponent.child((Component)modSelectorDropdown.positioning(Positioning.absolute((int)(wikiTitleWrapper.x() + wikiTitleWrapper.width()), (int)wikiTitleWrapper.y())));
            return true;
        });
        for (String wikiId : wikiIds) {
            modSelectorDropdown.button((class_2561)class_2561.method_43471((String)("oracle_index.title." + wikiId)), elem -> {
                activeEntry = null;
                modSelectorDropdown.remove();
                this.buildModNavigationBar(wikiId);
                wikiTitleLabel.text((class_2561)class_2561.method_43471((String)("oracle_index.title." + wikiId)).method_27692(class_124.field_1063).method_27693(" >").method_27692(class_124.field_1063));
                activeWiki = wikiId;
            });
        }
        this.buildModNavigationBar(activeWiki);
    }

    private String getWikiMode(String wikiId) {
        Set<String> availableModes = OracleClient.AVAILABLE_MODES.getOrDefault(wikiId, Set.of("docs"));
        if (availableModes.contains(activeWikiMode)) {
            return activeWikiMode;
        }
        return (String)availableModes.stream().findFirst().get();
    }

    private boolean canSwitchWikiMode(String wikiId) {
        return OracleClient.AVAILABLE_MODES.getOrDefault(wikiId, Set.of("docs")).size() > 1;
    }

    private void buildModNavigationBar(String wikiId) {
        this.navigationBar.clearChildren();
        activeWikiMode = this.getWikiMode(wikiId);
        if (this.canSwitchWikiMode(wikiId)) {
            this.addModeSelector(this.navigationBar);
        }
        String path = activeWikiMode.equals("docs") ? "" : "/.content";
        this.buildNavigationEntriesForModPath(wikiId, path, this.navigationBar);
    }

    private void addModeSelector(FlowLayout navBar) {
        FlowLayout container = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        Component docsButton = this.createModeButton("docs");
        Component contentButton = this.createModeButton("content");
        container.child(docsButton);
        container.child(contentButton);
        container.horizontalAlignment(HorizontalAlignment.CENTER);
        navBar.child((Component)container);
    }

    private Component createModeButton(String mode) {
        boolean isActive = !activeWikiMode.equals(mode);
        class_5250 text = class_2561.method_43471((String)("oracle_index.button." + mode)).method_27692(isActive ? class_124.field_1063 : class_124.field_1068);
        ButtonComponent comp = Components.button((class_2561)text, elem -> {
            if (!activeWikiMode.equals(mode)) {
                activeWikiMode = mode;
                activeEntry = null;
                this.buildModNavigationBar(activeWiki);
            }
        });
        comp.renderer((matrices, button, delta) -> {
            RenderSystem.enableDepthTest();
            class_2960 texture = button.field_22763 ? (button.method_49606() ? class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_hover") : class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel")) : class_2960.method_60655((String)"oracle_index", (String)"bedrock_panel_disabled");
            NinePatchTexture.draw((class_2960)texture, (OwoUIDrawContext)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)button.method_25368(), (int)button.method_25364());
        });
        comp.margins(Insets.of((int)2, (int)4, (int)0, (int)0));
        comp.textShadow(false);
        comp.method_25358(60);
        comp.active(isActive);
        return comp;
    }

    private boolean buildNavigationEntriesForModPath(String wikiId, String path, FlowLayout container) {
        Optional resourceCandidate;
        class_3300 resourceManager = class_310.method_1551().method_1478();
        class_2960 metaPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + wikiId + path + "/_meta.json"));
        Optional<class_2960> translatedMetaPath = OracleClient.getTranslatedPath(metaPath, wikiId);
        if (translatedMetaPath.isPresent()) {
            metaPath = translatedMetaPath.get();
        }
        if ((resourceCandidate = resourceManager.method_14486(metaPath)).isEmpty()) {
            Oracle.LOGGER.warn("No _meta.json found for {} at {}", (Object)wikiId, (Object)metaPath);
            return false;
        }
        boolean anyUnlocked = false;
        try {
            Optional<MetaJsonEntry> firstEntry;
            String metaFile = new String(((class_3298)resourceCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
            List<MetaJsonEntry> entries = OracleScreen.parseJson(metaFile);
            ArrayList<ColoredCollapsibleContainer> levelContainers = new ArrayList<ColoredCollapsibleContainer>();
            for (MetaJsonEntry entry : entries) {
                if (entry.directory) {
                    ColoredCollapsibleContainer directoryContainer = new ColoredCollapsibleContainer(Sizing.content((int)1), Sizing.content((int)1), (class_2561)class_2561.method_43471((String)entry.name()).method_27692(class_124.field_1068), false);
                    boolean anyChildrenUnlocked = this.buildNavigationEntriesForModPath(wikiId, path + "/" + entry.id(), (FlowLayout)directoryContainer);
                    if (anyChildrenUnlocked) {
                        anyUnlocked = true;
                    }
                    directoryContainer.margins(Insets.of((int)0, (int)0, (int)0, (int)0));
                    directoryContainer.mouseDown().subscribe((a, b, c) -> {
                        for (ColoredCollapsibleContainer elem : levelContainers) {
                            if (elem == directoryContainer || !elem.expanded()) continue;
                            elem.toggleExpansion();
                        }
                        this.needsLayout = true;
                        return false;
                    });
                    if (!anyChildrenUnlocked) continue;
                    container.child((Component)directoryContainer);
                    levelContainers.add(directoryContainer);
                    continue;
                }
                class_2960 labelPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + wikiId + path + "/" + entry.id()));
                String shownName = entry.name;
                if (shownName.isBlank()) {
                    Optional contentCandidate = resourceManager.method_14486(labelPath);
                    if (contentCandidate.isEmpty()) {
                        Oracle.LOGGER.warn("Unable to get content for name from frontmatter for entry: {}", (Object)labelPath);
                        shownName = "<ERROR>";
                    } else {
                        String fileContent = new String(((class_3298)contentCandidate.get()).method_14482().readAllBytes(), StandardCharsets.UTF_8);
                        Map<String, String> frontMatter = MarkdownParser.parseFrontmatter(fileContent);
                        shownName = MarkdownParser.getTitle(frontMatter, labelPath);
                    }
                }
                PAGE_FALLBACK_NAMES.put(labelPath, shownName);
                class_5250 labelText = class_2561.method_43471((String)shownName).method_27692(class_124.field_1068);
                LabelComponent label = Components.label((class_2561)labelText.method_27692(class_124.field_1073));
                boolean isUnlocked = true;
                if (OracleClient.UNLOCK_CRITERIONS.containsKey(labelPath.method_12832())) {
                    class_3545<String, String> unlockData = OracleClient.UNLOCK_CRITERIONS.get(labelPath.method_12832());
                    isUnlocked = OracleProgressAPI.IsUnlocked(wikiId, labelPath.method_12832(), (String)unlockData.method_15442(), (String)unlockData.method_15441());
                }
                if (isUnlocked) {
                    anyUnlocked = true;
                    label.mouseEnter().subscribe(() -> label.text((class_2561)labelText.method_27661().method_27692(class_124.field_1080)));
                    label.mouseLeave().subscribe(() -> label.text((class_2561)labelText.method_27661()));
                    label.mouseDown().subscribe((a, b, c) -> {
                        try {
                            this.loadContentContainer(labelPath, wikiId);
                            return true;
                        }
                        catch (IOException e) {
                            Oracle.LOGGER.error(e.getMessage());
                            return false;
                        }
                    });
                } else {
                    label.text((class_2561)labelText.method_27692(class_124.field_1051));
                }
                label.margins(Insets.of((int)3, (int)2, (int)5, (int)2));
                container.child((Component)label);
            }
            if (activeEntry == null && (firstEntry = entries.stream().filter(elem -> !elem.directory).findFirst()).isPresent()) {
                class_2960 firstEntryPath = class_2960.method_60655((String)"oracle_index", (String)("books/" + wikiId + path + "/" + firstEntry.get().id()));
                this.loadContentContainer(firstEntryPath, wikiId);
                activeEntry = firstEntryPath;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return anyUnlocked;
    }

    private static List<MetaJsonEntry> parseJson(String jsonString) {
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonString, JsonObject.class);
        ArrayList<MetaJsonEntry> entries = new ArrayList<MetaJsonEntry>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            boolean directory;
            String id = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            boolean bl = directory = !id.endsWith(".mdx");
            String name = value instanceof JsonPrimitive ? value.getAsString() : (value instanceof JsonObject ? ((JsonObject)value).get("name").getAsString() : "Unknown Name");
            entries.add(new MetaJsonEntry(id, name, directory));
        }
        return entries;
    }

    @NotNull
    public static String parsePathLink(String link, class_2960 sourceEntryPath) {
        String cleanLink = link.split("#")[0];
        Path currentPathObj = Path.of(sourceEntryPath.method_12832(), new String[0]);
        Path currentParentDir = currentPathObj.getParent();
        if (currentParentDir == null) {
            currentParentDir = Path.of("", new String[0]);
        }
        Path resolvedPath = currentParentDir.resolve(cleanLink).normalize();
        return resolvedPath.toString().replace("\\", "/");
    }

    public record MetaJsonEntry(String id, String name, boolean directory) {
        @Override
        public String toString() {
            return "MetaJsonEntry{id='" + this.id + "', name='" + this.name + "', directory=" + this.directory + "}";
        }
    }
}

