/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.List;
import java.util.Optional;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.api.fx.ParticlePlacement;
import net.bettercombat.api.fx.TrailAppearance;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.animation.AttackAnimationSubStack;
import net.bettercombat.client.animation.CustomAnimationPlayer;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.animation.PoseSubStack;
import net.bettercombat.client.animation.StateCollectionHelper;
import net.bettercombat.client.animation.modifier.HarshAdjustmentModifier;
import net.bettercombat.client.animation.modifier.TransmissionSpeedModifier;
import net.bettercombat.client.compat.FirstPersonAnimationCompatibility;
import net.bettercombat.client.particle.SlashParticleUtil;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.Pose;
import net.bettercombat.mixin.player.LivingEntityAccessor;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements PlayerAttackAnimatable {
    private final AttackAnimationSubStack attackAnimation = new AttackAnimationSubStack(this.createAttackAdjustment());
    private final PoseSubStack mainHandBodyPose = new PoseSubStack((AbstractModifier)this.createPoseAdjustment(), true, true);
    private final PoseSubStack mainHandItemPose = new PoseSubStack(null, false, true);
    private final PoseSubStack offHandBodyPose = new PoseSubStack(null, true, false);
    private final PoseSubStack offHandItemPose = new PoseSubStack(null, false, true);
    @Nullable
    private SlashParticleUtil.ScheduledSpawnArgs scheduledParticles = null;

    public AbstractClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 world, GameProfile profile, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(1, (IAnimation)this.offHandItemPose.base);
        stack.addAnimLayer(2, (IAnimation)this.offHandBodyPose.base);
        stack.addAnimLayer(3, (IAnimation)this.mainHandItemPose.base);
        stack.addAnimLayer(4, (IAnimation)this.mainHandBodyPose.base);
        stack.addAnimLayer(2000, (IAnimation)this.attackAnimation.base);
        this.mainHandBodyPose.configure = this::updateAnimationByCurrentActivity;
        this.offHandBodyPose.configure = this::updateAnimationByCurrentActivity;
    }

    @Override
    public void updateAnimationsOnTick() {
        AbstractClientPlayerEntityMixin instance = this;
        class_1657 player = instance;
        boolean isLeftHanded = this.isLeftHanded();
        boolean hasActiveAttackAnimation = this.attackAnimation.base.getAnimation() != null && this.attackAnimation.base.getAnimation().isActive();
        class_1799 mainHandStack = player.method_6047();
        if (this.scheduledParticles != null && this.scheduledParticles.time() == player.field_6012) {
            SlashParticleUtil.spawnParticles(this.scheduledParticles.args());
            this.scheduledParticles = null;
        }
        if (player.field_6252 || player.method_5681() || player.method_6115() || player.method_6101() || player.method_6128() || Platform.isCastingSpell(player) || class_1764.method_7781((class_1799)mainHandStack)) {
            this.mainHandBodyPose.setPose(null, isLeftHanded);
            this.mainHandItemPose.setPose(null, isLeftHanded);
            this.offHandBodyPose.setPose(null, isLeftHanded);
            this.offHandItemPose.setPose(null, isLeftHanded);
            return;
        }
        if (hasActiveAttackAnimation) {
            ((LivingEntityAccessor)player).invokeTurnHead(player.method_5791(), 0.0f);
        }
        EntityPlayer_BetterCombat betterCombatPlayer = (EntityPlayer_BetterCombat)player;
        KeyframeAnimation newMainHandPose = null;
        KeyframeAnimation newOffHandPose = null;
        if (class_310.method_1551().field_1724 == player) {
            Pose pose = PlayerAttackHelper.poseForPlayer(player);
            if (!pose.base().isEmpty()) {
                newMainHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)pose.base()));
            }
            if (!pose.offHand().isEmpty()) {
                newOffHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)pose.offHand()));
            }
        } else {
            if (betterCombatPlayer.getMainHandIdleAnimation() != null && !betterCombatPlayer.getMainHandIdleAnimation().isEmpty()) {
                newMainHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)betterCombatPlayer.getMainHandIdleAnimation()));
            }
            if (betterCombatPlayer.getOffHandIdleAnimation() != null && !betterCombatPlayer.getOffHandIdleAnimation().isEmpty()) {
                newOffHandPose = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)betterCombatPlayer.getOffHandIdleAnimation()));
            }
        }
        this.mainHandItemPose.setPose(newMainHandPose, isLeftHanded);
        this.offHandItemPose.setPose(newOffHandPose, isLeftHanded);
        if (!PlayerAttackHelper.isTwoHandedWielding(player) && (this.isWalking() || this.method_5715())) {
            newMainHandPose = null;
            newOffHandPose = null;
        }
        this.mainHandBodyPose.setPose(newMainHandPose, isLeftHanded);
        this.offHandBodyPose.setPose(newOffHandPose, isLeftHanded);
    }

    @Override
    public void playAttackAnimation(String name, AnimatedHand animatedHand, float length, float upswing) {
        try {
            KeyframeAnimation animation = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((class_2960)class_2960.method_60654((String)name));
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.updateAnimationByCurrentActivity(copy);
            copy.torso.fullyEnablePart(true);
            copy.head.pitch.setEnabled(false);
            float speed = (float)animation.endTick / length;
            boolean mirror = animatedHand.isOffHand();
            if (this.isLeftHanded()) {
                mirror = !mirror;
            }
            int fadeIn = copy.beginTick;
            float upswingSpeed = speed / BetterCombatMod.config.getUpswingMultiplier();
            float downwindSpeed = (float)((double)speed * class_3532.method_16436((double)(Math.max((double)BetterCombatMod.config.getUpswingMultiplier() - 0.5, 0.0) / 0.5), (double)(1.0f - upswing), (double)(upswing / (1.0f - upswing))));
            this.attackAnimation.speed.set(upswingSpeed, List.of(new TransmissionSpeedModifier.Gear(length * upswing, downwindSpeed), new TransmissionSpeedModifier.Gear(length, speed)));
            this.attackAnimation.mirror.setEnabled(mirror);
            CustomAnimationPlayer player = new CustomAnimationPlayer(copy.build(), 0);
            player.setFirstPersonMode(FirstPersonAnimationCompatibility.firstPersonMode());
            player.setFirstPersonConfiguration(this.firstPersonConfig(animatedHand));
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void playAttackParticles(boolean isOffHand, float weaponRange, int delay, List<ParticlePlacement> particles, TrailAppearance appearance) {
        class_742 player = (class_742)this;
        SlashParticleUtil.SpawnArgs spawn = new SlashParticleUtil.SpawnArgs(player, isOffHand, weaponRange, particles, appearance);
        this.scheduledParticles = new SlashParticleUtil.ScheduledSpawnArgs(spawn, player.field_6012 + delay);
    }

    private AdjustmentModifier createAttackAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float offsetZ;
            float offsetY;
            float offsetX;
            float rotationZ;
            float rotationY;
            float rotationX;
            block20: {
                block19: {
                    rotationX = 0.0f;
                    rotationY = 0.0f;
                    rotationZ = 0.0f;
                    offsetX = 0.0f;
                    offsetY = 0.0f;
                    offsetZ = 0.0f;
                    if (!FirstPersonMode.isFirstPersonPass()) break block19;
                    float pitch = player.method_36455();
                    pitch = (float)Math.toRadians(pitch);
                    switch (partName) {
                        case "body": {
                            rotationX -= pitch;
                            if (pitch < 0.0f) {
                                double offset = Math.abs(Math.sin(pitch));
                                offsetY = (float)((double)offsetY + offset * 0.5);
                                offsetZ = (float)((double)offsetZ - offset);
                                break;
                            }
                            break block20;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break block20;
                }
                float pitch = player.method_36455();
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "body": {
                        rotationX -= pitch * 0.75f;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX += pitch * 0.25f;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = (float)((double)rotationX - (double)pitch * 0.75);
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private AdjustmentModifier createPoseAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new HarshAdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (!FirstPersonMode.isFirstPersonPass()) {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        if (this.mainHandItemPose.lastAnimationUsesBodyChannel || !player.method_18276()) break;
                        offsetY += 3.0f;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private void updateAnimationByCurrentActivity(KeyframeAnimation.AnimationBuilder animation) {
        class_4050 pose = this.method_18376();
        switch (pose) {
            case field_18076: {
                break;
            }
            case field_18077: {
                break;
            }
            case field_18078: {
                break;
            }
            case field_18079: {
                StateCollectionHelper.configure(animation.rightLeg, false, false);
                StateCollectionHelper.configure(animation.leftLeg, false, false);
                break;
            }
            case field_18080: {
                break;
            }
            case field_18081: {
                break;
            }
            case field_30095: {
                break;
            }
        }
        if (this.isMounting()) {
            StateCollectionHelper.configure(animation.rightLeg, false, false);
            StateCollectionHelper.configure(animation.leftLeg, false, false);
        } else {
            float legAnimationThreshold = BetterCombatClientMod.config.legAnimationThreshold;
            if (BetterCombatClientMod.config.legAnimationThreshold > 0.0f) {
                boolean moving;
                boolean bl = moving = this.method_5624() || this.isWalking();
                if (moving && this.method_18798().method_37268() > (double)(legAnimationThreshold * legAnimationThreshold)) {
                    StateCollectionHelper.configure(animation.rightLeg, false, false);
                    StateCollectionHelper.configure(animation.leftLeg, false, false);
                }
            }
        }
    }

    private boolean isWalking() {
        return !this.method_29504() && (this.method_5681() || this.method_18798().method_37267() > 0.03);
    }

    private boolean isMounting() {
        return this.method_5854() != null;
    }

    public boolean isLeftHanded() {
        return this.method_6068() == class_1306.field_6182;
    }

    @Override
    public void stopAttackAnimation(float length) {
        IAnimation currentAnimation = this.attackAnimation.base.getAnimation();
        this.scheduledParticles = null;
        if (currentAnimation != null && currentAnimation instanceof KeyframeAnimationPlayer) {
            int fadeOut = Math.round(length);
            this.attackAnimation.adjustmentModifier.fadeOut(fadeOut);
            this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeOut, (Ease)Ease.INOUTSINE), null);
        }
    }

    private FirstPersonConfiguration firstPersonConfig(AnimatedHand animatedHand) {
        boolean showRightItem = true;
        boolean showLeftItem = BetterCombatClientMod.config.isShowingOtherHandFirstPerson || animatedHand == AnimatedHand.TWO_HANDED;
        boolean showRightArm = showRightItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        boolean showLeftArm = showLeftItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        FirstPersonConfiguration config = new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem);
        return config;
    }
}

