/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.bettercombat.api.client.AttackRangeExtensions;
import net.bettercombat.client.particle.TrailParticles;
import net.bettercombat.compat.CompatFeatures;
import net.bettercombat.config.FallbackConfig;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.config.ServerConfigWrapper;
import net.bettercombat.config.TrailConfig;
import net.bettercombat.logic.WeaponAttributesFallback;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.server.MinecraftServer;
import net.tiny_config.ConfigManager;
import org.slf4j.Logger;

public class BetterCombatMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID = "bettercombat";
    public static ServerConfig config;
    private static FallbackConfig fallbackDefault;
    public static ConfigManager<FallbackConfig> fallbackConfig;
    public static ConfigManager<TrailConfig> trailConfig;

    public static void init() {
        trailConfig.refresh();
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        BetterCombatMod.loadFallbackConfig();
        AttackRangeExtensions.register(context -> new AttackRangeExtensions.Modifier(context.player().method_55693(), AttackRangeExtensions.Operation.MULTIPLY));
        CompatFeatures.init();
    }

    public static ServerConfig getConfig() {
        return config;
    }

    private static void loadFallbackConfig() {
        fallbackConfig.load();
        if (BetterCombatMod.fallbackConfig.value == null) {
            BetterCombatMod.fallbackConfig.value = FallbackConfig.createDefault();
        }
        if (((FallbackConfig)BetterCombatMod.fallbackConfig.value).schema_version < BetterCombatMod.fallbackDefault.schema_version) {
            BetterCombatMod.fallbackConfig.value = FallbackConfig.migrate((FallbackConfig)BetterCombatMod.fallbackConfig.value, FallbackConfig.createDefault());
        }
        fallbackConfig.save();
    }

    public static void loadWeaponAttributes(MinecraftServer server) {
        WeaponRegistry.loadAttributes(server.method_34864());
        if (BetterCombatMod.config.fallback_compatibility_enabled) {
            WeaponAttributesFallback.initialize();
        }
        WeaponRegistry.encodeRegistry();
    }

    static {
        fallbackDefault = FallbackConfig.createDefault();
        fallbackConfig = new ConfigManager("fallback_compatibility", (Object)fallbackDefault).builder().setDirectory(ID).sanitize(true).build();
        trailConfig = new ConfigManager("weapon_trails", (Object)TrailParticles.defaults()).builder().setDirectory(ID).sanitize(true).build();
    }
}

