/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.class_3532;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounterDecimal
extends GuiParent {
    public static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    public double min;
    public double max;
    public final GuiParent buttons = new GuiParent(GuiFlow.STACK_Y);
    public GuiTextfield textfield;
    public double stepAmount;
    public final ControlFormatting buttonsFormatting;

    public GuiCounterDecimal(String name, double value) {
        this(name, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public GuiCounterDecimal(String name, double value, double min, double max) {
        this(name, value, min, max, ControlFormatting.TRANSPARENT);
    }

    public GuiCounterDecimal(String name, double value, double min, double max, ControlFormatting buttonsFormatting) {
        super(name);
        this.min = min;
        this.max = max;
        this.stepAmount = 1.0;
        this.setSpacing(1);
        this.flow = GuiFlow.STACK_X;
        this.textfield = new GuiTextfield("value", "" + class_3532.method_15350((double)value, (double)min, (double)max)).setDim(30, 10).setFloatOnly();
        this.buttons.spacing = 0;
        this.buttonsFormatting = buttonsFormatting;
        this.createButtons();
        this.add(this.textfield.setExpandableX());
        this.add((GuiControl)this.buttons);
    }

    protected void createButtons() {
        this.buttons.add(new GuiButtonHoldSlim("+", x -> this.stepUp()){

            @Override
            public ControlFormatting getControlFormatting() {
                return GuiCounterDecimal.this.buttonsFormatting;
            }
        }.setTranslate("gui.plus").setDim(6, 3));
        this.buttons.add(new GuiButtonHoldSlim("-", x -> this.stepDown()){

            @Override
            public ControlFormatting getControlFormatting() {
                return GuiCounterDecimal.this.buttonsFormatting;
            }
        }.setTranslate("gui.minus").setDim(6, 3));
    }

    @Override
    public GuiCounterDecimal setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    @Override
    public GuiCounterDecimal add(GuiControl control) {
        return (GuiCounterDecimal)super.add(control);
    }

    public GuiButtonHoldSlim getPlusButton() {
        return (GuiButtonHoldSlim)this.buttons.get("+");
    }

    public GuiButtonHoldSlim getMinusButton() {
        return (GuiButtonHoldSlim)this.buttons.get("-");
    }

    public GuiCounterDecimal setStep(double amount) {
        this.stepAmount = amount;
        return this;
    }

    public DecimalFormat getFormat() {
        return FORMAT;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent<GuiCounterDecimal>(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    public void stepUp() {
        this.setValue(this.getValue() + this.stepAmount);
    }

    public void stepDown() {
        this.setValue(this.getValue() - this.stepAmount);
    }

    public double getValue() {
        return class_3532.method_15350((double)this.textfield.parseDouble(), (double)this.min, (double)this.max);
    }

    public void setValue(double value) {
        this.textfield.setText(this.getFormat().format(class_3532.method_15350((double)value, (double)this.min, (double)this.max)));
        this.raiseEvent(new GuiControlChangedEvent<GuiCounterDecimal>(this));
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }
}

