/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeArray;
import team.creative.creativecore.common.config.converation.ConfigTypeList;
import team.creative.creativecore.common.config.converation.ConfigTypeNamedList;
import team.creative.creativecore.common.config.converation.ConfigTypeNumber;
import team.creative.creativecore.common.config.converation.ConfigTypePermission;
import team.creative.creativecore.common.config.converation.ConfigTypeToggleable;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryObject;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryObjectList;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryTag;
import team.creative.creativecore.common.config.converation.registry.ConfigTypeRegistryTagList;
import team.creative.creativecore.common.config.core.ICreativeRegistry;
import team.creative.creativecore.common.config.field.ConfigField;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.config.premade.NamedList;
import team.creative.creativecore.common.config.premade.Permission;
import team.creative.creativecore.common.config.premade.SelectableConfig;
import team.creative.creativecore.common.config.premade.SoundConfig;
import team.creative.creativecore.common.config.premade.ToggleableConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryObjectListConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryTagConfig;
import team.creative.creativecore.common.config.premade.registry.RegistryTagListConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public abstract class ConfigTypeConveration<T> {
    private static final HashMap<Class, Function<ConfigField, ?>> TYPE_CREATORS = new HashMap();
    private static final HashMap<Class, Function<ConfigField, Type>> TYPE_GETTERS = new HashMap();
    private static final HashMap<Class, Function<ConfigField, ?>> COLLECTION_CREATORS = new HashMap();
    private static final HashMap<Class, ConfigTypeConveration> TYPES = new HashMap();
    private static final PairList<Predicate<Class>, ConfigTypeConveration> SPECIAL_TYPES = new PairList();
    public static final ICreativeConfigHolder FAKE_PARENT = new ICreativeConfigHolder(){

        @Override
        public ConfigSynchronization synchronization() {
            return ConfigSynchronization.UNIVERSAL;
        }

        @Override
        public JsonObject save(class_7225.class_7874 provider, boolean saveDefault, boolean ignoreRestart, Side side) {
            return null;
        }

        @Override
        public void restoreDefault(Side side, boolean ignoreRestart) {
        }

        @Override
        public String[] path() {
            return new String[0];
        }

        @Override
        public ICreativeConfigHolder parent() {
            return null;
        }

        @Override
        public Collection<String> names() {
            return null;
        }

        @Override
        public void load(class_7225.class_7874 provider, boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        }

        @Override
        public boolean isEmptyWithoutForce(Side side) {
            return false;
        }

        @Override
        public boolean isEmpty(Side side) {
            return false;
        }

        @Override
        public boolean isDefault(Side side) {
            return false;
        }

        @Override
        public ConfigKey getField(String key) {
            return null;
        }

        @Override
        public Object get(String key) {
            return null;
        }

        @Override
        public Collection<? extends ConfigKey> fields() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public void configured(Side side) {
        }

        @Override
        public ICreativeRegistry getRegistry() {
            throw new UnsupportedOperationException("This fake parent should never be used to get the registry");
        }
    };

    public static boolean isTypeCreator(Class clazz) {
        return TYPE_CREATORS.containsKey(clazz);
    }

    public static <T, U extends T> void registerTypeCreator(Class<U> clazz, Function<ConfigField, T> type) {
        TYPE_CREATORS.put(clazz, type);
    }

    public static <T, U extends T> void registerTypeCreator(Class<U> clazz, Supplier<T> type) {
        TYPE_CREATORS.put(clazz, x -> type.get());
    }

    public static void registerTypeGetter(Class clazz, Function<ConfigField, Type> getter) {
        TYPE_GETTERS.put(clazz, getter);
    }

    public static <T, U extends T> void registerCollectionCreator(Class<U> clazz, Function<ConfigField, T> getter) {
        COLLECTION_CREATORS.put(clazz, getter);
    }

    public static <T, U extends T> ConfigTypeConveration<T> registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        TYPES.put(clazz, type);
        return type;
    }

    public static <T> void registerTypes(ConfigTypeConveration<T> type, Class<? extends T> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            TYPES.put(classes[i], type);
        }
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        SPECIAL_TYPES.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (TYPES.containsKey(typeClass)) {
            return true;
        }
        if (typeClass.isAnnotationPresent(CreativeConfig.class)) {
            return false;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = TYPES.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static ConfigTypeConveration getUnsafe(Class typeClass) {
        ConfigTypeConveration converation = TYPES.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < SPECIAL_TYPES.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.SPECIAL_TYPES.get((int)i)).value;
        }
        return null;
    }

    public static Object createObject(ConfigField field) {
        Function<ConfigField, ?> func = TYPE_CREATORS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        try {
            return field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public static Type getGenericType(ConfigField field) {
        Function<ConfigField, Type> func = TYPE_GETTERS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        Type type = field.getGenericType();
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return p.getActualTypeArguments()[0];
        }
        throw new UnsupportedOperationException("This type is not supported " + String.valueOf(type));
    }

    public static Type getGenericType(ConfigKey key) {
        return ConfigTypeConveration.getGenericType(key.field());
    }

    public static Object createCollection(ConfigField field) {
        Function<ConfigField, ?> func = COLLECTION_CREATORS.get(field.getType());
        if (func != null) {
            return func.apply(field);
        }
        return null;
    }

    public static Object createCollection(ConfigKey key) {
        return ConfigTypeConveration.createCollection(key.field());
    }

    public abstract T readElement(class_7225.class_7874 var1, T var2, boolean var3, boolean var4, JsonElement var5, Side var6, ConfigKey var7);

    public abstract JsonElement writeElement(class_7225.class_7874 var1, T var2, boolean var3, boolean var4, Side var5, ConfigKey var6);

    @Environment(value=EnvType.CLIENT)
    public abstract void createControls(GuiParent var1, IGuiConfigParent var2, ConfigKey var3, Side var4);

    @Environment(value=EnvType.CLIENT)
    public abstract void loadValue(T var1, T var2, GuiParent var3, IGuiConfigParent var4, ConfigKey var5, Side var6);

    @Environment(value=EnvType.CLIENT)
    public void restoreDefault(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        this.loadValue(value, value, parent, configParent, key, side);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldSave(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        return !key.get().equals(value);
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract T saveValue(GuiParent var1, IGuiConfigParent var2, ConfigKey var3, Side var4);

    public abstract T set(ConfigKey var1, T var2);

    @Environment(value=EnvType.CLIENT)
    public T save(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        T value = this.saveValue(parent, configParent, key, side);
        if (value != null && key != null) {
            return this.set(key, value);
        }
        return value;
    }

    public boolean areEqual(T one, T two, ConfigKey key, Side side) {
        return one.equals(two);
    }

    static {
        ConfigTypeNumber.init();
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(ConfigKey key, String defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, ConfigKey key, Side side) {
                return new JsonPrimitive(value);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(String value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected String saveValue(GuiParent parent, ConfigKey key) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return button.getText();
            }

            @Override
            public String set(ConfigKey key, String value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(String.class, () -> "");
        ConfigTypeConveration.registerType(class_2960.class, new SimpleConfigTypeConveration<class_2960>(){

            @Override
            public class_2960 readElement(ConfigKey key, class_2960 defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return class_2960.method_60654((String)element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(class_2960 value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.toString());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(class_2960 value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value.toString());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected class_2960 saveValue(GuiParent parent, ConfigKey key) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return class_2960.method_60654((String)button.getText());
            }

            @Override
            public class_2960 set(ConfigKey key, class_2960 value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(class_2960.class, () -> class_2960.method_60656((String)""));
        ConfigTypeConveration.registerType(SoundConfig.class, new ConfigTypeConveration<SoundConfig>(){

            @Override
            public SoundConfig readElement(class_7225.class_7874 provider, SoundConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonObject()) {
                    return new SoundConfig(class_2960.method_60654((String)element.getAsJsonObject().get("sound").getAsString()), element.getAsJsonObject().get("volume").getAsFloat(), element.getAsJsonObject().get("pitch").getAsFloat());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(class_7225.class_7874 provider, SoundConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                JsonObject json = new JsonObject();
                json.addProperty("sound", value.event.toString());
                json.addProperty("volume", (Number)Float.valueOf(value.volume));
                json.addProperty("pitch", (Number)Float.valueOf(value.pitch));
                return json;
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add((GuiControl)new GuiComboBox<class_2960>("sound", new TextMapBuilder<class_2960>().addComponent(class_7923.field_41172.method_10235(), x -> {
                    if (x.method_12836().equals("minecraft")) {
                        return class_2561.method_43470((String)x.method_12832());
                    }
                    return class_2561.method_43470((String)x.toString());
                })).setSearchbar(true));
                GuiParent hBox = new GuiParent(GuiFlow.STACK_X).add((GuiControl)new GuiLabel("volumeLabel").setTranslate("gui.volume")).add(new GuiSlider("volume", 1.0, 0.0, 1.0).setDim(40, 10)).add((GuiControl)new GuiLabel("pitchLabel").setTranslate("gui.pitch")).add(new GuiSlider("pitch", 1.0, 0.5, 2.0).setDim(40, 10));
                parent.add((GuiControl)hBox);
                hBox.add((GuiControl)new GuiButton("play", x -> {
                    GuiComboBox box = (GuiComboBox)parent.get("sound");
                    GuiSlider volume = (GuiSlider)parent.get("volume");
                    GuiSlider pitch = (GuiSlider)parent.get("pitch");
                    class_3414 sound = (class_3414)class_7923.field_41172.method_10223((class_2960)box.selected());
                    if (sound != null) {
                        GuiControl.playSound(sound, (float)volume.getValue(), (float)pitch.getValue());
                    }
                }).setTranslate("gui.play"));
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(SoundConfig value, SoundConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBox box = (GuiComboBox)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                box.select(value.event);
                volume.setValue(value.volume);
                pitch.setValue(value.pitch);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected SoundConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBox box = (GuiComboBox)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                return new SoundConfig((class_2960)box.selected(), (float)volume.getValue(), (float)pitch.getValue());
            }

            @Override
            public SoundConfig set(ConfigKey key, SoundConfig value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(SoundConfig.class, () -> new SoundConfig(class_2960.method_60656((String)"missing")));
        ConfigTypeConveration.registerType(RegistryObjectConfig.class, new ConfigTypeRegistryObject());
        ConfigTypeConveration.registerType(RegistryObjectListConfig.class, new ConfigTypeRegistryObjectList());
        ConfigTypeConveration.registerType(RegistryTagConfig.class, new ConfigTypeRegistryTag());
        ConfigTypeConveration.registerType(RegistryTagListConfig.class, new ConfigTypeRegistryTagList());
        ConfigTypeConveration.registerType(SelectableConfig.class, new ConfigTypeConveration<SelectableConfig>(){

            @Override
            public SelectableConfig readElement(class_7225.class_7874 provider, SelectableConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    defaultValue.select(element.getAsInt());
                } else {
                    defaultValue.reset();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(class_7225.class_7874 provider, SelectableConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                return new JsonPrimitive((Number)value.getSelected());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                SelectableConfig value = (SelectableConfig)key.get();
                configParent.setCustomData(value.getSelected());
                parent.add(new GuiComboBox<Object>("data", new TextMapBuilder<Object>().addComponent(value.getArray(), x -> class_2561.method_43470((String)x.toString()))).setExpandableX());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(SelectableConfig value, SelectableConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.getSelected());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void restoreDefault(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                value.reset();
                this.loadValue(value, value, parent, configParent, key, side);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected SelectableConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                SelectableConfig config = (SelectableConfig)key.get();
                GuiComboBox box = (GuiComboBox)parent.get("data");
                config.select(box.selectedIndex());
                return config;
            }

            @Override
            public SelectableConfig set(ConfigKey key, SelectableConfig value) {
                return value;
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public boolean shouldSave(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                return value.getSelected() != ((Integer)configParent.getCustomData()).intValue();
            }
        });
        ConfigTypeConveration.registerType(NamedList.class, new ConfigTypeNamedList());
        ConfigTypeConveration.registerType(Permission.class, new ConfigTypePermission());
        ConfigTypeConveration.registerTypeCreator(MobEffectConfig.class, () -> new MobEffectConfig((class_2378<class_1291>)class_7923.field_41174, class_2960.method_60656((String)"slowness"), 2, 1, false));
        ConfigTypeConveration.registerType(ToggleableConfig.class, new ConfigTypeToggleable());
        ConfigTypeConveration.registerTypes(new SimpleConfigTypeConveration<IntMatrix3c>(){

            @Override
            public IntMatrix3c readElement(ConfigKey key, IntMatrix3c defaultValue, Side side, JsonElement element) {
                JsonArray a;
                if (element instanceof JsonArray && (a = (JsonArray)element).size() == 9) {
                    int[] array = new int[9];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = a.get(i).getAsInt();
                    }
                    return new IntMatrix3(array);
                }
                return new IntMatrix3(defaultValue);
            }

            @Override
            public JsonElement writeElement(IntMatrix3c value, ConfigKey key, Side side) {
                JsonArray json = new JsonArray(9);
                int[] array = value.getAsArray();
                for (int i = 0; i < array.length; ++i) {
                    json.add((Number)array[i]);
                }
                return json;
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.flow = GuiFlow.STACK_Y;
                GuiParent r = new GuiParent();
                parent.add((GuiControl)r);
                r.add((GuiControl)new GuiTextfield("m00").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m01").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m02").setNumbersIncludingNegativeOnly());
                r = new GuiParent();
                parent.add((GuiControl)r);
                r.add((GuiControl)new GuiTextfield("m10").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m11").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m12").setNumbersIncludingNegativeOnly());
                r = new GuiParent();
                parent.add((GuiControl)r);
                r.add((GuiControl)new GuiTextfield("m20").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m21").setNumbersIncludingNegativeOnly());
                r.add((GuiControl)new GuiTextfield("m22").setNumbersIncludingNegativeOnly());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(IntMatrix3c value, GuiParent parent) {
                parent.get("m00", GuiTextfield.class).setText("" + value.m00());
                parent.get("m01", GuiTextfield.class).setText("" + value.m01());
                parent.get("m02", GuiTextfield.class).setText("" + value.m02());
                parent.get("m10", GuiTextfield.class).setText("" + value.m10());
                parent.get("m11", GuiTextfield.class).setText("" + value.m11());
                parent.get("m12", GuiTextfield.class).setText("" + value.m12());
                parent.get("m20", GuiTextfield.class).setText("" + value.m20());
                parent.get("m21", GuiTextfield.class).setText("" + value.m21());
                parent.get("m22", GuiTextfield.class).setText("" + value.m22());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected IntMatrix3c saveValue(GuiParent parent, ConfigKey key) {
                return new IntMatrix3(parent.get("m00", GuiTextfield.class).parseInteger(), parent.get("m01", GuiTextfield.class).parseInteger(), parent.get("m02", GuiTextfield.class).parseInteger(), parent.get("m10", GuiTextfield.class).parseInteger(), parent.get("m11", GuiTextfield.class).parseInteger(), parent.get("m12", GuiTextfield.class).parseInteger(), parent.get("m20", GuiTextfield.class).parseInteger(), parent.get("m21", GuiTextfield.class).parseInteger(), parent.get("m22", GuiTextfield.class).parseInteger());
            }

            @Override
            public IntMatrix3c set(ConfigKey key, IntMatrix3c value) {
                return value;
            }
        }, IntMatrix3c.class, IntMatrix3.class);
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeArray());
        ConfigTypeConveration.registerSpecialType(Enum.class::isAssignableFrom, new SimpleConfigTypeConveration<Enum>(){

            private static Class getEnumClass(Class clazz) {
                if (clazz.isEnum()) {
                    return clazz;
                }
                return clazz.getSuperclass();
            }

            @Override
            public Enum readElement(ConfigKey key, Enum defaultValue, Side side, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, ConfigKey key, Side side) {
                return new JsonPrimitive(value.name());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, ConfigKey key) {
                parent.add((GuiControl)new GuiComboBox<Object>("data", new TextMapBuilder<Object>().addComponent(7.getEnumClass(key.field().getType()).getEnumConstants(), x -> class_2561.method_43470((String)((Enum)x).name()))));
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(Enum value, GuiParent parent) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.ordinal());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected Enum saveValue(GuiParent parent, ConfigKey key) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                return (Enum)box.selected();
            }

            @Override
            public Enum set(ConfigKey key, Enum value) {
                return value;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> List.class.isAssignableFrom((Class<?>)x) || x == ArrayList.class, new ConfigTypeList());
        final CreativeIngredientBlock temp = new CreativeIngredientBlock(class_2246.field_10566);
        ConfigTypeConveration.registerSpecialType(CreativeIngredient.class::isAssignableFrom, new ConfigTypeConveration<CreativeIngredient>(){

            @Override
            public CreativeIngredient readElement(class_7225.class_7874 provider, CreativeIngredient defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return CreativeIngredient.load(provider, class_2522.method_10718((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        CreativeCore.LOGGER.error((Object)e);
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(class_7225.class_7874 provider, CreativeIngredient value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
                return new JsonPrimitive(value.save(provider).toString());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                parent.add(new GuiInfoStackButton("data", temp).setExpandableX());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(CreativeIngredient value, CreativeIngredient defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                button.set(value);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected CreativeIngredient saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                return button.get();
            }

            @Override
            public CreativeIngredient set(ConfigKey key, CreativeIngredient value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(CreativeIngredient.class, () -> new CreativeIngredientBlock(class_2246.field_10566));
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(class_7225.class_7874 provider, T defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
            return this.readElement(key, defaultValue, side, element);
        }

        public abstract T readElement(ConfigKey var1, T var2, Side var3, JsonElement var4);

        @Override
        public JsonElement writeElement(class_7225.class_7874 provider, T value, boolean ignoreRestart, boolean saveDefault, Side side, ConfigKey key) {
            return this.writeElement(value, key, side);
        }

        public abstract JsonElement writeElement(T var1, ConfigKey var2, Side var3);

        @Override
        @Environment(value=EnvType.CLIENT)
        public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            this.createControls(parent, key);
        }

        @Environment(value=EnvType.CLIENT)
        public abstract void createControls(GuiParent var1, ConfigKey var2);

        @Override
        @Environment(value=EnvType.CLIENT)
        public void loadValue(T value, T defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            this.loadValue(value, parent);
        }

        @Environment(value=EnvType.CLIENT)
        public abstract void loadValue(T var1, GuiParent var2);

        @Override
        @Environment(value=EnvType.CLIENT)
        protected T saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
            return this.saveValue(parent, key);
        }

        @Environment(value=EnvType.CLIENT)
        protected abstract T saveValue(GuiParent var1, ConfigKey var2);
    }
}

