/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.Pair;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.TextWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DualTextInputScreen
extends class_437 {
    @NotNull
    protected Consumer<Pair<String, String>> callback;
    protected ExtendedEditBox input_one;
    protected ExtendedEditBox input_two;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ConsumingSupplier<DualTextInputScreen, Boolean> textValidator = null;
    protected Tooltip textValidatorFeedbackTooltip = null;
    @NotNull
    protected class_5250 firstInputLabel;
    @NotNull
    protected class_5250 secondInputLabel;
    @Nullable
    protected CharacterFilter filter;
    @Nullable
    protected String initialValueOne = null;
    @Nullable
    protected String initialValueTwo = null;
    protected boolean allowPlaceholders = true;

    @NotNull
    public static DualTextInputScreen build(@NotNull class_2561 title, @NotNull class_2561 firstInputLabel, @NotNull class_2561 secondInputLabel, @Nullable CharacterFilter filter, @NotNull Consumer<Pair<String, String>> callback) {
        return new DualTextInputScreen(title, firstInputLabel, secondInputLabel, filter, callback);
    }

    public DualTextInputScreen(@NotNull class_2561 title, @NotNull class_2561 firstInputLabel, @NotNull class_2561 secondInputLabel, @Nullable CharacterFilter filter, @NotNull Consumer<Pair<String, String>> callback) {
        super(title);
        class_5250 l;
        this.callback = callback;
        this.firstInputLabel = firstInputLabel instanceof class_5250 ? (l = (class_5250)firstInputLabel) : class_2561.method_43473();
        this.secondInputLabel = secondInputLabel instanceof class_5250 ? (l = (class_5250)secondInputLabel) : class_2561.method_43473();
        this.filter = filter;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int editorButtonWidth = 100;
        int inputWidth = this.allowPlaceholders ? 150 : 250;
        int inputWidthHalf = inputWidth / 2;
        int inputX = centerX - inputWidthHalf - (this.allowPlaceholders ? editorButtonWidth / 2 : 0);
        ((TextWidget)this.method_37063((class_364)new TextWidget(0, centerY - 43, this.field_22789, 20, this.field_22793, (class_2561)this.firstInputLabel).centerWidget(this).setTextAlignment(TextWidget.TextAlignment.CENTER).setBaseColor(UIBase.getUIColorTheme().generic_text_base_color))).setShadowEnabled(false);
        String oldValueOne = "";
        if (this.input_one != null) {
            oldValueOne = this.input_one.method_1882();
        } else if (this.initialValueOne != null) {
            oldValueOne = this.initialValueOne;
        }
        this.input_one = new ExtendedEditBox(this.field_22793, inputX, centerY - 30, inputWidth, 20, (class_2561)class_2561.method_43473());
        this.input_one.method_1880(10000000);
        this.input_one.setCharacterFilter(this.filter);
        this.input_one.method_1852(oldValueOne);
        UIBase.applyDefaultWidgetSkinTo(this.input_one);
        this.method_37063((class_364)this.input_one);
        this.method_25395((class_364)this.input_one);
        if (this.allowPlaceholders) {
            UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.method_37063((class_364)new ExtendedButton(this.input_one.method_46426() + this.input_one.method_25368() + 5, this.input_one.method_46427(), editorButtonWidth, 20, (class_2561)class_2561.method_43471((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                TextEditorScreen s = new TextEditorScreen(this.filter != null ? this.filter.convertToLegacyFilter() : null, callback -> {
                    if (callback != null) {
                        this.setFirstText((String)callback);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                s.setText(this.getFirstText());
                class_310.method_1551().method_1507((class_437)s);
            })));
        }
        ((TextWidget)this.method_37063((class_364)new TextWidget(0, centerY + 27, this.field_22789, 20, this.field_22793, (class_2561)this.secondInputLabel).centerWidget(this).setTextAlignment(TextWidget.TextAlignment.CENTER).setBaseColor(UIBase.getUIColorTheme().generic_text_base_color))).setShadowEnabled(false);
        String oldValueTwo = "";
        if (this.input_two != null) {
            oldValueTwo = this.input_two.method_1882();
        } else if (this.initialValueTwo != null) {
            oldValueTwo = this.initialValueTwo;
        }
        this.input_two = new ExtendedEditBox(class_310.method_1551().field_1772, inputX, centerY + 40, inputWidth, 20, (class_2561)class_2561.method_43473());
        this.input_two.method_1880(10000000);
        this.input_two.setCharacterFilter(this.filter);
        this.input_two.method_1852(oldValueTwo);
        UIBase.applyDefaultWidgetSkinTo(this.input_two);
        this.method_37063((class_364)this.input_two);
        if (this.allowPlaceholders) {
            UIBase.applyDefaultWidgetSkinTo((ExtendedButton)this.method_37063((class_364)new ExtendedButton(this.input_two.method_46426() + this.input_two.method_25368() + 5, this.input_two.method_46427(), editorButtonWidth, 20, (class_2561)class_2561.method_43471((String)"fancymenu.ui.screens.string_builder_screen.edit_in_editor"), button -> {
                TextEditorScreen s = new TextEditorScreen(this.filter != null ? this.filter.convertToLegacyFilter() : null, callback -> {
                    if (callback != null) {
                        this.setSecondText((String)callback);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                s.setText(this.getSecondText());
                class_310.method_1551().method_1507((class_437)s);
            })));
        }
        this.cancelButton = new ExtendedButton(this.field_22789 / 2 - 5 - 100, centerY + 90, 100, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.cancel"), button -> this.method_25419());
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.method_37063((class_364)this.cancelButton);
        this.doneButton = new ExtendedButton(this.field_22789 / 2 + 5, centerY + 90, 100, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.done"), button -> {
            if (this.isTextValid()) {
                this.onDone();
            }
        }).setIsActiveSupplier(consumes -> this.isTextValid()).setTooltipSupplier(consumes -> {
            if (this.textValidatorFeedbackTooltip != null) {
                this.textValidatorFeedbackTooltip.setDefaultStyle();
            }
            return this.textValidatorFeedbackTooltip;
        });
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.method_37063((class_364)this.doneButton);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.enableBlend();
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 t = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        int titleWidth = class_310.method_1551().field_1772.method_27525((class_5348)t);
        graphics.method_51439(this.field_22793, (class_2561)t, this.field_22789 / 2 - titleWidth / 2, 30, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    public boolean method_25404(int button, int p_96553_, int p_96554_) {
        if (button == 257 && this.isTextValid()) {
            this.onDone();
            return true;
        }
        return super.method_25404(button, p_96553_, p_96554_);
    }

    protected void onDone() {
        this.callback.accept(Pair.of(this.getFirstText(), this.getSecondText()));
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public DualTextInputScreen setFirstText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (this.input_one != null) {
            this.input_one.method_1852(text);
        } else {
            this.initialValueOne = text;
        }
        return this;
    }

    public DualTextInputScreen setSecondText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (this.input_two != null) {
            this.input_two.method_1852(text);
        } else {
            this.initialValueTwo = text;
        }
        return this;
    }

    @NotNull
    public String getFirstText() {
        if (this.input_one != null) {
            return this.input_one.method_1882();
        }
        if (this.initialValueOne != null) {
            return this.initialValueOne;
        }
        return "";
    }

    @NotNull
    public String getSecondText() {
        if (this.input_two != null) {
            return this.input_two.method_1882();
        }
        if (this.initialValueTwo != null) {
            return this.initialValueTwo;
        }
        return "";
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public DualTextInputScreen setTextValidator(@Nullable ConsumingSupplier<DualTextInputScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public DualTextInputScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }

    public boolean isAllowPlaceholders() {
        return this.allowPlaceholders;
    }

    public DualTextInputScreen setAllowPlaceholders(boolean allowPlaceholders) {
        this.allowPlaceholders = allowPlaceholders;
        return this;
    }
}

