/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_8030;
import net.minecraft.class_9801;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DrawableColor MISSING_TEXTURE_COLOR_MAGENTA = DrawableColor.of(Color.MAGENTA);
    public static final DrawableColor MISSING_TEXTURE_COLOR_BLACK = DrawableColor.BLACK;
    public static final class_2960 FULLY_TRANSPARENT_TEXTURE = class_2960.method_60655((String)"fancymenu", (String)"textures/fully_transparent.png");
    private static final List<DeferredScreenRenderingTask> DEFERRED_SCREEN_RENDERING_TASKS = new ArrayList<DeferredScreenRenderingTask>();
    private static boolean lockDepthTest = false;
    private static boolean blurBlocked = false;
    private static boolean tooltipRenderingBlocked = false;
    private static int overrideBackgroundBlurRadius = -1000;

    public static void renderMissing(@NotNull class_332 graphics, int x, int y, int width, int height) {
        int partW = width / 2;
        int partH = height / 2;
        graphics.method_25294(x, y, x + partW, y + partH, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
        graphics.method_25294(x + partW, y, x + width, y + partH, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x, y + partH, x + partW, y + height, MISSING_TEXTURE_COLOR_BLACK.getColorInt());
        graphics.method_25294(x + partW, y + partH, x + width, y + height, MISSING_TEXTURE_COLOR_MAGENTA.getColorInt());
    }

    public static void setOverrideBackgroundBlurRadius(int radius) {
        overrideBackgroundBlurRadius = radius;
    }

    public static void resetOverrideBackgroundBlurRadius() {
        overrideBackgroundBlurRadius = -1000;
    }

    public static boolean shouldOverrideBackgroundBlurRadius() {
        return overrideBackgroundBlurRadius != -1000;
    }

    public static int getOverrideBackgroundBlurRadius() {
        return overrideBackgroundBlurRadius;
    }

    public static void setDepthTestLocked(boolean locked) {
        lockDepthTest = locked;
    }

    public static boolean isDepthTestLocked() {
        return lockDepthTest;
    }

    public static void setMenuBlurringBlocked(boolean blocked) {
        blurBlocked = blocked;
    }

    public static boolean isMenuBlurringBlocked() {
        return blurBlocked;
    }

    public static void setTooltipRenderingBlocked(boolean blocked) {
        tooltipRenderingBlocked = blocked;
    }

    public static boolean isTooltipRenderingBlocked() {
        return tooltipRenderingBlocked;
    }

    public static void addDeferredScreenRenderingTask(@NotNull DeferredScreenRenderingTask task) {
        DEFERRED_SCREEN_RENDERING_TASKS.add(task);
    }

    @NotNull
    public static List<DeferredScreenRenderingTask> getDeferredScreenRenderingTasks() {
        return new ArrayList<DeferredScreenRenderingTask>(DEFERRED_SCREEN_RENDERING_TASKS);
    }

    public static void executeAndClearDeferredScreenRenderingTasks(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        List<DeferredScreenRenderingTask> tasks = RenderingUtils.getDeferredScreenRenderingTasks();
        DEFERRED_SCREEN_RENDERING_TASKS.clear();
        tasks.forEach(task -> task.render(graphics, mouseX, mouseY, partial));
    }

    public static void blitMirrored(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, -1);
    }

    public static void blitMirrored(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int textureWidth, int textureHeight, int colorTint) {
        RenderingUtils.blitMirroredScaled(graphics, atlasLocation, x, y, u, v, spriteWidth, spriteHeight, spriteWidth, spriteHeight, textureWidth, textureHeight, colorTint);
    }

    public static void blitMirroredScaled(@NotNull class_332 graphics, class_2960 atlasLocation, int x, int y, int u, int v, int spriteWidth, int spriteHeight, int renderWidth, int renderHeight, int textureWidth, int textureHeight, int color) {
        float minU = (float)u / (float)textureWidth;
        float maxU = (float)(u + spriteWidth) / (float)textureWidth;
        float minV = (float)v / (float)textureHeight;
        float maxV = (float)(v + spriteHeight) / (float)textureHeight;
        RenderSystem.setShaderTexture((int)0, (class_2960)atlasLocation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_287 consumer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        consumer.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(maxU, minV).method_39415(color);
        consumer.method_22918(matrix4f, (float)x, (float)(y + renderHeight), 0.0f).method_22913(maxU, maxV).method_39415(color);
        consumer.method_22918(matrix4f, (float)(x + renderWidth), (float)(y + renderHeight), 0.0f).method_22913(minU, maxV).method_39415(color);
        consumer.method_22918(matrix4f, (float)(x + renderWidth), (float)y, 0.0f).method_22913(minU, minV).method_39415(color);
        class_286.method_43433((class_9801)consumer.method_60800());
        RenderSystem.disableBlend();
    }

    public static void blitRepeat(@NotNull class_332 graphics, @NotNull class_2960 location, int x, int y, int areaRenderWidth, int areaRenderHeight, int texWidth, int texHeight) {
        graphics.method_25290(location, x, y, 0.0f, 0.0f, areaRenderWidth, areaRenderHeight, texWidth, texHeight);
    }

    public static void blitNineSlicedTexture(class_332 graphics, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderTop, int borderRight, int borderBottom, int borderLeft) {
        int pieceHeight;
        int j;
        int pieceWidth;
        int i;
        float scale;
        if (borderLeft + borderRight >= textureWidth) {
            scale = (float)(textureWidth - 2) / (float)(borderLeft + borderRight);
            borderLeft = (int)((float)borderLeft * scale);
            borderRight = (int)((float)borderRight * scale);
        }
        if (borderTop + borderBottom >= textureHeight) {
            scale = (float)(textureHeight - 2) / (float)(borderTop + borderBottom);
            borderTop = (int)((float)borderTop * scale);
            borderBottom = (int)((float)borderBottom * scale);
        }
        graphics.method_25290(texture, x, y, 0.0f, 0.0f, borderLeft, borderTop, textureWidth, textureHeight);
        graphics.method_25290(texture, x + width - borderRight, y, (float)(textureWidth - borderRight), 0.0f, borderRight, borderTop, textureWidth, textureHeight);
        graphics.method_25290(texture, x, y + height - borderBottom, 0.0f, (float)(textureHeight - borderBottom), borderLeft, borderBottom, textureWidth, textureHeight);
        graphics.method_25290(texture, x + width - borderRight, y + height - borderBottom, (float)(textureWidth - borderRight), (float)(textureHeight - borderBottom), borderRight, borderBottom, textureWidth, textureHeight);
        int centerWidth = textureWidth - borderLeft - borderRight;
        int centerHeight = textureHeight - borderTop - borderBottom;
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25290(texture, x + i, y, (float)borderLeft, 0.0f, pieceWidth, borderTop, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            graphics.method_25290(texture, x + i, y + height - borderBottom, (float)borderLeft, (float)(textureHeight - borderBottom), pieceWidth, borderBottom, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25290(texture, x, y + j, 0.0f, (float)borderTop, borderLeft, pieceHeight, textureWidth, textureHeight);
        }
        for (j = borderTop; j < height - borderBottom; j += centerHeight) {
            pieceHeight = Math.min(centerHeight, height - borderBottom - j);
            graphics.method_25290(texture, x + width - borderRight, y + j, (float)(textureWidth - borderRight), (float)borderTop, borderRight, pieceHeight, textureWidth, textureHeight);
        }
        for (i = borderLeft; i < width - borderRight; i += centerWidth) {
            pieceWidth = Math.min(centerWidth, width - borderRight - i);
            for (int j2 = borderTop; j2 < height - borderBottom; j2 += centerHeight) {
                int pieceHeight2 = Math.min(centerHeight, height - borderBottom - j2);
                graphics.method_25290(texture, x + i, y + j2, (float)borderLeft, (float)borderTop, pieceWidth, pieceHeight2, textureWidth, textureHeight);
            }
        }
    }

    public static float getPartialTick() {
        return class_310.method_1551().method_60646().method_60637(false);
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        class_1041 m = class_310.method_1551().method_22683();
        m.method_15997((double)m.method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), ((Boolean)class_310.method_1551().field_1690.method_42437().method_41753()).booleanValue()));
    }

    public static void resetShaderColor(class_332 graphics) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void setShaderColor(class_332 graphics, DrawableColor color) {
        Color c = color.getColor();
        float a = Math.min(1.0f, Math.max(0.0f, (float)c.getAlpha() / 255.0f));
        RenderingUtils.setShaderColor(graphics, color, a);
    }

    public static void setShaderColor(class_332 graphics, DrawableColor color, float alpha) {
        Color c = color.getColor();
        float r = Math.min(1.0f, Math.max(0.0f, (float)c.getRed() / 255.0f));
        float g = Math.min(1.0f, Math.max(0.0f, (float)c.getGreen() / 255.0f));
        float b = Math.min(1.0f, Math.max(0.0f, (float)c.getBlue() / 255.0f));
        graphics.method_51422(r, g, b, alpha);
    }

    public static void setShaderColor(class_332 graphics, int color, float alpha) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        graphics.method_51422(red, green, blue, alpha);
    }

    public static void setShaderColor(class_332 graphics, int color) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        graphics.method_51422(red, green, blue, alpha);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(graphics, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull class_332 graphics, float minX, float minY, float maxX, float maxY, float z, int color) {
        float i;
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        class_4588 vertexConsumer = graphics.method_51450().getBuffer(class_1921.method_51784());
        vertexConsumer.method_22918(matrix4f, minX, minY, z).method_39415(color);
        vertexConsumer.method_22918(matrix4f, minX, maxY, z).method_39415(color);
        vertexConsumer.method_22918(matrix4f, maxX, maxY, z).method_39415(color);
        vertexConsumer.method_22918(matrix4f, maxX, minY, z).method_39415(color);
        graphics.method_51452();
    }

    public static void blitF(@NotNull class_332 graphics, class_2960 location, float x, float y, float f3, float f4, float width, float height, float width2, float height2, int color) {
        float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        graphics.method_51422(red, green, blue, alpha);
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void blitF(@NotNull class_332 graphics, class_2960 location, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(graphics, location, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(class_332 $$0, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, location, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(class_332 graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit(graphics, location, $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(class_332 graphics, class_2960 location, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShaderTexture((int)0, (class_2960)location);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f $$10 = graphics.method_51448().method_23760().method_23761();
        class_287 $$11 = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        $$11.method_22918($$10, $$1, $$3, $$5).method_22913($$6, $$8);
        $$11.method_22918($$10, $$1, $$4, $$5).method_22913($$6, $$9);
        $$11.method_22918($$10, $$2, $$4, $$5).method_22913($$7, $$9);
        $$11.method_22918($$10, $$2, $$3, $$5).method_22913($$7, $$8);
        class_286.method_43433((class_9801)Objects.requireNonNull($$11.method_60794()));
        graphics.method_51452();
    }

    public static void enableScissor(@NotNull class_332 graphics, int minX, int minY, int maxX, int maxY) {
        class_8030 r = new class_8030(minX, minY, maxX - minX, maxY - minY);
        r = RenderingUtils.transformAxisAligned(r, graphics.method_51448().method_23760().method_23761());
        graphics.method_44379(r.method_49620(), r.method_49618(), r.method_49621(), r.method_49619());
    }

    public static void disableScissor(@NotNull class_332 graphics) {
        graphics.method_44380();
    }

    @NotNull
    public static class_8030 transformAxisAligned(@NotNull class_8030 toTransform, @NotNull Matrix4f pose) {
        if (RenderingUtils.isMatrixIdentity(pose)) {
            return toTransform;
        }
        Vector3f vector3f = pose.transformPosition((float)toTransform.method_49620(), (float)toTransform.method_49618(), 0.0f, new Vector3f());
        Vector3f vector3f2 = pose.transformPosition((float)toTransform.method_49621(), (float)toTransform.method_49619(), 0.0f, new Vector3f());
        return new class_8030(class_3532.method_15375((float)vector3f.x), class_3532.method_15375((float)vector3f.y), class_3532.method_15375((float)(vector3f2.x - vector3f.x)), class_3532.method_15375((float)(vector3f2.y - vector3f.y)));
    }

    public static boolean isMatrixIdentity(Matrix4f matrix) {
        return (matrix.properties() & 4) != 0;
    }

    @FunctionalInterface
    public static interface DeferredScreenRenderingTask {
        public void render(@NotNull class_332 var1, int var2, int var3, float var4);
    }
}

