/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.mcef;

import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserLoadEventListenerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BrowserLoadEventListenerManager INSTANCE = new BrowserLoadEventListenerManager();
    private final Map<String, List<BrowserLoadListener>> browserMap = new ConcurrentHashMap<String, List<BrowserLoadListener>>();
    private final CefLoadHandlerAdapter globalHandler = new CefLoadHandlerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoadEnd(CefBrowser cefBrowser, CefFrame frame, int httpStatusCode) {
            if (!frame.isMain()) {
                return;
            }
            String browserId = BrowserLoadEventListenerManager.this.getIdByCefBrowser(cefBrowser);
            if (browserId == null) {
                return;
            }
            List<BrowserLoadListener> loadListeners = BrowserLoadEventListenerManager.this.browserMap.get(browserId);
            if (loadListeners != null) {
                boolean success = httpStatusCode >= 200 && httpStatusCode < 300 || frame.getURL() != null && frame.getURL().startsWith("file:") && httpStatusCode == 0;
                List<BrowserLoadListener> list = loadListeners;
                synchronized (list) {
                    loadListeners.removeIf(loadListener -> BrowserLoadEventListenerManager.this.processListener((BrowserLoadListener)loadListener, success));
                }
            } else {
                LOGGER.warn("[FANCYMENU] onLoadEnd: No load listeners found for browser ID: {}", (Object)browserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoadError(CefBrowser cefBrowser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
            if (!frame.isMain()) {
                return;
            }
            String browserId = BrowserLoadEventListenerManager.this.getIdByCefBrowser(cefBrowser);
            if (browserId == null) {
                return;
            }
            List<BrowserLoadListener> loadListeners = BrowserLoadEventListenerManager.this.browserMap.get(browserId);
            if (loadListeners != null) {
                List<BrowserLoadListener> list = loadListeners;
                synchronized (list) {
                    loadListeners.removeIf(loadListener -> {
                        LOGGER.error("[FANCYMENU] Browser [ID:{}] load error: {}, {}, URL: {}", (Object)browserId, (Object)errorCode, (Object)errorText, (Object)failedUrl);
                        return BrowserLoadEventListenerManager.this.processListener((BrowserLoadListener)loadListener, false);
                    });
                }
            } else {
                LOGGER.warn("[FANCYMENU] onLoadError: No load listeners found for browser ID: {}", (Object)browserId);
            }
        }
    };

    private BrowserLoadEventListenerManager() {
    }

    public static BrowserLoadEventListenerManager getInstance() {
        return INSTANCE;
    }

    public CefLoadHandler getGlobalHandler() {
        return this.globalHandler;
    }

    public void registerListenerForBrowser(@NotNull WrappedMCEFBrowser browser, @NotNull Consumer<Boolean> onLoadListener) {
        this.registerListenerForBrowserInternal(browser, onLoadListener, false);
    }

    public void registerPersistentListenerForBrowser(@NotNull WrappedMCEFBrowser browser, @NotNull Consumer<Boolean> onLoadListener) {
        this.registerListenerForBrowserInternal(browser, onLoadListener, true);
    }

    public void unregisterAllListenersForBrowser(String browserId) {
        this.browserMap.remove(browserId);
    }

    @Nullable
    public String getIdByCefBrowser(@NotNull CefBrowser cefBrowser) {
        for (Map.Entry<String, List<BrowserLoadListener>> m : this.browserMap.entrySet()) {
            BrowserLoadListener listener1;
            if (m.getValue().isEmpty() || !Objects.equals((listener1 = m.getValue().get(0)).getBrowser().getBrowser(), cefBrowser)) continue;
            return m.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerForBrowserInternal(@NotNull WrappedMCEFBrowser browser, @NotNull Consumer<Boolean> onLoadListener, boolean persistent) {
        List<BrowserLoadListener> listeners;
        this.browserMap.computeIfAbsent(browser.getIdentifier(), id -> new ArrayList());
        List<BrowserLoadListener> list = listeners = this.browserMap.get(browser.getIdentifier());
        synchronized (list) {
            listeners.add(new BrowserLoadListener(browser, onLoadListener, persistent));
        }
    }

    private boolean processListener(@NotNull BrowserLoadListener loadListener, boolean success) {
        if (!loadListener.isHandled()) {
            loadListener.setHandled(true);
            loadListener.getOnLoadCompletedTask().accept(success);
        }
        if (loadListener.isPersistent()) {
            loadListener.setHandled(false);
            return false;
        }
        return true;
    }

    private static class BrowserLoadListener {
        private final Consumer<Boolean> onLoadCompleted;
        private final WrappedMCEFBrowser browser;
        private final boolean persistent;
        private volatile boolean handled = false;

        public BrowserLoadListener(WrappedMCEFBrowser browser, Consumer<Boolean> onLoadCompleted, boolean persistent) {
            this.onLoadCompleted = onLoadCompleted;
            this.browser = browser;
            this.persistent = persistent;
        }

        public Consumer<Boolean> getOnLoadCompletedTask() {
            return this.onLoadCompleted;
        }

        public WrappedMCEFBrowser getBrowser() {
            return this.browser;
        }

        public boolean isHandled() {
            return this.handled;
        }

        public void setHandled(boolean handled) {
            this.handled = handled;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

