/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class IsGuiScaleRequirement
extends LoadingRequirement {
    public IsGuiScaleRequirement() {
        super("fancymenu_loading_requirement_is_gui_scale");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        List<String> l;
        if (value != null && !(l = this.parseValues(value)).isEmpty()) {
            for (String s : l) {
                if (IsGuiScaleRequirement.checkForGuiScale(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<String> parseValues(String value) {
        ArrayList<String> l1 = new ArrayList<String>();
        if (value.contains(",")) {
            l1.addAll(Arrays.asList(value.replace(" ", "").split(",")));
        } else if (value.length() > 0) {
            l1.add(value.replace(" ", ""));
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String s : l1) {
            String v;
            if (MathUtils.isDouble((String)s)) {
                l.add("double:" + s);
                continue;
            }
            if (s.startsWith(">")) {
                v = s.split(">", 2)[1];
                if (!MathUtils.isDouble((String)v)) continue;
                l.add("biggerthan:" + v);
                continue;
            }
            if (!s.startsWith("<") || !MathUtils.isDouble((String)(v = s.split("<", 2)[1]))) continue;
            l.add("smallerthan:" + v);
        }
        return l;
    }

    protected static boolean checkForGuiScale(String condition) {
        double windowScale = class_310.method_1551().method_22683().method_4495();
        if (condition.startsWith("double:")) {
            String value = condition.replace("double:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale == valueScale;
        }
        if (condition.startsWith("biggerthan:")) {
            String value = condition.replace("biggerthan:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale > valueScale;
        }
        if (condition.startsWith("smallerthan:")) {
            String value = condition.replace("smallerthan:", "");
            double valueScale = Double.parseDouble(value);
            return windowScale < valueScale;
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.guiscale", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.guiscale.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662((String)"fancymenu.requirements.guiscale.value_name", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return ">2.0";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

