/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.layer.ElementFactory;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutBase;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.events.screen.CloseScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenEvent;
import de.keksuccino.fancymenu.events.screen.OpenScreenPostInitEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.events.screen.ScreenTickEvent;
import de.keksuccino.fancymenu.events.widget.RenderTabNavigationBarHeaderBackgroundEvent;
import de.keksuccino.fancymenu.events.widget.RenderedGuiListHeaderFooterEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.ScreenTitleUtils;
import de.keksuccino.fancymenu.util.ScreenUtils;
import de.keksuccino.fancymenu.util.TaskExecutor;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_8089;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenCustomizationLayer
implements ElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 MENU_BACKGROUND = class_2960.method_60654((String)"textures/gui/menu_background.png");
    public static final class_2960 INWORLD_MENU_BACKGROUND = class_2960.method_60654((String)"textures/gui/inworld_menu_background.png");
    protected String screenIdentifier;
    public LayoutBase layoutBase = new LayoutBase();
    @NotNull
    public List<AbstractElement> allElements = new ArrayList<AbstractElement>();
    public Layout.OrderedElementCollection normalElements = new Layout.OrderedElementCollection();
    public List<VanillaWidgetElement> vanillaWidgetElements = new ArrayList<VanillaWidgetElement>();
    public Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    public List<Layout> activeLayouts = new ArrayList<Layout>();
    public List<String> delayAppearanceFirstTime = new ArrayList<String>();
    public List<ThreadCaller> delayThreads = new ArrayList<ThreadCaller>();
    public boolean backgroundDrawable;
    public boolean forceDisableCustomMenuTitle = false;
    public float backgroundOpacity = 1.0f;
    public Map<LoadingRequirementContainer, Boolean> cachedLayoutWideLoadingRequirements = new HashMap<LoadingRequirementContainer, Boolean>();
    @NotNull
    public List<WidgetMeta> cachedScreenWidgetMetas = new ArrayList<WidgetMeta>();
    @Nullable
    public class_8089 cachedTabNavigationBar = null;
    public boolean loadEarly = false;
    public static Map<Class<?>, class_2561> cachedOriginalMenuTitles = new HashMap();

    public ScreenCustomizationLayer(@NotNull String screenIdentifier) {
        Objects.requireNonNull(screenIdentifier);
        this.screenIdentifier = screenIdentifier;
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @NotNull
    public String getScreenIdentifier() {
        return this.screenIdentifier;
    }

    public void resetLayer() {
        this.delayAppearanceFirstTime.clear();
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.reset(true);
        }
    }

    @EventListener
    public void onModReload(ModReloadEvent e) {
        RandomLayoutContainer.CACHED_PICKS.clear();
        this.resetLayer();
    }

    @EventListener
    public void onOpenScreen(OpenScreenEvent e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!cachedOriginalMenuTitles.containsKey(e.getScreen().getClass())) {
            cachedOriginalMenuTitles.put(e.getScreen().getClass(), e.getScreen().method_25440());
        }
    }

    @EventListener
    public void onOpenScreenPostInit(OpenScreenPostInitEvent e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(AbstractElement::_onOpenScreen);
        this.layoutBase.menuBackgrounds.forEach(MenuBackground::onOpenScreen);
        this.layoutBase.openScreenExecutableBlocks.forEach(AbstractExecutableBlock::execute);
    }

    @EventListener
    public void onCloseScreen(CloseScreenEvent e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(element -> {
            element.onCloseScreen(e.getClosedScreen(), e.getNewScreen());
            element.onCloseScreen();
            element.onDestroyElement();
        });
        this.layoutBase.menuBackgrounds.forEach(menuBackground -> menuBackground.onCloseScreen(e.getClosedScreen(), e.getNewScreen()));
        this.layoutBase.menuBackgrounds.forEach(MenuBackground::onCloseScreen);
        if (this.layoutBase.closeAudio != null) {
            ResourceSupplier<IAudio> closeAudioSupplier = this.layoutBase.closeAudio;
            IAudio audio = closeAudioSupplier.get();
            if (audio != null && audio.isReady()) {
                audio.stop();
                audio.play();
            } else {
                AtomicBoolean played = new AtomicBoolean(false);
                TaskExecutor.scheduleAtFixedRate(future -> {
                    if (played.get()) {
                        return;
                    }
                    IAudio audio2 = (IAudio)closeAudioSupplier.get();
                    if (audio2 != null && audio2.isReady()) {
                        audio2.stop();
                        audio2.play();
                        played.set(true);
                        future.cancel(true);
                    }
                }, 100L, 100L, TimeUnit.MILLISECONDS, true);
            }
        }
        this.layoutBase.closeScreenExecutableBlocks.forEach(AbstractExecutableBlock::execute);
    }

    @EventListener
    public void onInitOrResizeScreenPre(InitOrResizeScreenEvent.Pre e) {
        this.cachedTabNavigationBar = null;
        for (ThreadCaller t : this.delayThreads) {
            t.running.set(false);
        }
        this.delayThreads.clear();
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.allElements.forEach(element -> {
            if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
                element.onBeforeResizeScreen();
            }
            element.onDestroyElement();
        });
        if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
            this.layoutBase.menuBackgrounds.forEach(MenuBackground::onBeforeResizeScreen);
        }
        ArrayList<MenuBackground> oldMenuBackgrounds = new ArrayList<MenuBackground>(this.layoutBase.menuBackgrounds);
        List<Layout> rawLayouts = LayoutHandler.getEnabledLayoutsForScreenIdentifier(this.getScreenIdentifier(), true);
        ArrayList<Layout> normalLayouts = new ArrayList<Layout>();
        this.activeLayouts.clear();
        this.layoutBase = new LayoutBase();
        this.normalElements = new Layout.OrderedElementCollection();
        this.vanillaWidgetElements.clear();
        this.allElements.clear();
        this.backgroundOpacity = 1.0f;
        this.backgroundDrawable = false;
        this.cachedLayoutWideLoadingRequirements.clear();
        for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
            randomLayoutContainer.clearLayouts();
        }
        for (Layout layout : rawLayouts) {
            LoadingRequirementContainer loadingRequirementContainer = layout.layoutWideLoadingRequirementContainer;
            this.cachedLayoutWideLoadingRequirements.put(loadingRequirementContainer, loadingRequirementContainer.requirementsMet());
            if (!loadingRequirementContainer.requirementsMet()) continue;
            if (layout.randomMode) {
                RandomLayoutContainer randomContainer;
                String group = layout.randomGroup;
                if (!this.randomLayoutGroups.containsKey(group)) {
                    this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                }
                if ((randomContainer = this.randomLayoutGroups.get(group)) == null) continue;
                randomContainer.addLayout(layout);
                continue;
            }
            normalLayouts.add(layout);
        }
        ArrayList<String> trashLayoutGroups = new ArrayList<String>();
        for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
            if (!entry.getValue().getLayouts().isEmpty()) continue;
            trashLayoutGroups.add(entry.getKey());
        }
        for (String string : trashLayoutGroups) {
            this.randomLayoutGroups.remove(string);
        }
        this.activeLayouts = new ArrayList<Layout>(normalLayouts);
        this.randomLayoutGroups.values().forEach(container -> this.activeLayouts.add(container.getRandomLayout()));
        this.activeLayouts.sort(Comparator.comparingInt(l -> l.layoutIndex));
        this.layoutBase = LayoutBase.stackLayoutBases(this.activeLayouts.toArray(new LayoutBase[0]));
        class_1041 class_10412 = class_310.method_1551().method_22683();
        if (this.layoutBase.forcedScale != 0.0f) {
            float f = this.layoutBase.forcedScale;
            if (f <= 0.0f) {
                f = 1.0f;
            }
            class_10412.method_15997((double)f);
            e.getScreen().field_22789 = class_10412.method_4486();
            e.getScreen().field_22790 = class_10412.method_4502();
        }
        if (this.layoutBase.autoScalingWidth != 0 && this.layoutBase.autoScalingHeight != 0 && this.layoutBase.forcedScale != 0.0f) {
            double d = (double)e.getScreen().field_22789 * class_10412.method_4495();
            double guiHeight = (double)e.getScreen().field_22790 * class_10412.method_4495();
            double percentX = d / (double)this.layoutBase.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.layoutBase.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * class_10412.method_4495();
            double newScaleY = percentY / 100.0 * class_10412.method_4495();
            double newScale = Math.min(newScaleX, newScaleY);
            class_10412.method_15997(newScale);
            e.getScreen().field_22789 = class_10412.method_4486();
            e.getScreen().field_22790 = class_10412.method_4502();
        }
        oldMenuBackgrounds.forEach(menuBackground -> {
            if (!this.layoutBase.menuBackgrounds.contains(menuBackground)) {
                menuBackground.onDisableOrRemove();
            }
        });
        this.layoutBase.menuBackgrounds.forEach(MenuBackground::onAfterEnable);
    }

    @EventListener
    public void onInitOrResizeScreenPost(InitOrResizeScreenEvent.Post e) {
        this.cachedTabNavigationBar = null;
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        for (class_4068 renderable : e.getRenderables()) {
            class_8089 bar;
            if (!(renderable instanceof class_8089)) continue;
            this.cachedTabNavigationBar = bar = (class_8089)renderable;
            break;
        }
        if (ScreenCustomization.isNewMenu() && this.layoutBase.openAudio != null) {
            ResourceSupplier<IAudio> openAudioSupplier = this.layoutBase.openAudio;
            IAudio audio = openAudioSupplier.get();
            if (audio != null && audio.isReady()) {
                audio.stop();
                audio.play();
            } else {
                AtomicBoolean played = new AtomicBoolean(false);
                TaskExecutor.scheduleAtFixedRate(future -> {
                    if (played.get()) {
                        return;
                    }
                    IAudio audio2 = (IAudio)openAudioSupplier.get();
                    if (audio2 != null && audio2.isReady()) {
                        audio2.stop();
                        audio2.play();
                        played.set(true);
                        future.cancel(true);
                    }
                }, 100L, 100L, TimeUnit.MILLISECONDS, true);
            }
        }
        this.cachedScreenWidgetMetas = ScreenWidgetDiscoverer.getWidgetsOfScreen(e.getScreen());
        this.constructElementInstances(this.getScreenIdentifier(), this.cachedScreenWidgetMetas, this.activeLayouts, this.normalElements, this.vanillaWidgetElements);
        this.allElements.addAll(this.normalElements.backgroundElements);
        this.allElements.addAll(this.normalElements.foregroundElements);
        this.allElements.addAll(this.vanillaWidgetElements);
        for (AbstractElement ae : this.allElements) {
            List widgetsToRegister = ae.getWidgetsToRegister();
            if (widgetsToRegister != null) {
                widgetsToRegister = Lists.reverse(widgetsToRegister);
                for (class_364 w : widgetsToRegister) {
                    if (!(w instanceof class_6379) || ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().contains(w)) continue;
                    ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst(w);
                    class_437 class_4372 = e.getScreen();
                    if (!(class_4372 instanceof CustomizableScreen)) continue;
                    CustomizableScreen c = (CustomizableScreen)class_4372;
                    c.removeOnInitChildrenFancyMenu().add(w);
                }
            }
            if (!(ae instanceof VanillaWidgetElement)) continue;
            VanillaWidgetElement v = (VanillaWidgetElement)ae;
            v.updateWidget();
        }
        for (AbstractElement ae : Lists.reverse(this.allElements)) {
            ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst(ae);
            class_437 class_4373 = e.getScreen();
            if (!(class_4373 instanceof CustomizableScreen)) continue;
            CustomizableScreen c = (CustomizableScreen)class_4373;
            c.removeOnInitChildrenFancyMenu().add(ae);
        }
        this.layoutBase.menuBackgrounds.forEach(menuBackground -> {
            ((IMixinScreen)e.getScreen()).getChildrenFancyMenu().addFirst((class_364)menuBackground);
            class_437 patt0$temp = e.getScreen();
            if (patt0$temp instanceof CustomizableScreen) {
                CustomizableScreen c = (CustomizableScreen)patt0$temp;
                c.removeOnInitChildrenFancyMenu().add((class_364)menuBackground);
            }
        });
        if (e.getInitializationPhase() == InitOrResizeScreenEvent.InitializationPhase.RESIZE) {
            this.layoutBase.menuBackgrounds.forEach(MenuBackground::onAfterResizeScreen);
        }
    }

    @EventListener
    public void onScreenTickPre(ScreenTickEvent.Post e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        this.layoutBase.menuBackgrounds.forEach(MenuBackground::tick);
        for (AbstractElement element : this.allElements) {
            element.tick();
        }
    }

    @EventListener(priority=3)
    public void onRenderPre(RenderScreenEvent.Pre e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        for (Map.Entry<LoadingRequirementContainer, Boolean> entry : this.cachedLayoutWideLoadingRequirements.entrySet()) {
            if (entry.getKey().requirementsMet() == entry.getValue().booleanValue()) continue;
            ScreenCustomization.reInitCurrentScreen();
            break;
        }
        if (this.layoutBase.customMenuTitle != null && !this.forceDisableCustomMenuTitle) {
            ScreenTitleUtils.setScreenTitle(e.getScreen(), (class_2561)class_2561.method_43470((String)PlaceholderParser.replacePlaceholders(this.layoutBase.customMenuTitle)));
        }
        for (AbstractElement abstractElement : new ArrayList<VanillaWidgetElement>(this.vanillaWidgetElements)) {
            abstractElement.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
    }

    @EventListener
    public void onRenderPost(RenderScreenEvent.Post e) {
        if (!this.shouldCustomize(e.getScreen())) {
            return;
        }
        if (!this.backgroundDrawable) {
            for (AbstractElement element : new ArrayList<AbstractElement>(this.normalElements.backgroundElements)) {
                element.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
            }
        }
        for (AbstractElement element : new ArrayList<AbstractElement>(this.normalElements.foregroundElements)) {
            element.renderInternal(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        }
    }

    @EventListener
    public void drawToBackground(RenderedScreenBackgroundEvent e) {
        this.renderBackground(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial(), e.getScreen());
    }

    @EventListener
    public void onRenderListHeaderFooterPre(RenderedGuiListHeaderFooterEvent e) {
        class_332 graphics = e.getGraphics();
        if (this.shouldCustomize(class_310.method_1551().field_1755)) {
            class_2960 loc;
            boolean canRenderCustom;
            class_350<?> list = e.getList();
            ITexture headerTexture = this.layoutBase.scrollListHeaderTexture != null ? this.layoutBase.scrollListHeaderTexture.get() : null;
            ITexture footerTexture = this.layoutBase.scrollListFooterTexture != null ? this.layoutBase.scrollListFooterTexture.get() : null;
            boolean bl = canRenderCustom = headerTexture != null || footerTexture != null || !this.layoutBase.renderScrollListHeaderShadow || !this.layoutBase.renderScrollListFooterShadow;
            if (!canRenderCustom) {
                return;
            }
            if (headerTexture != null && (loc = headerTexture.getResourceLocation()) != null) {
                RenderingUtils.resetShaderColor(graphics);
                if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                    int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(list.method_25368(), list.method_46427());
                    int headerWidth = headerSize[0];
                    int headerHeight = headerSize[1];
                    int headerX = list.method_46426() + list.method_25368() / 2 - headerWidth / 2;
                    int headerY = list.method_46427() / 2 - headerHeight / 2;
                    graphics.method_44379(list.method_46426(), 0, list.method_55442(), list.method_46427());
                    graphics.method_25290(loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                    graphics.method_44380();
                } else if (this.layoutBase.repeatScrollListHeaderTexture) {
                    RenderingUtils.blitRepeat(graphics, loc, list.method_46426(), 0, list.method_25368(), list.method_46427(), headerTexture.getWidth(), headerTexture.getHeight());
                } else {
                    graphics.method_25290(loc, list.method_46426(), 0, 0.0f, 0.0f, list.method_25368(), list.method_46427(), list.method_25368(), list.method_46427());
                }
            }
            if (footerTexture != null && (loc = footerTexture.getResourceLocation()) != null) {
                RenderingUtils.resetShaderColor(graphics);
                if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                    int footerOriginalHeight = ScreenUtils.getScreenHeight() - list.method_55443();
                    if (footerOriginalHeight <= 0) {
                        footerOriginalHeight = 1;
                    }
                    int[] footerSize = footerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(list.method_25368(), footerOriginalHeight);
                    int footerWidth = footerSize[0];
                    int footerHeight = footerSize[1];
                    int footerX = list.method_46426() + list.method_25368() / 2 - footerWidth / 2;
                    int footerY = list.method_55443() + footerOriginalHeight / 2 - footerHeight / 2;
                    graphics.method_44379(list.method_46426(), list.method_55443(), list.method_55442(), list.method_55443() + footerOriginalHeight);
                    graphics.method_25290(loc, footerX, footerY, 0.0f, 0.0f, footerWidth, footerHeight, footerWidth, footerHeight);
                    graphics.method_44380();
                } else if (this.layoutBase.repeatScrollListFooterTexture) {
                    int footerHeight = ScreenUtils.getScreenHeight() - list.method_55443();
                    if (footerHeight <= 0) {
                        footerHeight = 1;
                    }
                    RenderingUtils.blitRepeat(graphics, loc, list.method_46426(), list.method_55443(), list.method_25368(), footerHeight, footerTexture.getWidth(), footerTexture.getHeight());
                } else {
                    int footerHeight = ScreenUtils.getScreenHeight() - list.method_55443();
                    if (footerHeight <= 0) {
                        footerHeight = 1;
                    }
                    graphics.method_25290(loc, list.method_46426(), list.method_55443(), 0.0f, 0.0f, list.method_25368(), footerHeight, list.method_25368(), footerHeight);
                }
            }
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    @EventListener
    public void onRenderTabNavigationBarHeaderBackgroundPre(RenderTabNavigationBarHeaderBackgroundEvent.Pre e) {
        class_332 graphics = e.getGraphics();
        if (this.shouldCustomize(class_310.method_1551().field_1755)) {
            class_2960 loc;
            ITexture headerTexture;
            ITexture iTexture = headerTexture = this.layoutBase.scrollListHeaderTexture != null ? this.layoutBase.scrollListHeaderTexture.get() : null;
            if (headerTexture != null && (loc = headerTexture.getResourceLocation()) != null) {
                e.setCanceled(true);
                RenderingUtils.resetShaderColor(graphics);
                if (this.layoutBase.preserveScrollListHeaderFooterAspectRatio) {
                    int[] headerSize = headerTexture.getAspectRatio().getAspectRatioSizeByMinimumSize(e.getHeaderWidth(), e.getHeaderHeight());
                    int headerWidth = headerSize[0];
                    int headerHeight = headerSize[1];
                    int headerX = e.getHeaderWidth() / 2 - headerWidth / 2;
                    int headerY = e.getHeaderHeight() / 2 - headerHeight / 2;
                    graphics.method_44379(0, 0, e.getHeaderWidth(), e.getHeaderHeight());
                    graphics.method_25290(loc, headerX, headerY, 0.0f, 0.0f, headerWidth, headerHeight, headerWidth, headerHeight);
                    graphics.method_44380();
                } else if (this.layoutBase.repeatScrollListHeaderTexture) {
                    RenderingUtils.blitRepeat(graphics, loc, 0, 0, e.getHeaderWidth(), e.getHeaderHeight(), headerTexture.getWidth(), headerTexture.getHeight());
                } else {
                    graphics.method_25290(loc, 0, 0, 0.0f, 0.0f, e.getHeaderWidth(), e.getHeaderHeight(), e.getHeaderWidth(), e.getHeaderHeight());
                }
                RenderingUtils.resetShaderColor(graphics);
            }
        }
    }

    protected void renderBackground(class_332 graphics, int mouseX, int mouseY, float partial, class_437 screen) {
        if (!this.shouldCustomize(screen)) {
            return;
        }
        this.layoutBase.menuBackgrounds.forEach(menuBackground -> {
            RenderSystem.enableBlend();
            menuBackground.keepBackgroundAspectRatio = this.layoutBase.preserveBackgroundAspectRatio;
            menuBackground.opacity = this.backgroundOpacity;
            menuBackground.method_25394(graphics, mouseX, mouseY, partial);
            menuBackground.opacity = 1.0f;
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            graphics.method_51452();
        });
        if (!this.layoutBase.menuBackgrounds.isEmpty()) {
            if (this.layoutBase.applyVanillaBackgroundBlur) {
                class_310.method_1551().field_1773.method_57796(partial);
                class_310.method_1551().method_1522().method_1235(false);
            }
            if (this.layoutBase.showScreenBackgroundOverlayOnCustomBackground) {
                int overlayY = 0;
                if (this.cachedTabNavigationBar != null) {
                    overlayY = this.cachedTabNavigationBar.method_48202().method_49619();
                }
                this._renderBackgroundOverlay(graphics, 0, overlayY, screen.field_22789, screen.field_22790);
            }
        }
        for (AbstractElement elements : new ArrayList<AbstractElement>(this.normalElements.backgroundElements)) {
            elements.renderInternal(graphics, mouseX, mouseY, partial);
        }
        this.backgroundDrawable = true;
    }

    protected void _renderBackgroundOverlay(class_332 graphics, int x, int y, int width, int height) {
        ScreenCustomizationLayer.renderBackgroundOverlay(graphics, x, y, width, height);
    }

    public static void renderBackgroundOverlay(class_332 graphics, int x, int y, int width, int height) {
        class_2960 location = class_310.method_1551().field_1687 == null ? MENU_BACKGROUND : INWORLD_MENU_BACKGROUND;
        RenderSystem.enableBlend();
        graphics.method_25291(location, x, y, 0, 0.0f, 0.0f, width, height, 32, 32);
    }

    @Nullable
    public AbstractElement getElementByInstanceIdentifier(String instanceIdentifier) {
        instanceIdentifier = instanceIdentifier.replace("vanillabtn:", "").replace("button_compatibility_id:", "");
        for (AbstractElement element : this.allElements) {
            if (!element.getInstanceIdentifier().equals(instanceIdentifier)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public MenuBackground getMenuBackgroundByInstanceIdentifier(@NotNull String identifier) {
        for (MenuBackground b : this.layoutBase.menuBackgrounds) {
            if (!b.getInstanceIdentifier().equals(identifier)) continue;
            return b;
        }
        return null;
    }

    protected boolean shouldCustomize(@Nullable class_437 screen) {
        if (screen == null) {
            return false;
        }
        if (ScreenCustomizationLayerHandler.isBeforeFinishInitialMinecraftReload() && !this.loadEarly) {
            return false;
        }
        if (!ScreenIdentifierHandler.isIdentifierOfScreen(this.getScreenIdentifier(), screen)) {
            return false;
        }
        return ScreenCustomization.isCustomizationEnabledForScreen(screen);
    }

    public static class RandomLayoutContainer {
        public static final Map<String, String> CACHED_PICKS = new HashMap<String, String>();
        public final String id;
        protected List<Layout> layouts = new ArrayList<Layout>();
        @Nullable
        protected String cachedGroupIdentifier = null;
        public ScreenCustomizationLayer parent;

        public RandomLayoutContainer(String id, ScreenCustomizationLayer parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<Layout> getLayouts() {
            return this.layouts;
        }

        public void addLayout(Layout layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<Layout> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public boolean isOnlyFirstTime() {
            for (Layout l : this.layouts) {
                if (!l.randomOnlyFirstTime) continue;
                return true;
            }
            return false;
        }

        public boolean isUniversalGroup() {
            if (this.layouts.isEmpty()) {
                return false;
            }
            for (Layout l : this.layouts) {
                if (l.isUniversalLayout()) continue;
                return false;
            }
            return true;
        }

        public String getGroupIdentifier() {
            if (this.cachedGroupIdentifier != null) {
                return this.cachedGroupIdentifier;
            }
            if (this.layouts.isEmpty()) {
                this.cachedGroupIdentifier = ScreenCustomization.generateUniqueIdentifier();
            } else {
                ArrayList<String> layoutIds = new ArrayList<String>();
                for (Layout l : this.layouts) {
                    layoutIds.add(l.runtimeLayoutIdentifier);
                }
                layoutIds.sort(Comparator.naturalOrder());
                StringBuilder id = new StringBuilder();
                for (String s : layoutIds) {
                    id.append(s);
                }
                this.cachedGroupIdentifier = id.toString();
            }
            return this.cachedGroupIdentifier;
        }

        @Nullable
        public Layout getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                Layout layout2;
                String cachedPickedLayoutIdentifier = CACHED_PICKS.get(this.getGroupIdentifier());
                if (!this.isOnlyFirstTime() && ScreenCustomization.isNewMenu()) {
                    cachedPickedLayoutIdentifier = null;
                }
                if (cachedPickedLayoutIdentifier != null) {
                    if (LayoutHandler.isLayoutLoaded(cachedPickedLayoutIdentifier)) {
                        for (Layout layout2 : this.layouts) {
                            if (!layout2.runtimeLayoutIdentifier.equals(cachedPickedLayoutIdentifier)) continue;
                            return layout2;
                        }
                    } else {
                        this.reset(true);
                    }
                }
                if (this.layouts.isEmpty()) {
                    return null;
                }
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1));
                layout2 = this.layouts.get(i);
                CACHED_PICKS.put(this.getGroupIdentifier(), layout2.runtimeLayoutIdentifier);
                return layout2;
            }
            return null;
        }

        public void garbageCollectInvalidLayouts() {
            this.layouts.removeIf(layout -> !LayoutHandler.isLayoutLoaded(layout.runtimeLayoutIdentifier));
        }

        public void reset(boolean keepValidLayouts) {
            CACHED_PICKS.remove(this.getGroupIdentifier());
            this.garbageCollectInvalidLayouts();
            this.cachedGroupIdentifier = null;
            if (!keepValidLayouts) {
                this.layouts.clear();
            }
        }
    }

    public static class ThreadCaller {
        AtomicBoolean running = new AtomicBoolean(true);
    }
}

