/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class MimicKeybindAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_DELIMITER = "|||";
    private static final long DEFAULT_KEEP_DURATION_MS = 1000L;
    private static long lastErrorNotification = -1L;

    public MimicKeybindAction() {
        super("mimic_keybind");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        MimicKeybindConfig config = MimicKeybindConfig.parse(value);
        if (config.keybindName.isEmpty()) {
            return;
        }
        class_304 keyMapping = this.findKeyMapping(config.keybindName);
        if (keyMapping == null) {
            this.handleMissingKeybind(config.keybindName);
            return;
        }
        class_3675.class_306 key = Services.PLATFORM.getKeyMappingKey(keyMapping);
        if (key == null) {
            LOGGER.error("[FANCYMENU] MimicKeybindAction could not resolve bound key for '{}'!", (Object)config.keybindName);
            this.handleMissingKeybind(config.keybindName);
            return;
        }
        if (!this.triggerKeybind(keyMapping, key, config)) {
            LOGGER.error("[FANCYMENU] MimicKeybindAction does not support key type '{}' for '{}'!", (Object)key.method_1442(), (Object)config.keybindName);
            this.handleMissingKeybind(config.keybindName);
        }
    }

    protected boolean triggerKeybind(@NotNull class_304 keyMapping, @NotNull class_3675.class_306 key, @NotNull MimicKeybindConfig config) {
        long holdDuration;
        boolean keepPressed = config.keepPressed && !config.pressedDurationMs.isBlank();
        long l = holdDuration = keepPressed ? Math.max(config.getPressedDurationAsLong(), 1L) : 0L;
        if (key.method_1442() == class_3675.class_307.field_1672) {
            this.pressMouseKey(keyMapping, key, keepPressed, holdDuration);
            return true;
        }
        if (key.method_1442() == class_3675.class_307.field_1668 || key.method_1442() == class_3675.class_307.field_1671) {
            return this.pressKeyboardKey(keyMapping, key, keepPressed, holdDuration);
        }
        return false;
    }

    private void pressMouseKey(@NotNull class_304 keyMapping, @NotNull class_3675.class_306 key, boolean keepPressed, long holdDurationMs) {
        class_304.method_1416((class_3675.class_306)key, (boolean)true);
        class_304.method_1420((class_3675.class_306)key);
        if (keepPressed) {
            this.startHoldThread(keyMapping, key, class_3675.field_16237.method_1444(), -1, false, holdDurationMs);
        } else {
            MainThreadTaskExecutor.executeInMainThread(() -> class_304.method_1416((class_3675.class_306)key, (boolean)false), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }
    }

    private boolean pressKeyboardKey(@NotNull class_304 keyMapping, @NotNull class_3675.class_306 key, boolean keepPressed, long holdDurationMs) {
        int scanCode;
        int keyCode;
        class_310 minecraft = class_310.method_1551();
        class_309 handler = minecraft.field_1774;
        long window = minecraft.method_22683().method_4490();
        if (key.method_1442() == class_3675.class_307.field_1668) {
            keyCode = key.method_1444();
            scanCode = GLFW.glfwGetKeyScancode((int)keyCode);
        } else {
            keyCode = class_3675.field_16237.method_1444();
            scanCode = key.method_1444();
        }
        class_304.method_1416((class_3675.class_306)key, (boolean)true);
        handler.method_1466(window, keyCode, scanCode, 1, 0);
        if (keepPressed) {
            this.startHoldThread(keyMapping, key, keyCode, scanCode, true, holdDurationMs);
        } else {
            MainThreadTaskExecutor.executeInMainThread(() -> this.releaseKeyboardKey(key, keyCode, scanCode), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }
        return true;
    }

    private void releaseKeyboardKey(@NotNull class_3675.class_306 key, int keyCode, int scanCode) {
        class_310 minecraft = class_310.method_1551();
        class_309 handler = minecraft.field_1774;
        handler.method_1466(minecraft.method_22683().method_4490(), keyCode, scanCode, 0, 0);
        class_304.method_1416((class_3675.class_306)key, (boolean)false);
    }

    private void startHoldThread(@NotNull class_304 keyMapping, @NotNull class_3675.class_306 key, int keyCode, int scanCode, boolean keyboard, long durationMs) {
        Thread holdThread = new Thread(() -> {
            class_310 minecraft = class_310.method_1551();
            long start = System.currentTimeMillis();
            while (minecraft.method_22108() && !Thread.currentThread().isInterrupted() && System.currentTimeMillis() - start < durationMs) {
                if (!keyMapping.method_1434()) {
                    minecraft.execute(() -> class_304.method_1416((class_3675.class_306)key, (boolean)true));
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            minecraft.execute(() -> {
                if (keyboard) {
                    this.releaseKeyboardKey(key, keyCode, scanCode);
                } else {
                    class_304.method_1416((class_3675.class_306)key, (boolean)false);
                }
            });
        }, "FancyMenu-MimicKeybindHold-" + keyMapping.method_1431());
        holdThread.start();
    }

    @Nullable
    protected class_304 findKeyMapping(@NotNull String identifier) {
        String trimmedId = identifier.trim();
        class_310 minecraft = class_310.method_1551();
        for (class_304 keyMapping : minecraft.field_1690.field_1839) {
            if (!keyMapping.method_1431().equals(trimmedId)) continue;
            return keyMapping;
        }
        return null;
    }

    protected void handleMissingKeybind(@NotNull String identifier) {
        LOGGER.error("[FANCYMENU] MimicKeybindAction failed to find keybind '{}'!", (Object)identifier);
        long now = System.currentTimeMillis();
        if (lastErrorNotification + 60000L < now) {
            lastErrorNotification = now;
            class_437 current = class_310.method_1551().field_1755;
            class_310.method_1551().method_1507((class_437)NotificationScreen.error(callback -> class_310.method_1551().method_1507(current), LocalizationUtils.splitLocalizedLines("fancymenu.actions.mimic_keybind.error", new String[0])));
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.mimic_keybind");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.mimic_keybind.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return "key.jump|||false|||1000";
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        MimicKeybindActionValueScreen screen = new MimicKeybindActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        class_310.method_1551().method_1507((class_437)screen);
    }

    @NotNull
    protected static List<String> getAvailableKeybindNames() {
        class_310 minecraft = class_310.method_1551();
        ArrayList<String> names = new ArrayList<String>();
        for (class_304 keyMapping : minecraft.field_1690.field_1839) {
            names.add(keyMapping.method_1431());
        }
        if (names.isEmpty()) {
            names.add("[NO KEYBINDS FOUND]");
        }
        return names;
    }

    protected static class MimicKeybindConfig {
        protected String keybindName = "";
        protected boolean keepPressed = false;
        @NotNull
        protected String pressedDurationMs = "1000";

        protected MimicKeybindConfig() {
        }

        protected static MimicKeybindConfig parse(@Nullable String rawValue) {
            MimicKeybindConfig config = new MimicKeybindConfig();
            if (rawValue == null || rawValue.isEmpty()) {
                return config;
            }
            String[] parts = rawValue.split("\\Q|||\\E", -1);
            config.keybindName = parts[0].trim();
            if (parts.length > 1) {
                config.keepPressed = Boolean.parseBoolean(parts[1].trim());
            }
            if (parts.length > 2) {
                config.pressedDurationMs = parts[2];
            }
            return config;
        }

        public long getPressedDurationAsLong() {
            if (MathUtils.isLong((String)this.pressedDurationMs.trim())) {
                return Long.parseLong(this.pressedDurationMs.trim());
            }
            return 0L;
        }

        protected String serialize() {
            String sanitizedName = this.keybindName.trim();
            if (sanitizedName.isEmpty()) {
                sanitizedName = "";
            }
            return sanitizedName + MimicKeybindAction.VALUE_DELIMITER + this.keepPressed + MimicKeybindAction.VALUE_DELIMITER + this.pressedDurationMs;
        }
    }

    public static class MimicKeybindActionValueScreen
    extends StringBuilderScreen {
        protected MimicKeybindConfig config;
        protected EditBoxSuggestions suggestions;
        @Nullable
        protected CellScreen.LabelCell keyInfoLabel;
        private CellScreen.TextInputCell durationCell;

        protected MimicKeybindActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((class_2561)class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.title"), callback);
            this.config = MimicKeybindConfig.parse(value);
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.keybind"));
            CellScreen.TextInputCell keybindInput = this.addTextInputCell(null, true, true).setText(this.config.keybindName);
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, keybindInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, MimicKeybindAction.getAvailableKeybindNames());
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            keybindInput.editBox.method_1863(text -> {
                this.config.keybindName = text;
                this.suggestions.method_23934();
                if (this.keyInfoLabel != null) {
                    this.keyInfoLabel.setText(this.buildCurrentKeyInfoComponent());
                }
            });
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.keep_pressed.label"));
            CellScreen.WidgetCell keepPressedCell = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.actions.mimic_keybind.edit.keep_pressed", this.config.keepPressed), true, (value, button) -> {
                this.config.keepPressed = value.getAsBoolean();
                this.updateDurationFieldState();
            });
            CycleButton keepPressedButton = (CycleButton)keepPressedCell.widget;
            keepPressedButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.actions.mimic_keybind.edit.keep_pressed.desc", new String[0])));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.pressed_duration"));
            CellScreen.TextInputCell durationInput = this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.config.pressedDurationMs = s;
            }).setText(this.config.pressedDurationMs);
            durationInput.editBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.pressed_duration.desc")));
            durationInput.editBox.method_1870(true);
            this.durationCell = durationInput;
            this.updateDurationFieldState();
            this.addCellGroupEndSpacerCell();
            this.keyInfoLabel = this.addLabelCell(this.buildCurrentKeyInfoComponent());
            this.addSpacerCell(20);
        }

        private void updateDurationFieldState() {
            if (this.durationCell != null) {
                this.durationCell.setText(this.config.pressedDurationMs);
                this.durationCell.editBox.method_1888(this.config.keepPressed);
                if (!this.config.keepPressed && this.durationCell.editBox.method_25370()) {
                    this.durationCell.editBox.method_25365(false);
                }
            }
        }

        @NotNull
        protected class_2561 buildCurrentKeyInfoComponent() {
            class_304 keyMapping = this.getKeyMapping(this.config.keybindName);
            if (keyMapping == null) {
                return class_2561.method_43471((String)"fancymenu.actions.mimic_keybind.edit.keybind_missing");
            }
            class_5250 keyName = class_2561.method_43471((String)keyMapping.method_1431());
            class_2561 keyValue = keyMapping.method_16007();
            return class_2561.method_43469((String)"fancymenu.actions.mimic_keybind.edit.keybind_preview", (Object[])new Object[]{keyName, keyValue});
        }

        @Nullable
        protected class_304 getKeyMapping(@NotNull String identifier) {
            class_310 minecraft = class_310.method_1551();
            for (class_304 keyMapping : minecraft.field_1690.field_1839) {
                if (!keyMapping.method_1431().equals(identifier.trim())) continue;
                return keyMapping;
            }
            return null;
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
            super.method_25394(graphics, mouseX, mouseY, partialTick);
            this.suggestions.method_23923(graphics, mouseX, mouseY);
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.suggestions.method_23924(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25401(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
            if (this.suggestions.method_23921(scrollDeltaY)) {
                return true;
            }
            return super.method_25401(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.suggestions.method_23922(mouseX, mouseY, button)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        public boolean allowDone() {
            return !this.config.keybindName.trim().isEmpty() && (!this.config.keepPressed || !this.config.pressedDurationMs.isBlank());
        }

        @Override
        @NotNull
        public String buildString() {
            return this.config.serialize();
        }
    }
}

