/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableEnumMap<K extends Enum<K>, V>
implements Map<K, V> {
    private final MapEntry empty = new MapEntry(this, null);
    private final Class<K> enumClass;
    private final K[] keys;
    private final MapEntry[] values;
    private int size;

    public NullableEnumMap(Class<K> enumClass) {
        this.enumClass = enumClass;
        this.keys = (Enum[])enumClass.getEnumConstants();
        this.values = (MapEntry[])Array.newInstance(MapEntry.class, ((Enum[])enumClass.getEnumConstants()).length + 1);
        Arrays.fill(this.values, this.empty);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int getIndex(Object key) {
        if (key == null) {
            return 0;
        }
        if (this.enumClass.isInstance(key)) {
            return ((Enum)key).ordinal() + 1;
        }
        throw new IllegalArgumentException("Key must be of type " + this.enumClass.getName());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values[this.getIndex(key)] != this.empty;
    }

    @Override
    public boolean containsValue(Object value) {
        for (MapEntry entry : this.values) {
            if (entry == this.empty || !Objects.equals(entry.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.values[this.getIndex((Object)key)].value;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        int index = this.getIndex(key);
        MapEntry entry = this.values[index];
        if (entry == this.empty) {
            ++this.size;
        }
        this.values[index] = new MapEntry(this, value);
        return entry.value;
    }

    @Override
    public V remove(Object key) {
        int index = this.getIndex(key);
        MapEntry entry = this.values[index];
        if (entry == this.empty) {
            return null;
        }
        this.values[index] = this.empty;
        --this.size;
        return entry.value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, this.empty);
        this.size = 0;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        HashSet<K> set = new HashSet<K>();
        if (this.values[0] != this.empty) {
            set.add(null);
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i + 1] == this.empty) continue;
            set.add(this.keys[i - 1]);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList list = new ArrayList();
        for (MapEntry value : this.values) {
            if (value == this.empty) continue;
            list.add(value.value);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        if (this.values[0] != this.empty) {
            set.add(new AbstractMap.SimpleEntry(null, this.values[0].value));
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i + 1] == this.empty) continue;
            set.add(new AbstractMap.SimpleEntry(this.keys[i - 1], this.values[i + 1].value));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableEnumMap that = (NullableEnumMap)o;
        return Arrays.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    private class MapEntry {
        private final V value;

        private MapEntry(NullableEnumMap nullableEnumMap, V value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return Objects.equals(this.value, ((MapEntry)obj).value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

