/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1087;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.spudacious5705.shops.SpudaciousShops;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.ShopInventory;
import net.spudacious5705.shops.block.entity.renderer.ShopRenderUtils;
import net.spudacious5705.shops.config.ConfigHandler;
import net.spudacious5705.shops.item.ModItems;
import net.spudacious5705.shops.item.custom.ContractScroll;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screen.ShopScreenHandlerCustomer;
import net.spudacious5705.shops.screen.ShopScreenHandlerOwner;
import net.spudacious5705.shops.screenNetworking.ShopScreenPayload;
import net.spudacious5705.shops.screenNetworking.ToggleSyncPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShopEntity
extends class_2586
implements ExtendedScreenHandlerFactory<ShopScreenPayload> {
    protected final ShopInventory shopInventory = ShopInventory.create();
    protected String ownerName;
    private final ArrayList<PlayerID> identificationRecords;
    private static final int contractsInvSize = 24;
    private final class_2371<class_1799> contracts;
    private static final PermissionLevel[] CONTRACT_PERMS = new PermissionLevel[]{PermissionLevel.OWNER, PermissionLevel.MANAGER, PermissionLevel.SUPERVISOR, PermissionLevel.CLERK};
    private static final String CONTRACT_NAME = "contract_name";
    private static final String CONTRACT_UUID = "contract_uuid";
    private static final String CONTRACT_LEVEL = "contract_lvl";
    private static final String CONTRACTS = "contracts";
    private final boolean isClient;
    private boolean decayed;
    private boolean shouldRenderParticles;
    protected int decayTimer;
    protected static final int hourInTicks = 72000;
    protected int checkIntervalTimer;
    protected int breakableTicks;
    protected final EnumMap<ToggleSyncPayload.ToggleButtonID, Boolean> toggleSettings;
    @Environment(value=EnvType.CLIENT)
    protected RendererData rendererData;
    final float particleOffset;

    @NotNull
    public InventoryDelegate getInventoryDelegate(class_1657 player) {
        return new InventoryDelegate(player, this.shopInventory);
    }

    public void itemScatter(class_1937 world, class_2338 pos) {
        class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)this.shopInventory.prepForItemScatterer());
        int contractsCount = this.identificationRecords.size() - 1;
        if (contractsCount > 0) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)ModItems.CONTRACT_SCROLL, contractsCount));
        }
    }

    public ScreenSettingsGroup getScreenSettings() {
        return ((AbstractShopBlock)this.method_11010().method_26204()).getScreenSettings();
    }

    @Nullable
    public final InventoryDelegate getOtherInventoryDelegate(class_1657 player) {
        ShopInventory inv = this.otherInventory();
        if (inv != null) {
            return new InventoryDelegate(player, inv);
        }
        return null;
    }

    @Nullable
    protected ShopInventory otherInventory() {
        return null;
    }

    @Nullable
    public final player_ID_Records_Delegate getRecordsDelegate(class_1657 player) {
        PermissionLevel perm = this.userSignIn(player);
        if (perm.canViewShopScreen()) {
            return new player_ID_Records_Delegate(perm, player.method_5667());
        }
        return null;
    }

    public static void initialiseStaticMethods() {
        PlayerID.initialise();
    }

    private static class_1799 RecordToContract(PlayerID id) {
        class_1799 stack = new class_1799((class_1935)ModItems.CONTRACT_SCROLL);
        ContractScroll.sign(stack, class_2561.method_30163((String)id.name), id.uuid);
        return stack;
    }

    public PermissionLevel quickUserSignIn(@NotNull class_1657 player) {
        UUID signIn = player.method_5667();
        PlayerID id = this.identificationRecords.stream().filter(record -> record.uuid.compareTo(signIn) == 0).findFirst().orElse(null);
        if (id != null) {
            return id.permissionLevel;
        }
        if (player.method_7337()) {
            return PermissionLevel.SERVER_ADMIN;
        }
        return PermissionLevel.CUSTOMER;
    }

    public PermissionLevel userSignIn(class_1657 player) {
        if (this.toggleSettings.getOrDefault((Object)ToggleSyncPayload.ToggleButtonID.CreativeToggle, false).booleanValue() && !player.method_7337()) {
            return PermissionLevel.CUSTOMER;
        }
        if (this.identificationRecords.isEmpty()) {
            this.identificationRecords.add(new PlayerID(player.method_5667(), player.method_5477().getString(), PermissionLevel.OWNER));
            this.method_5431();
            return PermissionLevel.OWNER;
        }
        if (this.identificationRecords.stream().noneMatch(playerID -> playerID.permissionLevel == PermissionLevel.OWNER)) {
            int maxValue = this.identificationRecords.stream().mapToInt(record -> record.permissionLevel.asInt()).max().orElse(-1);
            this.identificationRecords.replaceAll(record -> record.permissionLevel.asInt() == maxValue ? new PlayerID(record.uuid, record.name, PermissionLevel.OWNER) : record);
            this.method_5431();
        }
        return this.quickUserSignIn(player);
    }

    public settings_Delegate getSettingsDelegate(class_1657 player) {
        return new settings_Delegate(this.quickUserSignIn(player), player);
    }

    public void method_5431() {
        if (this.isClient) {
            this.forceUpdateRenderData();
        }
        super.method_5431();
    }

    private void copyRecordsToContracts() {
        this.ownerName = this.identificationRecords.stream().filter((Predicate<PlayerID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$copyRecordsToContracts$4(net.spudacious5705.shops.block.entity.AbstractShopEntity$PlayerID ), (Lnet/spudacious5705/shops/block/entity/AbstractShopEntity$PlayerID;)Z)()).findFirst().orElse((PlayerID)PlayerID.EMPTY).name;
        this.contracts.clear();
        int indexModifier = 0;
        for (PermissionLevel lvl : CONTRACT_PERMS) {
            PlayerID[] filtered = (PlayerID[])this.identificationRecords.stream().filter(record -> record.permissionLevel == lvl).toArray(PlayerID[]::new);
            int itterations = filtered.length;
            if (itterations > 6) {
                itterations = 6;
            }
            for (int i = 0; i < itterations; ++i) {
                this.contracts.set(i + indexModifier, (Object)AbstractShopEntity.RecordToContract(filtered[i]));
            }
            indexModifier += 6;
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429((class_2487)nbt, (class_2371)this.shopInventory, (class_7225.class_7874)registryLookup);
        this.identificationRecords.clear();
        if (nbt.method_10573(CONTRACTS, 9)) {
            class_2499 contractList = nbt.method_10554(CONTRACTS, 10);
            for (int index = 0; index < contractList.size(); ++index) {
                class_2487 contract = contractList.method_10602(index);
                String name = contract.method_10558(CONTRACT_NAME);
                UUID uuid = contract.method_25926(CONTRACT_UUID);
                PermissionLevel perms = PermissionLevel.fromInt(contract.method_10550(CONTRACT_LEVEL));
                if (perms.asInt() <= 0) continue;
                this.identificationRecords.add(new PlayerID(uuid, name, perms));
            }
        }
        this.copyRecordsToContracts();
        if (nbt.method_25928("owner_id")) {
            UUID ownerID = nbt.method_25926("owner_id");
            String name = nbt.method_10545("owner_name") ? nbt.method_10558("owner_name") : ownerID.toString();
            this.identificationRecords.add(new PlayerID(ownerID, name, PermissionLevel.OWNER));
        }
        if (nbt.method_10545("decay_timer")) {
            this.decayTimer = nbt.method_10550("decay_timer");
        }
        for (ToggleSyncPayload.ToggleButtonID id : ToggleSyncPayload.ToggleButtonID.values()) {
            String nbtName = "toggle_" + id.getSerialised();
            if (nbt.method_10545(nbtName)) {
                this.toggleSettings.put(id, nbt.method_10577(nbtName));
                continue;
            }
            this.toggleSettings.put(id, ConfigHandler.getDefaultToggleSetting(id));
        }
        this.checkShouldRenderParticles();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5427((class_2487)nbt, (class_2371)this.shopInventory, (boolean)false, (class_7225.class_7874)registryLookup);
        class_2499 contractList = new class_2499();
        for (PlayerID id : this.identificationRecords) {
            class_2487 contractNBT = new class_2487();
            contractNBT.method_10582(CONTRACT_NAME, id.name);
            contractNBT.method_25927(CONTRACT_UUID, id.uuid);
            contractNBT.method_10569(CONTRACT_LEVEL, id.permissionLevel.asInt());
            contractList.add((Object)contractNBT);
        }
        if (!contractList.isEmpty()) {
            nbt.method_10566(CONTRACTS, (class_2520)contractList);
        }
        nbt.method_10569("decay_timer", this.decayTimer);
        for (ToggleSyncPayload.ToggleButtonID id : ToggleSyncPayload.ToggleButtonID.values()) {
            Boolean v = this.toggleSettings.get((Object)id);
            if (v == null) continue;
            nbt.method_10556("toggle_" + id.getSerialised(), v.booleanValue());
        }
        this.checkShouldRenderParticles();
        super.method_11007(nbt, registryLookup);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public <SHOP extends AbstractShopEntity> AbstractShopEntity(class_2591<SHOP> type, class_2338 pos, class_2680 state, float particleOffset) {
        super(type, pos, state);
        this.ownerName = PlayerID.EMPTY.name;
        this.identificationRecords = new ArrayList(1);
        this.contracts = class_2371.method_10213((int)24, (Object)class_1799.field_8037);
        this.decayed = false;
        this.shouldRenderParticles = false;
        this.decayTimer = -1;
        this.checkIntervalTimer = 200;
        this.breakableTicks = -1;
        this.toggleSettings = new EnumMap(ToggleSyncPayload.ToggleButtonID.class);
        this.particleOffset = particleOffset;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.createRendererData();
            this.isClient = true;
        } else {
            this.isClient = false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void createRendererData() {
        this.rendererData = new RendererData(this.shopInventory);
    }

    private void checkShouldRenderParticles() {
        this.shouldRenderParticles = this.toggleSettings.getOrDefault((Object)ToggleSyncPayload.ToggleButtonID.EffectsToggle, false) != false && this.toggleSettings.getOrDefault((Object)ToggleSyncPayload.ToggleButtonID.CreativeToggle, false) == false;
    }

    public void serverTick(class_3218 world, class_2338 pos, AbstractShopBlock.AbstractShopBlockState shopState) {
        if (this.decayTimer > -1) {
            if (this.decayTimer > 72000) {
                if (this.shouldRenderParticles && world.field_9229.method_43057() < 0.05f) {
                    for (int i = 0; i < 3; ++i) {
                        world.method_14199((class_2394)class_2398.field_11231, (double)pos.method_10263() + 0.2 + (double)world.field_9229.method_43057(), (double)((float)pos.method_10264() + world.field_9229.method_43057() + this.particleOffset), (double)((float)pos.method_10260() + world.field_9229.method_43057()), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (shopState.unbreakable()) {
                    this.decayed = true;
                    this.identificationRecords.clear();
                    shopState.makeBreakable(world, pos);
                    this.breakableTicks = 140;
                }
            } else {
                ++this.decayTimer;
            }
        }
        --this.checkIntervalTimer;
        if (this.checkIntervalTimer < 0) {
            this.checkIntervalTimer = 6000;
            this.checkShouldRenderParticles();
            if (this.isShopFunctional()) {
                if (this.decayTimer < 0) {
                    this.decayTimer = 0;
                }
            } else {
                this.decayTimer = -1;
                this.decayed = false;
            }
        }
        if (shopState.unbreakable()) {
            return;
        }
        if (this.breakableTicks > 0) {
            if (!this.decayed) {
                --this.breakableTicks;
            }
            return;
        }
        if (this.breakableTicks < 0) {
            this.breakableTicks = 140;
        } else {
            shopState.makeUnbreakable(world, pos);
            this.breakableTicks = -1;
        }
    }

    @Deprecated
    @Nullable
    public final class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        SpudaciousShops.LOGGER.debug("Attempted to directly retrieve ScreenHandler from shop");
        return null;
    }

    public ExtendedScreenHandlerFactory<ShopScreenPayload> createScreenHandlerFactory(final boolean openTop) {
        return new ExtendedScreenHandlerFactory<ShopScreenPayload>(this){
            final /* synthetic */ AbstractShopEntity this$0;
            {
                this.this$0 = this$0;
            }

            public ShopScreenPayload getScreenOpeningData(class_3222 player) {
                return new ShopScreenPayload(this.this$0.field_11867, openTop);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Shop");
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                PermissionLevel perms = this.this$0.userSignIn(player);
                InventoryDelegate inventoryDelegate = openTop ? this.this$0.getOtherInventoryDelegate(player) : this.this$0.getInventoryDelegate(player);
                player_ID_Records_Delegate recordsDelegate = this.this$0.new player_ID_Records_Delegate(perms, player.method_5667());
                settings_Delegate set_del = this.this$0.new settings_Delegate(perms, player);
                if (perms.canViewShopScreen()) {
                    return new ShopScreenHandlerOwner(syncId, playerInventory, inventoryDelegate, recordsDelegate, set_del, this.this$0.getScreenSettings());
                }
                if (!this.this$0.isShopFunctional()) {
                    return null;
                }
                return new ShopScreenHandlerCustomer(syncId, playerInventory, inventoryDelegate, this.this$0.getScreenSettings());
            }
        };
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Shop");
    }

    public ShopScreenPayload getScreenOpeningData(class_3222 player) {
        return new ShopScreenPayload(this.field_11867, false);
    }

    public class_2680 method_11010() {
        return super.method_11010();
    }

    @Nullable
    public abstract class_2596<class_2602> method_38235();

    public boolean isUnbreakable(class_1657 player) {
        if (player.method_7337() || this.decayed) {
            return false;
        }
        if (this.identificationRecords.isEmpty()) {
            return !this.userSignIn(player).canBreakBlock();
        }
        return !this.quickUserSignIn(player).canBreakBlock();
    }

    public class_2561 cantBreakMessage() {
        return class_2561.method_30163((String)("Cannot break - Owned by " + this.ownerName));
    }

    public boolean isShopFunctional() {
        if (this.managementFunctional() && this.hasTrade()) {
            this.decayTimer = -1;
            this.decayed = false;
            return true;
        }
        if (this.decayTimer < 0) {
            this.decayTimer = 0;
        }
        return false;
    }

    public boolean managementFunctional() {
        if (this.field_11863 != null) {
            return !this.identificationRecords.isEmpty();
        }
        return false;
    }

    protected boolean hasTrade() {
        return this.shopInventory.tradeFunctional();
    }

    @Environment(value=EnvType.CLIENT)
    public void renderTick() {
        this.rendererData.onTick();
    }

    @Environment(value=EnvType.CLIENT)
    public RendererData rendererData() {
        return this.rendererData;
    }

    @Environment(value=EnvType.CLIENT)
    public void forceUpdateRenderData() {
        this.rendererData.update();
    }

    public class_2350 getCachedFacingDirection() {
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        if (direction == null) {
            return class_2350.field_11043;
        }
        return direction;
    }

    private static /* synthetic */ boolean lambda$copyRecordsToContracts$4(PlayerID playerID) {
        return playerID.permissionLevel == PermissionLevel.OWNER;
    }

    public final class InventoryDelegate
    implements class_1263 {
        private final ShopInventory inventory;
        private final PermissionLevel permissions;
        private final UUID reciever_UUID;

        public InventoryDelegate(class_1657 player, ShopInventory items) {
            this.permissions = AbstractShopEntity.this.userSignIn(player);
            this.reciever_UUID = player.method_5667();
            this.inventory = items;
        }

        public PermissionLevel checkPermissions() {
            return this.permissions;
        }

        public int method_5439() {
            return this.inventory.size();
        }

        public boolean method_5442() {
            return this.inventory.isEmpty();
        }

        public class_1799 method_5438(int slot) {
            if (slot > this.method_5439() || slot < 0) {
                return class_1799.field_8037;
            }
            if (slot > 75) {
                return (class_1799)this.inventory.get(slot);
            }
            if (this.permissions.canViewShopScreen()) {
                return (class_1799)this.inventory.get(slot);
            }
            return class_1799.field_8037;
        }

        public void trade(class_1661 playerInv) {
            class_2371<class_1799> vendList;
            boolean tradeCreative = AbstractShopEntity.this.toggleSettings.getOrDefault((Object)ToggleSyncPayload.ToggleButtonID.CreativeToggle, false);
            if (tradeCreative) {
                vendList = class_2371.method_37434((int)53);
                vendList.add(0, (Object)this.inventory.getVendingStack().method_7972());
            } else {
                vendList = InventoryDelegate.takeItems(this.inventory.getVendingStack(), arg_0 -> ((ShopInventory)this.inventory).get(arg_0), 0, 53);
            }
            class_2371<class_1799> payList = InventoryDelegate.takeItems(this.inventory.getPaymentStack(), arg_0 -> ((class_1661)playerInv).method_5438(arg_0), 0, 36);
            if (!tradeCreative) {
                class_1799 allowStack = this.inventory.getPaymentStack();
                int ptr = 0;
                for (int i = 54; i <= 75; ++i) {
                    class_1799 storageStack = (class_1799)this.inventory.get(i);
                    if (!ShopScreenHandlerOwner.canMerge(storageStack, allowStack) && !storageStack.method_7960()) continue;
                    while (ptr < payList.size() && storageStack.method_7947() < storageStack.method_7914()) {
                        int space = InventoryDelegate.getAvalableSpace(storageStack);
                        if (storageStack.method_7960()) {
                            storageStack = ((class_1799)payList.get(ptr)).method_51164();
                        } else {
                            storageStack.method_7939(((class_1799)payList.get(ptr)).method_7971(space).method_7947() + storageStack.method_7947());
                        }
                        this.inventory.set(i, storageStack);
                        if (!((class_1799)payList.get(ptr)).method_7960()) continue;
                        ++ptr;
                    }
                }
            }
            int ptr = 0;
            boolean success = true;
            while (success && ptr < vendList.size()) {
                success = playerInv.method_7394((class_1799)vendList.get(ptr));
            }
            class_1657 player = playerInv.field_7546;
            class_1264.method_17349((class_1937)player.method_37908(), (class_2338)player.method_24515(), vendList);
        }

        public boolean canTrade(class_1657 playerEntity) {
            if (!AbstractShopEntity.this.toggleSettings.getOrDefault((Object)ToggleSyncPayload.ToggleButtonID.CreativeToggle, false).booleanValue()) {
                if (this.inventory.outOfStock()) {
                    this.errorMessage("Shop is out of stock", playerEntity);
                    return false;
                }
                if (this.inventory.paymentRegisterFull()) {
                    this.errorMessage("Shop cannot store any more currency", playerEntity);
                    return false;
                }
            }
            if (this.inventory.isPlayerPoor(playerEntity)) {
                this.errorMessage("You do not have enough currency", playerEntity);
                return false;
            }
            return true;
        }

        private void errorMessage(String message, class_1657 player) {
            if (player.method_37908().method_8608()) {
                player.method_7353(class_2561.method_30163((String)message), true);
            }
        }

        private static class_2371<class_1799> takeItems(class_1799 retrieveStack, miniDelegate inventory, int start, int end) {
            class_2371 list = class_2371.method_37434((int)(end - start));
            int moneyRequired = retrieveStack.method_7947();
            for (int i = start; i <= end; ++i) {
                class_1799 stack = inventory.getStack(i);
                if (!ShopScreenHandlerOwner.canMerge(stack, retrieveStack)) continue;
                if (stack.method_7947() >= moneyRequired) {
                    InventoryDelegate.addToList((class_2371<class_1799>)list, stack.method_7971(moneyRequired));
                    break;
                }
                moneyRequired -= stack.method_7947();
                InventoryDelegate.addToList((class_2371<class_1799>)list, stack);
            }
            return list;
        }

        private static void addToList(class_2371<class_1799> list, class_1799 stack) {
            if (list.isEmpty()) {
                list.add((Object)stack.method_51164());
                return;
            }
            int end = list.size() - 1;
            class_1799 listEnd = (class_1799)list.get(end);
            int space = InventoryDelegate.getAvalableSpace(listEnd);
            list.set(end, (Object)listEnd.method_46651(listEnd.method_7947() + stack.method_7971(space).method_7947()));
            if (!stack.method_7960()) {
                list.add((Object)stack.method_51164());
            }
        }

        private static int getAvalableSpace(class_1799 stack) {
            return Math.max(stack.method_7914() - stack.method_7947(), 0);
        }

        public class_1799 method_5434(int slot, int amount) {
            if (slot > this.method_5439() || slot < 0) {
                return class_1799.field_8037;
            }
            if (slot < 76) {
                if (this.permissions.canTakeItems()) {
                    return this.inventory.split(slot, amount);
                }
            } else if (this.permissions.canEditTrades()) {
                this.inventory.split(slot, amount);
            }
            return class_1799.field_8037;
        }

        public class_1799 method_5441(int slot) {
            return this.method_5434(slot, 64);
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot >= 76) {
                if (this.permissions.canEditTrades()) {
                    this.inventory.set(slot, stack);
                }
            } else if (this.permissions.canImportStock()) {
                this.inventory.set(slot, stack);
            }
        }

        public void method_5431() {
            assert (AbstractShopEntity.this.field_11863 != null);
            AbstractShopEntity.this.field_11863.method_8413(AbstractShopEntity.this.field_11867, AbstractShopEntity.this.method_11010(), AbstractShopEntity.this.method_11010(), 3);
            AbstractShopEntity.this.isShopFunctional();
            AbstractShopEntity.this.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return player.method_5667().compareTo(this.reciever_UUID) == 0;
        }

        public void method_5448() {
        }

        public class_1792 getPaymentType() {
            return this.inventory.getPaymentType();
        }

        public int getPrice() {
            return this.inventory.getPrice();
        }

        public class_1792 getDisplayItem() {
            return this.inventory.getDisplayItem();
        }

        private static interface miniDelegate {
            public class_1799 getStack(int var1);
        }
    }

    public final class player_ID_Records_Delegate
    implements class_1263 {
        private final PermissionLevel perms;
        private final UUID userUUID;

        public player_ID_Records_Delegate(PermissionLevel perms, UUID userUUID) {
            this.perms = perms;
            this.userUUID = userUUID;
        }

        public class_1799 insertContract(class_1799 contract, int index) {
            PlayerID id;
            if (this.canEditThat(index) && contract != null && ContractScroll.isSigned(contract) && (id = PlayerID.fromContract(contract, player_ID_Records_Delegate.permFromIndex(index))) != null && AbstractShopEntity.this.identificationRecords.stream().noneMatch(playerID -> playerID.uuid.compareTo(id.uuid) == 0) && AbstractShopEntity.this.contracts.get(index) == class_1799.field_8037) {
                AbstractShopEntity.this.identificationRecords.add(id);
                AbstractShopEntity.this.contracts.set(index, (Object)contract);
                this.method_5431();
                return class_1799.field_8037;
            }
            return contract;
        }

        private static PermissionLevel permFromIndex(int index) {
            return PermissionLevel.fromInt(4 - index / 6);
        }

        public static boolean checkAction(class_1799 contract, int index) {
            if (player_ID_Records_Delegate.checkIndex(index) && contract.method_7909() == ModItems.CONTRACT_SCROLL) {
                return ContractScroll.isSigned(contract);
            }
            return false;
        }

        private static boolean checkIndex(int index) {
            return index < 24 && index >= 0;
        }

        private boolean canEditThat(int index) {
            if (player_ID_Records_Delegate.checkIndex(index) && this.perms.canEditPermissions()) {
                PermissionLevel perm = player_ID_Records_Delegate.permFromIndex(index);
                if (perm.asInt() < PermissionLevel.MANAGER.asInt()) {
                    return true;
                }
                if (this.perms == PermissionLevel.OWNER) {
                    return true;
                }
                return this.checkContract(this.fetchContract(index, false));
            }
            return false;
        }

        public int method_5439() {
            return 24;
        }

        public boolean method_5442() {
            return AbstractShopEntity.this.contracts.isEmpty();
        }

        private class_1799 fetchContract(int index, boolean remove) {
            if (player_ID_Records_Delegate.checkIndex(index)) {
                int i;
                PermissionLevel perm = player_ID_Records_Delegate.permFromIndex(index);
                PlayerID[] array = (PlayerID[])AbstractShopEntity.this.identificationRecords.stream().filter(PlayerID2 -> PlayerID2.permissionLevel == perm).toArray(PlayerID[]::new);
                if (array.length > (i = index % 6)) {
                    PlayerID id = array[i];
                    class_1799 record = AbstractShopEntity.RecordToContract(id);
                    if (remove) {
                        AbstractShopEntity.this.identificationRecords.removeIf(playerID -> playerID.uuid.compareTo(id.uuid) == 0);
                        class_1937 class_19372 = AbstractShopEntity.this.field_11863;
                        if (class_19372 instanceof class_3218) {
                            class_3218 server = (class_3218)class_19372;
                            server.method_18456().stream().filter(player -> player.method_5667().compareTo(id.uuid) == 0).findFirst().ifPresent(class_3222::method_7346);
                        }
                        AbstractShopEntity.this.contracts.set(index, (Object)class_1799.field_8037);
                        this.method_5431();
                    }
                    return record;
                }
            }
            return class_1799.field_8037;
        }

        public class_1799 method_5438(int index) {
            return this.fetchContract(index, false);
        }

        public class_1799 method_5434(int index, int amount) {
            return this.method_5441(index);
        }

        public class_1799 method_5441(int index) {
            if (this.canEditThat(index)) {
                class_1799 contract = this.fetchContract(index, true);
                this.method_5431();
                return contract;
            }
            return class_1799.field_8037;
        }

        public void method_5447(int index, class_1799 contract) {
        }

        public void method_5431() {
            if (AbstractShopEntity.this.field_11863 != null) {
                AbstractShopEntity.this.field_11863.method_8413(AbstractShopEntity.this.field_11867, AbstractShopEntity.this.method_11010(), AbstractShopEntity.this.method_11010(), 3);
            }
            AbstractShopEntity.this.copyRecordsToContracts();
            AbstractShopEntity.this.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return this.perms.canEditPermissions();
        }

        public void method_5448() {
        }

        public boolean checkContract(@Nullable class_1799 stack) {
            UUID uuid;
            if (stack != null && (uuid = ContractScroll.getUUID(stack)) != null) {
                return 0 == uuid.compareTo(this.userUUID);
            }
            return false;
        }

        public void selfDemote(class_3222 player) {
            if (player.method_5667().compareTo(this.userUUID) == 0) {
                AbstractShopEntity.this.identificationRecords.removeIf(playerID -> playerID.uuid.compareTo(this.userUUID) == 0);
                this.method_5431();
            }
        }
    }

    private record PlayerID(UUID uuid, String name, PermissionLevel permissionLevel) {
        public static final PlayerID EMPTY = new PlayerID(new UUID(0L, 0L), "##OWNER NAME NULL##", PermissionLevel.CUSTOMER);

        public static PlayerID fromContract(class_1799 contract, PermissionLevel permissionLevel) {
            if (ContractScroll.isSigned(contract)) {
                class_2561 nameText = ContractScroll.getPlayerName(contract);
                UUID uuid = ContractScroll.getUUID(contract);
                String name = nameText == null ? "##OWNER NAME NULL##" : nameText.getString();
                return new PlayerID(uuid, name, permissionLevel);
            }
            return null;
        }

        public static void initialise() {
        }
    }

    public final class settings_Delegate {
        private final boolean isCreative;
        private final boolean canEditSettings;

        private settings_Delegate(PermissionLevel perms, class_1657 player) {
            this.isCreative = player.method_7337();
            this.canEditSettings = perms.canEditTrades();
        }

        public boolean getState(@NotNull ToggleSyncPayload.ToggleButtonID ID) {
            return AbstractShopEntity.this.toggleSettings.get((Object)ID);
        }

        public boolean attemptSetState(@NotNull ToggleSyncPayload.ToggleButtonID ID, @NotNull Boolean state) {
            if (this.canEditSettings && (ID != ToggleSyncPayload.ToggleButtonID.CreativeToggle || this.isCreative)) {
                AbstractShopEntity.this.toggleSettings.put(ID, state);
                AbstractShopEntity.this.method_5431();
                AbstractShopEntity.this.checkShouldRenderParticles();
                return true;
            }
            return false;
        }

        public boolean isPlayerCreative() {
            return this.isCreative;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class RendererData {
        protected final ShopInventory inventory;
        public double lastRotation = 0.0;
        public double targetRotation = 0.0;
        public double frameRotation = 0.0;
        public final double doublePi = Math.PI * 2;
        public String stockQuantity;
        protected class_2350 direction = class_2350.field_11043;
        protected int rotation;
        protected float width;
        protected boolean shopFunctional = false;
        protected class_1799 paymentItem;
        protected class_1799 displayItem;
        protected String text;
        protected int frameAccumulation = 380;
        protected boolean stockDisplayType = false;
        protected boolean currencyDisplayType = true;
        protected boolean shouldUpdate = true;
        public boolean stockWarning = false;
        public boolean paymentWarning = false;
        protected float qWidth;

        public RendererData(ShopInventory inv) {
            this.inventory = inv;
        }

        public void update() {
            boolean bl = this.shopFunctional = AbstractShopEntity.this.isShopFunctional() && this.inventory.tradeFunctional();
            if (this.shopFunctional) {
                class_1087 model;
                this.paymentItem = this.inventory.getPaymentStack();
                this.stockQuantity = Integer.toString(this.inventory.getVendingStack().method_7947());
                boolean bl2 = this.stockWarning || this.paymentWarning;
                this.paymentWarning = this.inventory.paymentRegisterFull();
                this.stockWarning = this.inventory.outOfStock();
                if (!bl2 && (this.stockWarning || this.paymentWarning)) {
                    this.lastRotation = this.targetRotation = ShopRenderUtils.calcTargetRotation(this);
                }
                this.displayItem = this.inventory.getVendingStack();
                this.text = Integer.toString(this.inventory.getPrice());
                this.direction = AbstractShopEntity.this.getCachedFacingDirection();
                this.getRotation();
                this.width = this.inventory.getPrice() >= 10 ? -7.0f : -2.5f;
                this.qWidth = this.inventory.getVendingQuantity() >= 10 ? -7.0f : -2.5f;
                class_310 client = class_310.method_1551();
                if (this.displayItem.method_7909() instanceof class_1747) {
                    model = client.method_1480().method_4019(this.displayItem, null, null, 0);
                    this.stockDisplayType = model.method_4712();
                } else {
                    this.stockDisplayType = false;
                }
                if (this.paymentItem.method_7909() instanceof class_1747) {
                    model = client.method_1480().method_4019(this.paymentItem, null, null, 0);
                    this.currencyDisplayType = model.method_4712();
                } else {
                    this.currencyDisplayType = false;
                }
            } else {
                this.displayItem = class_1799.field_8037;
                this.paymentItem = class_1799.field_8037;
            }
        }

        public void frameAccumulator() {
            if (this.frameAccumulation == 0) {
                this.frameAccumulation += (int)(Math.random() * 40.0);
                this.shouldUpdate = true;
                this.update();
            }
            ++this.frameAccumulation;
            if (this.frameAccumulation >= 400) {
                this.frameAccumulation = 0;
            }
        }

        private void getRotation() {
            this.rotation = switch (this.direction) {
                case class_2350.field_11034 -> 90;
                case class_2350.field_11035 -> 0;
                case class_2350.field_11039 -> 270;
                default -> 180;
            };
        }

        public boolean shopFunctional() {
            return this.shopFunctional;
        }

        public boolean stockDisplayType() {
            return this.stockDisplayType;
        }

        public boolean currencyDisplayType() {
            return this.currencyDisplayType;
        }

        public class_1799 displayItem() {
            return this.displayItem;
        }

        public class_1937 world() {
            return AbstractShopEntity.this.field_11863;
        }

        public class_2350 direction() {
            return this.direction;
        }

        public String text() {
            return this.text;
        }

        public float width() {
            return this.width;
        }

        public float qWidth() {
            return this.qWidth;
        }

        public class_1799 paymentType() {
            return this.paymentItem;
        }

        public int rotation() {
            return this.rotation;
        }

        public boolean updateIconRotation() {
            if (this.shouldUpdate) {
                this.shouldUpdate = false;
                return true;
            }
            return false;
        }

        public void onTick() {
            this.shouldUpdate = true;
        }

        public int x() {
            return AbstractShopEntity.this.field_11867.method_10263();
        }

        public int y() {
            return AbstractShopEntity.this.field_11867.method_10264();
        }

        public int z() {
            return AbstractShopEntity.this.field_11867.method_10260();
        }

        public boolean renderIcons() {
            return AbstractShopEntity.this.shouldRenderParticles;
        }
    }
}

