/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import java.util.HashSet;
import net.minecraft.class_2248;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelShapeHelper {
    public static class_265 rotateY(class_265 shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).orElse(shape);
    }

    public static class_265 rotateX(class_265 shape, int rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (rotation) {
                case 90: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 + y1, x2 * 16.0, 8.0 - z2, 8.0 + y2));
                    break;
                }
                case 180: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 - z1, 8.0 - y1, x2 * 16.0, 8.0 - z2, 8.0 - y2));
                    break;
                }
                case 270: {
                    rotatedShapes.add(VoxelShapeHelper.boxSafe(x1 * 16.0, 8.0 + z1, 8.0 - y1, x2 * 16.0, 8.0 + z2, 8.0 - y2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid rotation " + rotation + " (must be 90,180 or 270)");
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).orElse(shape);
    }

    public static class_265 combine(class_247 func, class_265 ... shapes) {
        class_265 result = class_259.method_1073();
        for (class_265 shape : shapes) {
            result = class_259.method_1082((class_265)result, (class_265)shape, (class_247)func);
        }
        return result.method_1097();
    }

    private static class_265 boxSafe(double pMinX, double pMinY, double pMinZ, double pMaxX, double pMaxY, double pMaxZ) {
        double x1 = Math.min(pMinX, pMaxX);
        double x2 = Math.max(pMinX, pMaxX);
        double y1 = Math.min(pMinY, pMaxY);
        double y2 = Math.max(pMinY, pMaxY);
        double z1 = Math.min(pMinZ, pMaxZ);
        double z2 = Math.max(pMinZ, pMaxZ);
        return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

