/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileDataManager<BE extends class_2586> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final BE tile;
    protected Map<String, AbstractDataStore<?>> dataStoreMap = new HashMap();
    protected Map<AbstractDataStore<?>, Integer> dataFlags = new HashMap();
    protected List<AbstractDataStore<?>> dataOrder = new ArrayList();

    public TileDataManager(BE tile) {
        this.tile = tile;
    }

    public <D extends AbstractDataStore<?>> D register(String name, D data, int ... flags) {
        assert (class_2960.method_20208((String)name));
        int combinedFlags = 0;
        for (int flag : flags) {
            combinedFlags |= flag;
        }
        this.dataStoreMap.put(name, data);
        this.dataFlags.put(data, combinedFlags);
        this.dataOrder.add(data);
        return data;
    }

    public void tick() {
        if (this.tile.method_10997().method_8608()) {
            return;
        }
        boolean changes = false;
        for (AbstractDataStore<?> data : this.dataOrder) {
            if (!data.isDirty(true)) continue;
            this.sendToClient(data);
            changes = true;
        }
        if (changes) {
            this.tile.method_5431();
        }
    }

    public void load(class_7225.class_7874 provider, class_2487 tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 8) > 0 && tag.method_10545(name)) {
                data.fromTag(provider, tag.method_10580(name));
            }
        });
    }

    public void save(class_7225.class_7874 provider, class_2487 tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 8) > 0) {
                tag.method_10566(name, data.toTag(provider));
            }
        });
    }

    public void loadFromItem(class_7225.class_7874 provider, class_2487 tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 1) > 0 && tag.method_10545(name)) {
                data.fromTag(provider, tag.method_10580(name));
            }
        });
    }

    public void saveToItem(class_7225.class_7874 provider, class_2487 tag) {
        this.dataStoreMap.forEach((name, data) -> {
            if ((this.dataFlags.get(data) & 1) > 0) {
                tag.method_10566(name, data.toTag(provider));
            }
        });
    }

    protected void sendToClient(AbstractDataStore<?> data) {
        if ((this.dataFlags.get(data) & 4) == 0) {
            return;
        }
        int index = this.dataOrder.indexOf(data);
        class_2338 pos = this.tile.method_11016();
        PolyLibNetwork.sendTileDataValueToClients(this.tile.method_10997(), pos, buf -> {
            buf.method_10807(pos);
            buf.method_10804(index);
            data.toBytes((class_9129)buf);
        });
    }

    public void handleSyncFromServer(class_1657 player, class_9129 packet) {
        int index = packet.method_10816();
        this.dataOrder.get(index).fromBytes(packet);
    }

    public void handleSyncFromClient(class_3222 player, class_9129 packet) {
        int index = packet.method_10816();
        AbstractDataStore<?> data = this.dataOrder.get(index);
        if ((this.dataFlags.get(data) & 2) > 0) {
            data.fromBytes(packet);
            data.markDirty();
        }
    }
}

