/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.geometry;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;

public interface Position {
    public double x();

    public double y();

    default public Position offset(double x, double y) {
        return Position.create(this.x() + x, this.y() + y);
    }

    default public double get(Axis axis) {
        return axis == Axis.X ? this.x() : this.y();
    }

    public static Position create(double x, double y) {
        return new Immutable(x, y);
    }

    public static Position create(Supplier<Double> getX, Supplier<Double> getY) {
        return new Dynamic(getX, getY);
    }

    public static Position create(GuiParent<?> parent) {
        return new Bound(parent);
    }

    public record Immutable(double xPos, double yPos) implements Position
    {
        @Override
        public double x() {
            return this.xPos;
        }

        @Override
        public double y() {
            return this.yPos;
        }

        @Override
        public String toString() {
            return "Immutable{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }

    public record Dynamic(Supplier<Double> getX, Supplier<Double> getY) implements Position
    {
        @Override
        public double x() {
            return this.getX.get();
        }

        @Override
        public double y() {
            return this.getY.get();
        }

        @Override
        public String toString() {
            return "Dynamic{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }

    public record Bound(GuiParent<?> parent) implements Position
    {
        @Override
        public double x() {
            return this.parent.xMin();
        }

        @Override
        public double y() {
            return this.parent.yMin();
        }

        @Override
        public String toString() {
            return "Bound{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }

    public static class Mutable
    implements Position {
        private double x;
        private double y;

        public Mutable(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        @Override
        public Position offset(double x, double y) {
            this.x += x;
            this.y += y;
            return this;
        }

        public Position set(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public String toString() {
            return "Mutable{x=" + this.x() + ", y=" + this.y() + "}";
        }
    }
}

