/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.geometry;

import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;

public enum Direction {
    UP(Axis.Y),
    LEFT(Axis.X),
    DOWN(Axis.Y),
    RIGHT(Axis.X);

    private final Axis axis;

    private Direction(Axis axis) {
        this.axis = axis;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Direction opposite() {
        if (this.axis == Axis.X) {
            return this == LEFT ? RIGHT : LEFT;
        }
        return this == UP ? DOWN : UP;
    }

    public Direction rotateCW() {
        return Direction.values()[(this.ordinal() + Direction.values().length - 1) % Direction.values().length];
    }

    public Direction rotateCCW() {
        return Direction.values()[(this.ordinal() + 1) % Direction.values().length];
    }

    public double rotationTo(Direction other) {
        return (this.ordinal() - other.ordinal()) * 90;
    }
}

