/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_4668;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiTextField
extends GuiElement<GuiTextField>
implements BackgroundRender {
    private static final class_1921 HIGHLIGHT_TYPE = class_1921.method_24048((String)"text_field_highlight", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_757::method_34540)).method_51788(class_4668.field_44816).method_23617(false));
    private int tick;
    private int cursorPos;
    private int maxLength = 32;
    private int displayPos;
    private int highlightPos;
    private boolean focused;
    private boolean shiftPressed;
    private Supplier<Boolean> isEditable = () -> true;
    private Supplier<Boolean> isFocusable = () -> true;
    private Supplier<Boolean> canLoseFocus = () -> true;
    private Runnable onEditComplete = null;
    private Runnable onEnterPressed = null;
    private TextState textState = TextState.simpleState("");
    private Supplier<Boolean> shadow = () -> true;
    private Supplier<Integer> textColor = () -> 0xE0E0E0;
    private Supplier<class_2561> suggestion = null;
    private Supplier<Integer> suggestionColour = () -> 8355712;
    private Supplier<Boolean> suggestionShadow = () -> true;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (string, pos) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);

    public GuiTextField(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiTextField setOnEditComplete(Runnable onEditComplete) {
        this.onEditComplete = onEditComplete;
        return this;
    }

    public GuiTextField setEnterPressed(Runnable onEnterPressed) {
        this.onEnterPressed = onEnterPressed;
        return this;
    }

    public GuiTextField setTextState(TextState textState) {
        this.textState = textState;
        return this;
    }

    public TextState getTextState() {
        return this.textState;
    }

    public GuiTextField setTextColor(Supplier<Integer> textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiTextField setTextColor(int textColor) {
        return this.setTextColor(() -> textColor);
    }

    public GuiTextField setShadow(Supplier<Boolean> shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiTextField setShadow(boolean shadow) {
        return this.setShadow(() -> shadow);
    }

    public GuiTextField setSuggestion(class_2561 suggestion) {
        return this.setSuggestion(suggestion == null ? null : () -> suggestion);
    }

    public GuiTextField setSuggestion(@Nullable Supplier<class_2561> suggestion) {
        this.suggestion = suggestion;
        return this;
    }

    public GuiTextField setSuggestionColour(Supplier<Integer> suggestionColour) {
        this.suggestionColour = suggestionColour;
        return this;
    }

    public GuiTextField setSuggestionColour(int suggestionColour) {
        this.suggestionColour = () -> suggestionColour;
        return this;
    }

    public GuiTextField setSuggestionShadow(Supplier<Boolean> suggestionShadow) {
        this.suggestionShadow = suggestionShadow;
        return this;
    }

    public GuiTextField setSuggestionShadow(boolean suggestionShadow) {
        this.suggestionShadow = () -> suggestionShadow;
        return this;
    }

    public GuiTextField setFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public GuiTextField setFormatter(BiFunction<String, Integer, class_5481> formatter) {
        this.formatter = formatter;
        return this;
    }

    public GuiTextField setCanLoseFocus(boolean canLoseFocus) {
        return this.setCanLoseFocus(() -> canLoseFocus);
    }

    public GuiTextField setCanLoseFocus(Supplier<Boolean> canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
        return this;
    }

    public GuiTextField setFocusable(boolean focusable) {
        return this.setFocusable(() -> focusable);
    }

    public GuiTextField setFocusable(Supplier<Boolean> focusable) {
        this.isFocusable = focusable;
        return this;
    }

    public GuiTextField setEditable(boolean editable) {
        return this.setEditable(() -> editable);
    }

    public GuiTextField setEditable(Supplier<Boolean> editable) {
        this.isEditable = editable;
        return this;
    }

    public GuiTextField setMaxLength(int newWidth) {
        String value = this.getValue();
        this.maxLength = newWidth;
        if (value.length() > newWidth) {
            this.textState.setText(value.substring(0, newWidth));
        }
        return this;
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public GuiTextField setValue(String newValue) {
        if (this.filter.test(newValue)) {
            if (newValue.length() > this.maxLength) {
                this.textState.setText(newValue.substring(0, this.maxLength));
            } else {
                this.textState.setText(newValue);
            }
            this.moveCursorToEnd();
            this.setHighlightPos(this.cursorPos);
        }
        return this;
    }

    public String getValue() {
        return this.textState.getText();
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.getValue().substring(i, j);
    }

    public void insertText(String text) {
        String newValue;
        String toInsert;
        int insertLen;
        String value = this.getValue();
        int selectStart = Math.min(this.cursorPos, this.highlightPos);
        int selectEnd = Math.max(this.cursorPos, this.highlightPos);
        int freeSpace = this.maxLength - value.length() - (selectStart - selectEnd);
        if (freeSpace < (insertLen = (toInsert = class_3544.method_57180((String)text)).length())) {
            toInsert = toInsert.substring(0, freeSpace);
            insertLen = freeSpace;
        }
        if (this.filter.test(newValue = new StringBuilder(value).replace(selectStart, selectEnd, toInsert).toString())) {
            this.textState.setText(newValue);
            this.setCursorPosition(selectStart + insertLen);
            this.setHighlightPos(this.cursorPos);
        }
    }

    private void deleteText(int i) {
        if (class_437.method_25441()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (!this.getValue().isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteChars(this.getWordPosition(i) - this.cursorPos);
            }
        }
    }

    public void deleteChars(int i1) {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(i1);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(s = new StringBuilder(value).delete(j, k).toString())) {
                    this.textState.setText(s);
                    this.moveCursorTo(j);
                }
            }
        }
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int i1) {
        return this.getWordPosition(i, i1, true);
    }

    private int getWordPosition(int i1, int i2, boolean b) {
        String value = this.getValue();
        int i = i2;
        boolean flag = i1 < 0;
        int j = Math.abs(i1);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = value.length();
                if ((i = value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (b && i < l && value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (b && i > 0 && value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int pos) {
        this.moveCursorTo(this.getCursorPos(pos));
    }

    private int getCursorPos(int i) {
        return class_156.method_27761((String)this.getValue(), (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int pos, boolean notify) {
        this.setCursorPosition(pos);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    public void moveCursorTo(int pos) {
        this.moveCursorTo(pos, true);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.getValue().length());
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd(boolean notify) {
        this.moveCursorTo(this.getValue().length(), notify);
    }

    public void moveCursorToEnd() {
        this.moveCursorToEnd(true);
    }

    public boolean isEditable() {
        return this.isEditable.get();
    }

    public void setFocus(boolean focused) {
        if (this.focused && !focused && this.onEditComplete != null) {
            this.onEditComplete.run();
        }
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setHighlightPos(int newPos) {
        String value = this.getValue();
        int length = value.length();
        this.highlightPos = class_3532.method_15340((int)newPos, (int)0, (int)length);
        if (this.displayPos > length) {
            this.displayPos = length;
        }
        int width = (int)this.xSize();
        String visibleText = this.font().method_27523(value.substring(this.displayPos), width);
        int endPos = this.displayPos + visibleText.length();
        if (this.highlightPos == this.displayPos) {
            this.displayPos -= this.font().method_27524(value, width, true).length();
        }
        if (this.highlightPos > endPos) {
            this.displayPos += this.highlightPos - endPos;
        } else if (this.highlightPos <= this.displayPos) {
            this.displayPos -= this.displayPos - this.highlightPos;
        }
        this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)length);
    }

    @Override
    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)key)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)key)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)key)) {
            if (this.isEditable()) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)key)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable()) {
                this.insertText("");
            }
            return true;
        }
        switch (key) {
            case 259: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 257: 
            case 335: {
                if (this.onEditComplete != null) {
                    this.onEditComplete.run();
                }
                if (this.onEnterPressed != null) {
                    this.onEnterPressed.run();
                }
            }
            default: {
                return key != 256;
            }
            case 261: {
                if (this.isEditable()) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: 
        }
        this.moveCursorToEnd();
        return true;
    }

    public boolean canConsumeInput() {
        return this.isFocused() && this.isEditable() && this.isEnabled();
    }

    @Override
    public boolean keyReleased(int key, int scancode, int modifiers, boolean consumed) {
        this.shiftPressed = class_437.method_25442();
        return super.keyReleased(key, scancode, modifiers, consumed);
    }

    @Override
    public boolean charTyped(char charTyped, int charCode) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_3544.method_57175((char)charTyped)) {
            if (this.isEditable()) {
                this.insertText(Character.toString(charTyped));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseClicked(mouseX, mouseY, button, consumed);
        boolean mouseOver = this.isMouseOver();
        if (this.isFocused() && !mouseOver) {
            this.setFocus(this.isFocusable.get() != false && this.canLoseFocus.get() == false);
        }
        if (consumed) {
            return true;
        }
        if (this.canLoseFocus.get().booleanValue()) {
            this.setFocus(mouseOver && this.isFocusable.get() != false);
        } else {
            this.setFocus(this.isFocusable.get());
        }
        if (this.isFocused() && mouseOver && button == 0) {
            int i = (int)((double)class_3532.method_15357((double)mouseX) - this.xMin());
            String s = this.font().method_27523(this.getValue().substring(this.displayPos), (int)this.xSize());
            this.moveCursorTo(this.font().method_27523(s, i).length() + this.displayPos);
            return true;
        }
        return false;
    }

    @Override
    public double getBackgroundDepth() {
        return 0.04;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        String value = this.getValue();
        int colour = this.textColor.get();
        int textStart = this.cursorPos - this.displayPos;
        int highlightStart = this.highlightPos - this.displayPos;
        String displayText = this.font().method_27523(value.substring(this.displayPos), (int)this.xSize());
        boolean flag = textStart >= 0 && textStart <= displayText.length();
        boolean cursorBlink = this.isFocused() && this.tick / 6 % 2 == 0 && flag;
        double drawX = this.xMin();
        double drawY = this.yMin() + (this.ySize() - 8.0) / 2.0;
        int drawEnd = (int)drawX;
        if (highlightStart > displayText.length()) {
            highlightStart = displayText.length();
        }
        if (!displayText.isEmpty()) {
            String drawString = flag ? displayText.substring(0, textStart) : displayText;
            drawEnd = render.drawString(this.formatter.apply(drawString, this.displayPos), drawX, drawY, colour, (boolean)this.shadow.get());
        }
        boolean flag2 = this.cursorPos < value.length() || value.length() >= this.getMaxLength();
        int k1 = drawEnd;
        if (!flag) {
            k1 = (int)(textStart > 0 ? drawX + this.xSize() : drawX);
        } else if (flag2) {
            k1 = drawEnd - 1;
            --drawEnd;
        }
        if (!displayText.isEmpty() && flag && textStart < displayText.length()) {
            render.drawString(this.formatter.apply(displayText.substring(textStart), this.cursorPos), (double)drawEnd, drawY, colour, (boolean)this.shadow.get());
        }
        if (this.suggestion != null && value.isEmpty()) {
            render.drawString(this.suggestion.get(), (double)(k1 - 1), (double)((float)drawY), (int)this.suggestionColour.get(), (boolean)this.suggestionShadow.get());
        }
        if (cursorBlink) {
            if (flag2) {
                render.fill(k1, drawY - 1.0, k1 + 1, drawY + 1.0 + 9.0, -3092272);
            } else {
                render.drawString("_", (double)k1, (double)((float)drawY), colour, (boolean)this.shadow.get());
            }
        }
        if (highlightStart != textStart) {
            int l1 = (int)(drawX + (double)this.font().method_1727(displayText.substring(0, highlightStart)));
            render.pose().method_22904(0.0, 0.0, 0.035);
            render.fill(HIGHLIGHT_TYPE, k1, drawY - 1.0, l1 - 1, drawY + 1.0 + 9.0, -16776961);
            render.pose().method_22904(0.0, 0.0, -0.035);
        }
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        ++this.tick;
    }

    public static Assembly<GuiRectangle, GuiTextField> create(GuiElement<?> parent, int backgroundColour, int borderColour, int textColour) {
        GuiRectangle background = new GuiRectangle(parent).rectangle(backgroundColour, borderColour);
        GuiTextField textField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField(background).setTextColor(textColour).constrain(GeoParam.TOP, Constraint.relative(background.get(GeoParam.TOP), 1.0))).constrain(GeoParam.BOTTOM, Constraint.relative(background.get(GeoParam.BOTTOM), -1.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        return new Assembly<GuiRectangle, GuiTextField>(background, textField);
    }
}

