/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class FluidStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.showDetails() && config.get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return;
        }
        if (!accessor.getServerData().method_10545("JadeFluidStorage")) {
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeFluidStorageUid"))).map(WailaClientRegistration.instance().fluidStorageProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeFluidStorage", Function.identity()));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (FluidView view : group.views) {
                class_2561 text;
                IWailaConfig.HandlerDisplayStyle style = (IWailaConfig.HandlerDisplayStyle)config.getEnum(JadeIds.UNIVERSAL_FLUID_STORAGE_STYLE);
                if (view.overrideText != null) {
                    text = view.overrideText;
                } else if (view.fluidName == null) {
                    text = IThemeHelper.get().info(view.current);
                } else {
                    class_5250 fluidName = IThemeHelper.get().info(IDisplayHelper.get().stripColor(view.fluidName));
                    text = accessor.showDetails() || style != IWailaConfig.HandlerDisplayStyle.PROGRESS_BAR ? class_2561.method_43469((String)"jade.fluid.with_capacity", (Object[])new Object[]{IThemeHelper.get().info(view.current), view.max}) : IThemeHelper.get().info(view.current);
                    String key = style == IWailaConfig.HandlerDisplayStyle.PLAIN_TEXT ? "jade.fluid.text" : "jade.fluid";
                    text = class_2561.method_43469((String)key, (Object[])new Object[]{fluidName, text});
                }
                switch (style) {
                    case PLAIN_TEXT: {
                        theTooltip.add(text);
                        break;
                    }
                    case ICON: {
                        theTooltip.add(helper.smallItem(new class_1799((class_1935)class_1802.field_8550)));
                        theTooltip.append(text);
                        break;
                    }
                    case PROGRESS_BAR: {
                        ProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                        theTooltip.add(helper.progress(view.ratio, text, progressStyle, BoxStyle.getNestedBox(), true));
                    }
                }
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        Map.Entry entry = CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().fluidStorageProviders);
        if (entry == null) {
            return;
        }
        class_2487 tag = accessor.getServerData();
        ViewGroup.saveList(tag, "JadeFluidStorage", entry.getValue(), Function.identity());
        tag.method_10582("JadeFluidStorageUid", entry.getKey().toString());
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        FluidStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, T accessor) {
        FluidStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (!accessor.showDetails() && IWailaConfig.get().getPlugin().get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return false;
        }
        return WailaCommonRegistration.instance().fluidStorageProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<class_2487>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    public static class ForBlock
    extends FluidStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends FluidStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<class_2487>,
    IClientExtensionProvider<class_2487, FluidView>
    {
        INSTANCE;


        @Override
        public class_2960 getUid() {
            return JadeIds.UNIVERSAL_FLUID_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_2487>> groups) {
            return ClientViewGroup.map(groups, FluidView::readDefault, null);
        }

        @Override
        @Nullable
        public List<ViewGroup<class_2487>> getGroups(Accessor<?> accessor) {
            return CommonProxy.wrapFluidStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultFluidStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

