/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.core.search.CombinedSearchables;
import mezz.jei.core.search.ISearchStorage;
import mezz.jei.core.search.ISearchable;
import mezz.jei.core.search.PrefixInfo;
import mezz.jei.core.search.PrefixedSearchable;
import mezz.jei.core.search.SearchMode;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.IListElementInfo;
import mezz.jei.gui.search.ElementPrefixParser;
import mezz.jei.gui.search.IElementSearch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ElementSearch
implements IElementSearch {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<PrefixInfo<IListElementInfo<?>, IListElement<?>>, PrefixedSearchable<IListElementInfo<?>, IListElement<?>>> prefixedSearchables = new IdentityHashMap();
    private final CombinedSearchables<IListElement<?>> combinedSearchables = new CombinedSearchables();
    private final Map<Object, IListElement<?>> allElements = new HashMap();

    public ElementSearch(ElementPrefixParser elementPrefixParser) {
        for (PrefixInfo<IListElementInfo<?>, IListElement<?>> prefixInfo : elementPrefixParser.allPrefixInfos()) {
            ISearchStorage<IListElement<?>> storage = prefixInfo.createStorage();
            PrefixedSearchable prefixedSearchable = new PrefixedSearchable(storage, prefixInfo);
            this.prefixedSearchables.put(prefixInfo, prefixedSearchable);
            this.combinedSearchables.addSearchable(prefixedSearchable);
        }
    }

    @Override
    public Set<IListElement<?>> getSearchResults(ElementPrefixParser.TokenInfo tokenInfo) {
        ISearchable searchable;
        Set<IListElement<?>> results;
        String token;
        block6: {
            block5: {
                token = tokenInfo.token();
                if (token.isEmpty()) {
                    return Set.of();
                }
                results = Collections.newSetFromMap(new IdentityHashMap());
                PrefixInfo<IListElementInfo<?>, IListElement<?>> prefixInfo = tokenInfo.prefixInfo();
                if (prefixInfo == ElementPrefixParser.NO_PREFIX) {
                    this.combinedSearchables.getSearchResults(token, results::addAll);
                    return results;
                }
                searchable = this.prefixedSearchables.get(prefixInfo);
                if (searchable == null) break block5;
                if (searchable.getMode() != SearchMode.DISABLED) break block6;
            }
            this.combinedSearchables.getSearchResults(token, results::addAll);
            return results;
        }
        searchable.getSearchResults(token, results::addAll);
        return results;
    }

    @Override
    public <T> void add(IListElementInfo<T> info, IIngredientManager ingredientManager) {
        IListElement<T> element = info.getElement();
        Object uid = ElementSearch.getUid(element.getTypedIngredient(), ingredientManager);
        this.allElements.put(uid, element);
        for (PrefixedSearchable<IListElementInfo<?>, IListElement<?>> prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            Collection<String> strings = prefixedSearchable.getStrings(info);
            ISearchStorage<IListElement<?>> storage = prefixedSearchable.getSearchStorage();
            for (String string : strings) {
                storage.put(string, element);
            }
        }
    }

    private static <T> Object getUid(ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(typedIngredient.getType());
        return ingredientHelper.getUid(typedIngredient.getIngredient(), UidContext.Ingredient);
    }

    @Override
    public void addAll(Collection<IListElementInfo<?>> infos, IIngredientManager ingredientManager) {
        for (IListElementInfo<?> iListElementInfo : infos) {
            IListElement<?> element = iListElementInfo.getElement();
            Object uid = ElementSearch.getUid(iListElementInfo.getTypedIngredient(), ingredientManager);
            this.allElements.put(uid, element);
        }
        for (PrefixedSearchable prefixedSearchable : this.prefixedSearchables.values()) {
            SearchMode searchMode = prefixedSearchable.getMode();
            if (searchMode == SearchMode.DISABLED) continue;
            ISearchStorage storage = prefixedSearchable.getSearchStorage();
            for (IListElementInfo<?> info : infos) {
                Collection<String> strings = prefixedSearchable.getStrings(info);
                for (String string : strings) {
                    storage.put(string, info.getElement());
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> IListElement<T> findElement(ITypedIngredient<T> ingredient, IIngredientHelper<T> ingredientHelper) {
        Object ingredientUid = ingredientHelper.getUid(ingredient.getIngredient(), UidContext.Ingredient);
        IListElement<?> listElement = this.allElements.get(ingredientUid);
        if (listElement != null && listElement.getTypedIngredient().getType().equals(ingredient.getType())) {
            IListElement<?> cast = listElement;
            return cast;
        }
        return null;
    }

    @Override
    public Collection<IListElement<?>> getAllIngredients() {
        return Collections.unmodifiableCollection(this.allElements.values());
    }

    @Override
    public void logStatistics() {
        this.prefixedSearchables.forEach((prefixInfo, value) -> {
            if (prefixInfo.getMode() != SearchMode.DISABLED) {
                ISearchStorage storage = value.getSearchStorage();
                LOGGER.info("ElementSearch {} Storage Stats: {}", prefixInfo, (Object)storage.statistics());
            }
        });
    }
}

