/*
 * Decompiled with CFR 0.152.
 */
package com.github.cargocats.init;

import com.github.cargocats.DisplayDelight;
import com.github.cargocats.block.DrinkFoodBlock;
import com.github.cargocats.block.EmptyPlatedFoodBlock;
import com.github.cargocats.block.EmptySmallPlatedFoodBlock;
import com.github.cargocats.block.FoodBlock;
import com.github.cargocats.block.HotDrinkFoodBlock;
import com.github.cargocats.block.PlatedFoodBlock;
import com.github.cargocats.block.SmallPlatedFoodBlock;
import com.github.cargocats.block.WideFoodBlock;
import com.github.cargocats.block.fiery.FieryFoodBlock;
import com.github.cargocats.block.fiery.FieryPlatedFoodBlock;
import com.github.cargocats.block.fiery.FierySmallPlatedFoodBlock;
import com.github.cargocats.block.fiery.FieryWideFoodBlock;
import com.github.cargocats.util.DisplayDelightAssociations;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class DisplayDelightBlocks {
    public static final ArrayList<class_2248> DISPLAYABLE_BLOCKS = new ArrayList();
    public static final ArrayList<class_2248> PLATEABLE_BLOCKS = new ArrayList();
    public static final ArrayList<class_2248> SMALL_PLATEABLE_BLOCKS = new ArrayList();
    public static final class_2248 SMALL_EMPTY_PLATE = DisplayDelightBlocks.register("small_food_plate", EmptySmallPlatedFoodBlock::new, DisplayDelightBlocks.baseBlockSettings());
    public static final class_2248 EMPTY_PLATE = DisplayDelightBlocks.register("food_plate", EmptyPlatedFoodBlock::new, DisplayDelightBlocks.baseBlockSettings());
    public static final class_2248 MUSHROOM_STEW = DisplayDelightBlocks.createFoodBlock("vna_mushroom_stew");
    public static final class_2248 RABBIT_STEW = DisplayDelightBlocks.createFoodBlock("vna_rabbit_stew");
    public static final class_2248 BEETROOT_STEW = DisplayDelightBlocks.createFoodBlock("vna_beetroot_soup");
    public static final class_2248 PLATED_COOKIE = DisplayDelightBlocks.createStackablePlatedBlock("vna_plated_cookie", 4);
    public static final class_2248 PLATED_PUMPKIN_PIE = DisplayDelightBlocks.createPlatedBlock("vna_plated_pumpkin_pie");

    public static void init() {
        DisplayDelight.LOG.info("Initialized Display Delight Blocks");
    }

    public static class_2248 createFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new FoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createWideFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new WideFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createDrinkFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new DrinkFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings().method_9626(class_2498.field_11537));
    }

    public static class_2248 createHotDrinkFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new HotDrinkFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings().method_9626(class_2498.field_11537));
    }

    public static class_2248 createFieryFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new FieryFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createFieryWideFoodBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new FieryWideFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createDrinkFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createDrinkFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createHotDrinkFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createHotDrinkFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createFieryFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createFieryFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createFieryWideFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createFieryWideFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createWideFoodBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createWideFoodBlock(name, DisplayDelightAssociations.getId(name));
        DISPLAYABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createSmallPlatedBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new SmallPlatedFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createFierySmallPlatedBlock(String name, class_2960 foodItemId) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new FierySmallPlatedFoodBlock(foodItemId, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createSmallPlatedBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createSmallPlatedBlock(name, DisplayDelightAssociations.getId(name));
        SMALL_PLATEABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createFierySmallPlatedBlock(String name) {
        class_2248 block = DisplayDelightBlocks.createFierySmallPlatedBlock(name, DisplayDelightAssociations.getId(name));
        SMALL_PLATEABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createStackablePlatedBlock(String name, class_2960 foodItemId, int maxStacks) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new PlatedFoodBlock(foodItemId, maxStacks, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createFieryStackablePlatedBlock(String name, class_2960 foodItemId, int maxStacks) {
        return DisplayDelightBlocks.register(name, (class_4970.class_2251 settings) -> new FieryPlatedFoodBlock(foodItemId, maxStacks, (class_4970.class_2251)settings), DisplayDelightBlocks.baseBlockSettings());
    }

    public static class_2248 createStackablePlatedBlock(String name, int maxStacks) {
        class_2248 block = DisplayDelightBlocks.createStackablePlatedBlock(name, DisplayDelightAssociations.getId(name), maxStacks);
        PLATEABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createFieryStackablePlatedBlock(String name, int maxStacks) {
        class_2248 block = DisplayDelightBlocks.createFieryStackablePlatedBlock(name, DisplayDelightAssociations.getId(name), maxStacks);
        PLATEABLE_BLOCKS.add(block);
        return block;
    }

    public static class_2248 createPlatedBlock(String name) {
        return DisplayDelightBlocks.createStackablePlatedBlock(name, 1);
    }

    public static class_4970.class_2251 baseBlockSettings() {
        return class_4970.class_2251.method_9637().method_22488().method_9618().method_50012(class_3619.field_15971).method_9626(class_2498.field_11547);
    }

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return DisplayDelightBlocks.register(DisplayDelightBlocks.keyOf(id), factory, settings);
    }

    private static class_5321<class_2248> keyOf(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)DisplayDelight.id(id));
    }

    public static class_2248 register(class_5321<class_2248> key, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        class_2248 block = factory.apply(settings);
        return (class_2248)class_2378.method_39197((class_2378)class_7923.field_41175, key, (Object)block);
    }
}

