/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.sweenus.simplyswords.recipe.RawUpgradableRecipe;
import net.sweenus.simplyswords.registry.RecipeTypeRegistry;

public class UpgradeUniqueRecipe
extends class_1869 {
    private final int upgradableItemSlot;
    private final class_1799 result;
    private final RawUpgradableRecipe raw;

    public UpgradeUniqueRecipe(String group, class_7710 category, RawUpgradableRecipe raw, class_1799 result, boolean showNotification) {
        super(group, category, null, result, showNotification);
        this.raw = raw;
        this.result = result;
        this.upgradableItemSlot = raw.getUpgradableItemSlot();
    }

    public boolean method_8113(int width, int height) {
        return width >= this.raw.getWidth() && height >= this.raw.getHeight();
    }

    public class_2371<class_1856> method_8117() {
        return this.raw.getIngredients();
    }

    public int method_8158() {
        return this.raw.getHeight();
    }

    public int method_8150() {
        return this.raw.getWidth();
    }

    public boolean method_17728(class_9694 craftingRecipeInput, class_1937 world) {
        return this.raw.matches(craftingRecipeInput);
    }

    public class_1799 method_17727(class_9694 craftingRecipeInput, class_7225.class_7874 wrapperLookup) {
        int slot = this.upgradableItemSlot;
        if (this.raw.isMirrored()) {
            int width = this.method_8150();
            int x = slot % width;
            int y = slot / width;
            slot = y * width + (width - 1 - x);
        }
        class_1799 result = this.result.method_7972();
        result.method_57365(craftingRecipeInput.method_59984(slot).method_57353());
        return result;
    }

    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.UNIQUE_UPGRADE.get();
    }

    public static class Serializer
    implements class_1865<UpgradeUniqueRecipe> {
        public static final MapCodec<UpgradeUniqueRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1869::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1869::method_45441), (App)RawUpgradableRecipe.CODEC.forGetter(recipe -> recipe.raw), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(class_1869::method_49188)).apply((Applicative)instance, UpgradeUniqueRecipe::new));
        public static final class_9139<class_9129, UpgradeUniqueRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<UpgradeUniqueRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, UpgradeUniqueRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static UpgradeUniqueRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)buf.method_10818(class_7710.class);
            RawUpgradableRecipe rawShapedRecipe = (RawUpgradableRecipe)RawUpgradableRecipe.PACKET_CODEC.decode((Object)buf);
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            boolean bl = buf.readBoolean();
            return new UpgradeUniqueRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, bl);
        }

        private static void write(class_9129 buf, UpgradeUniqueRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817((Enum)recipe.method_45441());
            RawUpgradableRecipe.PACKET_CODEC.encode((Object)buf, (Object)recipe.raw);
            class_1799.field_48349.encode((Object)buf, (Object)recipe.result);
            buf.method_52964(recipe.method_49188());
        }
    }
}

