/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class TempestSwordItem
extends UniqueSwordItem {
    public TempestSwordItem(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!attacker.method_37908().method_8608()) {
            int vortexMaxStacks = Config.uniqueEffects.tempest.maxStacks;
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            HelperMethods.playHitSounds(attacker, target);
            ArrayList<class_3414> sounds = new ArrayList<class_3414>();
            sounds.add((class_3414)SoundRegistry.SPELL_FIRE.get());
            sounds.add((class_3414)SoundRegistry.ELEMENTAL_SWORD_WATER_ATTACK_03.get());
            sounds.add((class_3414)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get());
            sounds.add((class_3414)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_02.get());
            ArrayList<class_2400> particles = new ArrayList<class_2400>();
            particles.add(class_2398.field_11251);
            particles.add(class_2398.field_11204);
            particles.add(class_2398.field_11251);
            particles.add(class_2398.field_11204);
            ArrayList<class_6880<class_1291>> status = new ArrayList<class_6880<class_1291>>();
            status.add(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
            status.add(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
            int random = attacker.method_59922().method_43048(3);
            class_3414 soundSelect = (class_3414)sounds.get(random);
            class_2394 particleSelect = (class_2394)particles.get(random);
            class_6880 statusSelect = (class_6880)status.get(random);
            int particleCount = 10;
            HelperMethods.spawnWaistHeightParticles(serverWorld, particleSelect, (class_1297)attacker, (class_1297)target, particleCount);
            serverWorld.method_8396(null, attacker.method_24515(), soundSelect, attacker.method_5634(), 0.2f, 1.3f);
            SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(target, (class_6880<class_1291>)statusSelect, 500, 1, vortexMaxStacks);
            effect.setSourceEntity(attacker);
            effect.setAdditionalData((int)HelperMethods.getEntityAttackDamage(attacker) / 3);
            target.method_6092((class_1293)effect);
        }
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_37908().method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            int vortexMaxSize = Config.uniqueEffects.tempest.maxSize;
            int vortexDuration = Config.uniqueEffects.tempest.duration;
            int skillCooldown = 200;
            class_238 box = HelperMethods.createBox((class_1297)user, 15.0);
            boolean soundHasPlayed = false;
            for (class_1297 entity : serverWorld.method_8333((class_1297)user, box, class_1301.field_6157)) {
                class_1309 le;
                if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, (class_1309)user) || !le.method_6059(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX)) || !le.method_6059(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX))) continue;
                class_1293 frostVortex = le.method_6112(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
                class_1293 fireVortex = le.method_6112(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
                int totalAmplifier = 0;
                if (fireVortex != null && frostVortex != null) {
                    totalAmplifier = fireVortex.method_5578() + frostVortex.method_5578();
                }
                int particleCount = 10;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (class_2394)class_2398.field_11204, (class_1297)le, (class_1297)user, particleCount);
                if (!soundHasPlayed) {
                    serverWorld.method_8396(null, le.method_24515(), (class_3414)SoundRegistry.MAGIC_SHAMANIC_NORDIC_22.get(), le.method_5634(), 0.4f, 1.3f);
                    soundHasPlayed = true;
                }
                SimplySwordsStatusEffectInstance status = HelperMethods.incrementSimplySwordsStatusEffect((class_1309)user, EffectRegistry.getReference(EffectRegistry.ELEMENTAL_VORTEX), vortexDuration, totalAmplifier, vortexMaxSize);
                status.setAdditionalData(Math.max(1, totalAmplifier));
                status.setSourceEntity((class_1309)user);
                le.method_6016(EffectRegistry.getReference(EffectRegistry.FIRE_VORTEX));
                le.method_6016(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
                user.method_7357().method_7906((class_1792)this, skillCooldown);
            }
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (class_2394)class_2398.field_46763, (class_2394)class_2398.field_46763, (class_2394)class_2398.field_46763, true);
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip1").method_10862(Styles.ABILITY));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip2").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip3").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip4").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip5").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip6").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclick").method_10862(Styles.RIGHT_CLICK));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip7").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip8").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip9").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip10").method_10862(Styles.TEXT));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.tempestsworditem.tooltip11").method_10862(Styles.TEXT));
        super.method_7851(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "frost_fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedInt.Restrict(min=1)
        public int maxSize;
        @ValidatedInt.Restrict(min=1)
        public int maxStacks;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.TEMPEST.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.duration = 1200;
            this.maxSize = 30;
            this.maxStacks = 10;
            this.spellScaling = 0.3f;
        }
    }
}

